/*
 * Decompiled with CFR 0.152.
 */
package org.papoose.event;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.cert.X509Certificate;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.event.Event;
import org.papoose.event.EventAdminServiceFactory;

class FrameworkEventMapper
implements FrameworkListener {
    private static final String CLASS_NAME = FrameworkEventMapper.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private final EventAdminServiceFactory eventAdmin;

    FrameworkEventMapper(EventAdminServiceFactory eventAdmin) {
        assert (eventAdmin != null);
        this.eventAdmin = eventAdmin;
    }

    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        Throwable throwable;
        String topic;
        LOGGER.entering(CLASS_NAME, "frameworkEvent", frameworkEvent);
        switch (frameworkEvent.getType()) {
            case 1: {
                topic = "org/osgi/framework/FrameworkEvent/STARTED";
                break;
            }
            case 2: {
                topic = "org/osgi/framework/FrameworkEvent/ERROR";
                break;
            }
            case 4: {
                topic = "org/osgi/framework/FrameworkEvent/PACKAGES_REFRESHED";
                break;
            }
            case 8: {
                topic = "org/osgi/framework/FrameworkEvent/STARTLEVEL_CHANGED";
                break;
            }
            case 16: {
                topic = "org/osgi/framework/FrameworkEvent/WARNING";
                break;
            }
            case 32: {
                topic = "org/osgi/framework/FrameworkEvent/INFO";
                break;
            }
            default: {
                return;
            }
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("event", frameworkEvent);
        Bundle bundle = frameworkEvent.getBundle();
        if (bundle != null) {
            ((Dictionary)properties).put("bundle.id", bundle.getBundleId());
            if (bundle.getSymbolicName() != null) {
                ((Dictionary)properties).put("bundle.symbolicName", bundle.getSymbolicName());
            }
            if (bundle.getVersion() != null) {
                ((Dictionary)properties).put("bundle.version", bundle.getVersion());
            }
            ((Dictionary)properties).put("bundle", bundle);
            Map certificates = bundle.getSignerCertificates(1);
            if (certificates != null && !certificates.keySet().isEmpty()) {
                HashSet<String> signers = new HashSet<String>();
                for (X509Certificate certificate : certificates.keySet()) {
                    signers.add(certificate.getSubjectDN().getName());
                }
                if (signers.size() == 1) {
                    ((Dictionary)properties).put("bundle.signer", signers.iterator().next());
                } else {
                    ((Dictionary)properties).put("bundle.signer", signers);
                }
            }
        }
        if ((throwable = frameworkEvent.getThrowable()) != null) {
            ((Dictionary)properties).put("exception.class", throwable.getClass().getName());
            if (throwable.getMessage() != null) {
                ((Dictionary)properties).put("exception.message", throwable.getMessage());
            }
            ((Dictionary)properties).put("exception", throwable);
        }
        Event event = new Event(topic, properties);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Posting event " + event);
        }
        this.eventAdmin.postEvent(event);
        LOGGER.exiting(CLASS_NAME, "frameworkEvent");
    }
}

