/*
 * Decompiled with CFR 0.152.
 */
package org.papoose.event;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;
import org.papoose.core.Papoose;
import org.papoose.event.EventAdminServiceFactory;
import org.papoose.event.SecureEventAdminServiceFactory;
import org.papoose.event.util.Util;

public class PapooseBootLevelService {
    private static final String CLASS_NAME = PapooseBootLevelService.class.getName();
    public static final String EVENT_ADMIN_SERVICE_USE_SECURE = CLASS_NAME + ".useSecure";
    public static final String EVENT_ADMIN_SERVICE_USE_PAPOOSE_THREAD_POOL = CLASS_NAME + ".usePapooseThreadPool";
    public static final String EVENT_ADMIN_SERVICE_CORE_POOL_SIZE = CLASS_NAME + ".corePoolSize";
    public static final String EVENT_ADMIN_SERVICE_MAX_POOL_SIZE = CLASS_NAME + ".maximumPoolSize";
    public static final String EVENT_ADMIN_SERVICE_KEEP_ALIVE_TIME = CLASS_NAME + ".keepAliveTime";
    public static final String EVENT_ADMIN_SERVICE_TIME_UNIT = CLASS_NAME + ".timeUnit";
    public static final String EVENT_ADMIN_SERVICE_SCHEDULE_CORE_POOL_SIZE = CLASS_NAME + ".scheduleCorePoolSize";
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private volatile EventAdminServiceFactory eventAdminService;
    private volatile ServiceRegistration registration;

    public void start(Papoose papoose) {
        ExecutorService executor;
        LOGGER.entering(CLASS_NAME, "start", papoose);
        if (papoose == null) {
            throw new IllegalArgumentException("Papoose instance is null");
        }
        if (this.eventAdminService != null) {
            LOGGER.log(Level.WARNING, "Event Admin service already started");
            return;
        }
        if (papoose.getProperty(EVENT_ADMIN_SERVICE_USE_PAPOOSE_THREAD_POOL) != null) {
            LOGGER.finest("Using Papoose's thread pool");
            executor = papoose.getExecutorService();
        } else {
            int corePoolSize = Util.parseInt(papoose.getProperty(EVENT_ADMIN_SERVICE_CORE_POOL_SIZE), 1);
            int maximumPoolSize = Util.parseInt(papoose.getProperty(EVENT_ADMIN_SERVICE_MAX_POOL_SIZE), 5);
            int keepAliveTime = Util.parseInt(papoose.getProperty(EVENT_ADMIN_SERVICE_KEEP_ALIVE_TIME), 1);
            TimeUnit unit = Util.parseTimeUnit(papoose.getProperty(EVENT_ADMIN_SERVICE_TIME_UNIT), TimeUnit.SECONDS);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Creating own thread pool");
                LOGGER.finest("corePoolSize: " + corePoolSize);
                LOGGER.finest("maximumPoolSize: " + maximumPoolSize);
                LOGGER.finest("keepAliveTime: " + keepAliveTime);
                LOGGER.finest("unit: " + (Object)((Object)unit));
            }
            executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>());
        }
        int scheduleCorePoolSize = Util.parseInt(papoose.getProperty(EVENT_ADMIN_SERVICE_SCHEDULE_CORE_POOL_SIZE), 1);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("scheduleCorePoolSize: " + scheduleCorePoolSize);
        }
        ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(scheduleCorePoolSize);
        BundleContext bundleContext = papoose.getSystemBundleContext();
        this.eventAdminService = Util.parseBoolean(papoose.getProperty(EVENT_ADMIN_SERVICE_USE_SECURE), false) ? new SecureEventAdminServiceFactory(bundleContext, executor, scheduledExecutor) : new EventAdminServiceFactory(bundleContext, executor, scheduledExecutor);
        this.eventAdminService.start();
        this.registration = bundleContext.registerService(EventAdmin.class.getName(), (Object)this.eventAdminService, null);
        LOGGER.exiting(CLASS_NAME, "start");
    }

    public void stop() {
        LOGGER.entering(CLASS_NAME, "stop");
        if (this.eventAdminService == null) {
            LOGGER.log(Level.WARNING, "Event Admin service already stopped");
            return;
        }
        this.registration.unregister();
        this.registration = null;
        this.eventAdminService.stop();
        this.eventAdminService = null;
        LOGGER.exiting(CLASS_NAME, "stop");
    }
}

