/*
 * Decompiled with CFR 0.152.
 */
package org.papoose.event;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.papoose.event.EventAdminServiceFactory;

class ServiceEventMapper
implements ServiceListener {
    private static final String CLASS_NAME = ServiceEventMapper.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private final EventAdminServiceFactory eventAdmin;

    ServiceEventMapper(EventAdminServiceFactory eventAdmin) {
        assert (eventAdmin != null);
        this.eventAdmin = eventAdmin;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        String topic;
        LOGGER.entering(CLASS_NAME, "serviceChanged", serviceEvent);
        switch (serviceEvent.getType()) {
            case 1: {
                topic = "org/osgi/framework/ServiceEvent/REGISTERED";
                break;
            }
            case 2: {
                topic = "org/osgi/framework/ServiceEvent/MODIFIED";
                break;
            }
            case 4: {
                topic = "org/osgi/framework/ServiceEvent/UNREGISTERING";
                break;
            }
            default: {
                return;
            }
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("event", serviceEvent);
        ServiceReference reference = serviceEvent.getServiceReference();
        ((Dictionary)properties).put("service", reference);
        ((Dictionary)properties).put("service.id", reference.getProperty("service.id"));
        Object servicePid = reference.getProperty("service.pid");
        if (servicePid instanceof String) {
            ((Dictionary)properties).put("service.pid", servicePid);
        } else if (servicePid instanceof String[]) {
            ((Dictionary)properties).put("service.pid", Arrays.asList((String[])servicePid));
        }
        Object objectClass = reference.getProperty("objectClass");
        if (servicePid instanceof String) {
            ((Dictionary)properties).put("service.objectClass", objectClass);
        } else if (servicePid instanceof String[]) {
            ((Dictionary)properties).put("service.objectClass", Arrays.asList((String[])objectClass));
        }
        Event event = new Event(topic, properties);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Posting event " + event);
        }
        this.eventAdmin.postEvent(event);
        LOGGER.entering(CLASS_NAME, "serviceChanged");
    }
}

