/*
 * Decompiled with CFR 0.152.
 */
package org.papoose.event.util;

import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerialExecutor
implements Executor {
    private static final String CLASS_NAME = SerialExecutor.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private final Queue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();
    private final Executor executor;
    private Runnable active;

    public SerialExecutor(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Executor is null");
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("executor: " + executor);
        }
        this.executor = executor;
    }

    public synchronized void execute(final Runnable runnable) {
        LOGGER.entering(CLASS_NAME, "execute", runnable);
        this.tasks.offer(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LOGGER.entering(CLASS_NAME, "execute.Runnable", runnable);
                try {
                    runnable.run();
                }
                finally {
                    SerialExecutor.this.scheduleNext();
                }
                LOGGER.exiting(CLASS_NAME, "execute.Runnable");
            }
        });
        if (this.active == null) {
            this.scheduleNext();
        }
        LOGGER.exiting(CLASS_NAME, "execute");
    }

    protected synchronized void scheduleNext() {
        LOGGER.entering(CLASS_NAME, "scheduleNext");
        this.active = this.tasks.poll();
        if (this.active != null) {
            this.executor.execute(this.active);
        }
        LOGGER.exiting(CLASS_NAME, "scheduleNext");
    }
}

