/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.plugins.italy;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import org.hibernate.annotations.ForeignKey;
import org.parancoe.plugins.italy.Comune;
import org.parancoe.plugins.italy.Regione;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="Provincia.findByPartialNome", query="from Provincia p where upper(p.nome) like upper(?) order by p.nome asc"), @NamedQuery(name="Provincia.findByPartialTarga", query="from Provincia p where upper(p.targa) like upper(?) order by p.targa asc")})
public class Provincia
implements Serializable {
    private static final long serialVersionUID = -8469022923445394832L;
    private String id;
    private String targa;
    private String nome;
    private List<Comune> comune;
    private Regione regione;

    @Id
    @Column(name="codice_istat", length=3)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name="provincia", length=50, unique=true)
    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    @OneToMany(mappedBy="provincia")
    @ForeignKey(name="none")
    public List<Comune> getComuni() {
        return this.comune;
    }

    public void setComuni(List<Comune> comune) {
        this.comune = comune;
    }

    public void addComune(Comune comune) {
        comune.setProvincia(this);
        this.getComuni().add(comune);
    }

    public void removeComune(Comune comune) {
        this.getComuni().remove(comune);
        comune.setProvincia(null);
    }

    @ManyToOne
    @JoinColumn(name="codice_regione")
    @ForeignKey(name="none")
    public Regione getRegione() {
        return this.regione;
    }

    public void setRegione(Regione regione) {
        this.regione = regione;
    }

    @Column(name="sigla", length=2, unique=true)
    public String getTarga() {
        return this.targa;
    }

    public void setTarga(String targa) {
        this.targa = targa;
    }

    public String toString() {
        return "Provincia{id='" + this.id + '\'' + ", targa='" + this.targa + '\'' + ", nome='" + this.nome + '\'' + ", comune=" + this.comune + ", regione=" + this.regione + '}';
    }
}

