/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.plugins.world;

import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import org.parancoe.persistence.po.hibernate.EntityBase;
import org.parancoe.plugins.world.Country;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="Continent.findByPartialName", query="from Continent c where upper(c.name) like upper(?) order by c.name asc")})
public class Continent
extends EntityBase {
    private String name;
    private List<Country> countries;

    @Column(length=32, unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OneToMany(mappedBy="continent")
    public List<Country> getCountries() {
        return this.countries;
    }

    public void setCountries(List<Country> countries) {
        this.countries = countries;
    }

    public void addCountry(Country country) {
        country.setContinent(this);
        this.getCountries().add(country);
    }

    public void removeCountry(Country country) {
        this.getCountries().remove((Object)country);
        country.setContinent(null);
    }

    public String toString() {
        return "Continent{name='" + this.name + '\'' + '}';
    }
}

