/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.parancoe.persistence.dao.DaoProvider;
import org.parancoe.persistence.dao.generic.GenericDao;
import org.parancoe.util.FixtureHelper;
import org.parancoe.web.plugin.Plugin;
import org.parancoe.web.plugin.PluginHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopulateInitialDataContextListener
extends ContextLoaderListener {
    private static final String DAO_PROVIDER_ID = "daos";
    private static final Logger log = Logger.getLogger(PopulateInitialDataContextListener.class);
    private ApplicationContext ctx;

    public void contextInitialized(ServletContextEvent evt) {
        try {
            this.ctx = (ApplicationContext)evt.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            LinkedHashSet<Class> fixtureClasses = new LinkedHashSet<Class>(this.getFixtureClasses());
            if (CollectionUtils.isEmpty(fixtureClasses)) {
                log.info((Object)"Skipping initial data population (no models)");
                return;
            }
            Map fixtures = FixtureHelper.loadFixturesFromResource((String)"fixtures/", fixtureClasses);
            log.info((Object)"Populating initial data for models...");
            for (Class clazz : fixtures.keySet()) {
                if (ArrayUtils.isEmpty((Object[])((Object[])fixtures.get(clazz)))) {
                    log.warn((Object)("Population of " + FixtureHelper.getModelName((Class)clazz) + " skipped (empty fixture file?)"));
                    continue;
                }
                this.populateTableForModel(clazz, (Object[])fixtures.get(clazz));
            }
            fixtures.clear();
            log.info((Object)"Populating initial data for models done!");
        }
        catch (Exception e) {
            log.error((Object)("Error while populating initial data for models " + e.getMessage()), (Throwable)e);
        }
    }

    private List<Class> getFixtureClasses() {
        Collection<Plugin> plugins = new PluginHelper(this.ctx).getPlugins();
        ArrayList<Class> result = new ArrayList<Class>();
        for (Plugin plugin : plugins) {
            try {
                result.addAll(plugin.getFixtureClasses());
            }
            catch (Exception e) {
                log.error((Object)("Impossibile reperire i nomi delle fixtures da caricare per il plugin " + plugin.getName()));
            }
        }
        return result;
    }

    private void populateTableForModel(Class clazz, Object[] fixtures) {
        String fixtureName = FixtureHelper.getModelName((Class)clazz);
        DaoProvider daos = (DaoProvider)this.ctx.getBean(DAO_PROVIDER_ID);
        GenericDao dao = (GenericDao)daos.getDao(clazz);
        int count = dao.findAll().size();
        if (count == 0) {
            log.info((Object)("Populating " + fixtureName + " with " + fixtures.length + " items..."));
            FixtureHelper.populateDbForModel((Class)clazz, (Object[])fixtures, (GenericDao)dao);
            log.info((Object)("Population of " + fixtureName + " done!"));
        } else {
            log.info((Object)("Population of " + fixtureName + " skipped (already populated)"));
        }
    }
}

