/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.servlet.mvc.Controller;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Logger logger = Logger.getLogger(ControllerBeanDefinitionParser.class);
    private BeanDefinitionParserDelegate delegate;
    private ResourcePatternResolver resourceLoader;
    private BeanDefinitionRegistry registry;
    private ParserContext parserContext;
    public static final String BASE_PACKAGE_ATTRIBUTE = "basePackage";
    public static final String PARENT_ATTRIBUTE = "parent";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String packageName = element.getAttribute(BASE_PACKAGE_ATTRIBUTE);
        String parentName = element.getAttribute(PARENT_ATTRIBUTE);
        this.parserContext = parserContext;
        this.delegate = parserContext.getDelegate();
        this.resourceLoader = (ResourcePatternResolver)parserContext.getReaderContext().getReader().getResourceLoader();
        this.registry = parserContext.getReaderContext().getRegistry();
        List<Class> controllerClasses = this.getAllControllerTypeClasses(packageName);
        if (controllerClasses != null) {
            for (Class ctrl : controllerClasses) {
                this.createBeanDefinition(ctrl, parentName);
            }
        }
        return null;
    }

    protected List<Class> getAllControllerTypeClasses(String packageName) {
        ArrayList<Class> result = new ArrayList<Class>();
        try {
            String packagePart = packageName.replace('.', '/');
            String classPattern = "classpath*:/" + packagePart + "/**/*.class";
            Resource[] resources = this.resourceLoader.getResources(classPattern);
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                String fileName = resource.getURL().toString();
                String className = fileName.substring(fileName.indexOf(packagePart), fileName.length() - ".class".length()).replace('/', '.');
                Class<?> type = Class.forName(className);
                if (!Controller.class.isAssignableFrom(type)) continue;
                result.add(type);
            }
        }
        catch (IOException e) {
            this.parserContext.getReaderContext().fatal(e.getMessage(), null, (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            this.parserContext.getReaderContext().fatal(e.getMessage(), null, (Throwable)e);
            return null;
        }
        return result;
    }

    private void createBeanDefinition(Class ctrl, String parent) {
        String id = ctrl.getName();
        BeanDefinitionBuilder rootBuilder = BeanDefinitionBuilder.childBeanDefinition((String)parent);
        rootBuilder.getBeanDefinition().setBeanClass(ctrl);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("registering bean definition: " + rootBuilder.getBeanDefinition().toString()));
        }
        this.registry.registerBeanDefinition(id, (BeanDefinition)rootBuilder.getBeanDefinition());
    }
}

