/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web.controller;

import java.util.Map;
import org.apache.log4j.Logger;
import org.parancoe.util.Utils;
import org.parancoe.web.controller.annotation.DefaultUrlMapping;
import org.parancoe.web.controller.annotation.MultiUrlMapping;
import org.parancoe.web.controller.annotation.UrlMapping;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.mvc.Controller;

public class AnnotationHandlerMapping
extends BeanNameUrlHandlerMapping {
    private String defaultExtension = "html";
    private static final Logger logger = Logger.getLogger(AnnotationHandlerMapping.class);

    public void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        this.registerHandlers();
    }

    public void setDefaultExtension(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    protected void registerHandlers() {
        Map controllersMap = this.getApplicationContext().getBeansOfType(Controller.class);
        for (Controller ctrl : controllersMap.values()) {
            UrlMapping urlMapping;
            int i;
            MultiUrlMapping multiUrlMappingAnn;
            UrlMapping urlMappingAnn;
            logger.info((Object)("processing controller: " + ctrl.getClass().getSimpleName()));
            String defaultUrl = null;
            if (ctrl.getClass().isAnnotationPresent(DefaultUrlMapping.class)) {
                defaultUrl = this.getDefaultUrlFromControllerName(ctrl.getClass().getSimpleName());
            } else if (ctrl.getClass().getSuperclass().isAnnotationPresent(DefaultUrlMapping.class)) {
                defaultUrl = this.getDefaultUrlFromControllerName(ctrl.getClass().getSuperclass().getSimpleName());
            }
            if (defaultUrl != null) {
                this.registerUrlIfNotPresent(ctrl, defaultUrl);
            }
            if (ctrl.getClass().isAnnotationPresent(UrlMapping.class)) {
                urlMappingAnn = ctrl.getClass().getAnnotation(UrlMapping.class);
                this.mapUrl(ctrl, urlMappingAnn, false);
            } else if (ctrl.getClass().getSuperclass().isAnnotationPresent(UrlMapping.class)) {
                urlMappingAnn = ctrl.getClass().getSuperclass().getAnnotation(UrlMapping.class);
                this.mapUrl(ctrl, urlMappingAnn, true);
            }
            if (ctrl.getClass().isAnnotationPresent(MultiUrlMapping.class)) {
                multiUrlMappingAnn = ctrl.getClass().getAnnotation(MultiUrlMapping.class);
                for (i = 0; i < multiUrlMappingAnn.values().length; ++i) {
                    urlMapping = multiUrlMappingAnn.values()[i];
                    this.mapUrl(ctrl, urlMapping, false);
                }
                continue;
            }
            if (!ctrl.getClass().getSuperclass().isAnnotationPresent(MultiUrlMapping.class)) continue;
            multiUrlMappingAnn = ctrl.getClass().getSuperclass().getAnnotation(MultiUrlMapping.class);
            for (i = 0; i < multiUrlMappingAnn.values().length; ++i) {
                urlMapping = multiUrlMappingAnn.values()[i];
                this.mapUrl(ctrl, urlMapping, true);
            }
        }
    }

    private void mapUrl(Controller ctrl, UrlMapping urlMappingAnn, boolean fromSuperclass) throws BeansException, IllegalStateException {
        String url = urlMappingAnn.value();
        if (url == null || url.trim().equals("")) {
            url = fromSuperclass ? this.getDefaultUrlFromControllerName(ctrl.getClass().getSuperclass().getSimpleName()) : this.getDefaultUrlFromControllerName(ctrl.getClass().getSimpleName());
            logger.info((Object)"value from annotation was null or empty --> provided a default value");
        }
        this.registerUrlIfNotPresent(ctrl, url);
    }

    private String getDefaultUrlFromControllerName(String ctrlName) {
        String[] values = Utils.uncamelize((String)ctrlName);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < values.length - 1; ++i) {
            sb.append("/");
            sb.append(values[i]);
        }
        sb.append("/*.").append(this.defaultExtension);
        return sb.toString();
    }

    private void registerUrlIfNotPresent(Controller ctrl, String url) throws IllegalStateException, BeansException {
        if (!this.getHandlerMap().containsKey(url)) {
            logger.info((Object)("registering handler [" + ctrl.getClass().getSimpleName() + "] for url [" + url + "]"));
            this.registerHandler(url, ctrl);
        }
    }
}

