/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web.test;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.parancoe.persistence.dao.DaoUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class DefaultTestContextHolder {
    private static final Logger logger = Logger.getLogger(DefaultTestContextHolder.class);
    private static WebApplicationContext context = null;

    private DefaultTestContextHolder() {
    }

    public static WebApplicationContext getTestContext() {
        return context;
    }

    static {
        try {
            ArrayList<String> config = new ArrayList<String>();
            config.add("classpath:org/parancoe/persistence/dao/generic/genericDao.xml");
            config.add("classpath:org/parancoe/web/parancoeBase.xml");
            config.add("src/main/webapp/WEB-INF/parancoe-servlet.xml");
            config.add("src/main/webapp/WEB-INF/database.xml");
            config.add("src/test/resources/spring-test.xml");
            config.add("classpath*:parancoe-plugin.xml");
            FileSystemResourceLoader rl = new FileSystemResourceLoader();
            MockServletContext servletContext = new MockServletContext((ResourceLoader)rl);
            XmlWebApplicationContext ctx = new XmlWebApplicationContext();
            ctx.setServletContext((ServletContext)servletContext);
            ctx.setConfigLocations(config.toArray(new String[config.size()]));
            ctx.refresh();
            Map daoMap = (Map)ctx.getBean("daoMap");
            Map daos = DaoUtils.getDaos((ListableBeanFactory)ctx);
            daoMap.putAll(daos);
            context = ctx;
        }
        catch (Throwable e) {
            logger.error((Object)"Error building default test context", e);
        }
    }
}

