/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web.validation;

import org.apache.log4j.Logger;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springmodules.validation.bean.BeanValidator;
import org.springmodules.validation.bean.conf.BeanValidationConfiguration;
import org.springmodules.validation.bean.conf.loader.BeanValidationConfigurationLoader;
import org.springmodules.validation.bean.conf.loader.annotation.AnnotationBeanValidationConfigurationLoader;
import org.springmodules.validation.bean.converter.ErrorCodeConverter;
import org.springmodules.validation.bean.converter.ModelAwareErrorCodeConverter;
import org.springmodules.validation.bean.rule.ValidationRule;

public class DWRAnnotationValidator
extends BeanValidator
implements ApplicationContextAware {
    private static final Logger logger = Logger.getLogger(DWRAnnotationValidator.class);
    private BeanValidationConfigurationLoader configurationLoader;
    private ErrorCodeConverter errorCodeConverter;
    private ApplicationContext applicationContext;

    public DWRAnnotationValidator() {
        this((BeanValidationConfigurationLoader)new AnnotationBeanValidationConfigurationLoader());
    }

    public DWRAnnotationValidator(BeanValidationConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
        this.errorCodeConverter = new ModelAwareErrorCodeConverter();
    }

    public String validateDWR(String controllerId, String propertyName, String propertyValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException(propertyName);
        }
        SimpleFormController ctrl = (SimpleFormController)this.applicationContext.getBean(controllerId);
        BeanWrapperImpl bw = new BeanWrapperImpl((Object)ctrl);
        Class clazz = (Class)bw.getPropertyValue("commandClass");
        BeanValidationConfiguration configuration = this.configurationLoader.loadConfiguration(clazz);
        ValidationRule[] rules = configuration.getPropertyRules(propertyName);
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Can't instantiate class", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Instantiation is forbidden for this class", e);
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(obj);
        if (ctrl.getPropertyEditorRegistrars() != null) {
            for (PropertyEditorRegistrar elem : ctrl.getPropertyEditorRegistrars()) {
                logger.info((Object)"registering custom editors");
                elem.registerCustomEditors((PropertyEditorRegistry)wrapper);
            }
        } else {
            logger.info((Object)"no custom editor to register");
        }
        PropertyValue val = new PropertyValue(propertyName, (Object)propertyValue);
        wrapper.setPropertyValue(val);
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult(obj, controllerId);
        this.validateAndShortCircuitRules(rules, propertyName, obj, (Errors)errors);
        return this.getValidationMessage((Errors)errors, propertyName);
    }

    protected String getValidationMessage(Errors errors, String fieldName) {
        String message = null;
        FieldError fieldError = errors.getFieldError(fieldName);
        if (fieldError != null) {
            MessageSource msgSrc = (MessageSource)this.applicationContext.getBean("messageSource");
            Object[] par = fieldError.getArguments();
            message = msgSrc.getMessage(fieldError.getCode(), par, LocaleContextHolder.getLocale());
        }
        return message;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

