/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.parancoe.persistence.dao.DaoUtils;
import org.parancoe.util.BaseConf;
import org.parancoe.util.MemoryAppender;
import org.parancoe.web.plugin.PluginHelper;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ContextListener
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(ContextListener.class);
    private ServletContext servletContext;
    private XmlWebApplicationContext applicationContext;

    public void contextInitialized(ServletContextEvent evt) {
        try {
            this.servletContext = evt.getServletContext();
            MemoryAppender.clean();
            log.info((Object)"loading custom Spring WebApplicationContext");
            this.loadApplicationContext();
            PluginHelper helper = new PluginHelper((ApplicationContext)this.applicationContext);
            helper.initApplicationContextPlugins();
            helper.invokePluginContextInitialized(evt);
            log.info((Object)("### Starting up Parancoe in " + BaseConf.getEnv() + " mode."));
        }
        catch (Exception e) {
            log.error((Object)"Error in base ContextListener.contextInitialized", (Throwable)e);
        }
    }

    private void loadApplicationContext() {
        ArrayList<String> config = new ArrayList<String>();
        config.add("classpath:org/parancoe/persistence/dao/generic/genericDao.xml");
        config.add("classpath:org/parancoe/persistence/applicationContextBase.xml");
        config.add("WEB-INF/database.xml");
        config.add("WEB-INF/applicationContext.xml");
        config.add("classpath*:applicationContext-plugin.xml");
        XmlWebApplicationContext ctx = new XmlWebApplicationContext();
        ctx.setServletContext(this.servletContext);
        ctx.setConfigLocations(config.toArray(new String[config.size()]));
        ctx.refresh();
        this.servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ctx);
        this.applicationContext = ctx;
        this.populateDaoMap(ctx);
    }

    public void contextDestroyed(ServletContextEvent evt) {
        new PluginHelper((ApplicationContext)this.applicationContext).invokePluginContextDestroyed(evt);
        log.info((Object)("### Shutting down Parancoe in " + BaseConf.getEnv() + " mode."));
    }

    private void populateDaoMap(XmlWebApplicationContext ctx) {
        Map daoMap = (Map)ctx.getBean("daoMap");
        Map daos = DaoUtils.getDaos((ListableBeanFactory)ctx);
        daoMap.putAll(daos);
    }
}

