/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ParancoeOpenSessionInViewInterceptor
implements HandlerInterceptor {
    private static final Logger logger = Logger.getLogger((String)ParancoeOpenSessionInViewInterceptor.class.getPackage().getName());
    @Autowired
    private SessionFactory sessionFactory;

    public boolean preHandle(HttpServletRequest req, HttpServletResponse res, Object handler) throws Exception {
        logger.debug((Object)"Opening session and beginning transaction");
        Session session = this.sessionFactory.openSession();
        session.beginTransaction();
        if (!TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder((org.hibernate.Session)session));
            TransactionSynchronizationManager.initSynchronization();
        }
        return true;
    }

    public void postHandle(HttpServletRequest req, HttpServletResponse res, Object handler, ModelAndView model) throws Exception {
    }

    public void afterCompletion(HttpServletRequest req, HttpServletResponse res, Object handler, Exception ex) throws Exception {
        Session session = this.sessionFactory.getCurrentSession();
        try {
            if (ex == null) {
                logger.debug((Object)"Committing the database transaction");
                if (session.getTransaction().isActive() && !session.getTransaction().wasRolledBack()) {
                    session.getTransaction().commit();
                }
            } else {
                logger.error((Object)ex);
                logger.debug((Object)"Rolling back the database transaction");
                if (session.getTransaction().isActive() && !session.getTransaction().wasRolledBack()) {
                    session.getTransaction().rollback();
                }
            }
            if (session.isOpen()) {
                session.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            try {
                if (session.isOpen()) {
                    session.close();
                }
            }
            catch (Exception e) {}
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            TransactionSynchronizationManager.clearSynchronization();
        }
    }
}

