/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.parancoe.persistence.dao.DaoProvider;
import org.parancoe.persistence.dao.generic.GenericDaoBase;
import org.parancoe.util.FixtureHelper;
import org.parancoe.web.plugin.ApplicationContextPlugin;
import org.parancoe.web.plugin.PluginHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopulateInitialDataContextListener
extends ContextLoaderListener {
    private static final String DAO_PROVIDER_ID = "daos";
    private static final Logger log = Logger.getLogger(PopulateInitialDataContextListener.class);
    private ApplicationContext ctx;
    protected List<Class> clazzToPopulate = new ArrayList<Class>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent evt) {
        this.ctx = (ApplicationContext)evt.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        LinkedHashSet<Class> fixtureClasses = new LinkedHashSet<Class>(this.getFixtureClasses());
        if (CollectionUtils.isEmpty(fixtureClasses)) {
            log.info((Object)"Skipping initial data population (no models)");
            return;
        }
        Map fixtures = FixtureHelper.loadFixturesFromResource((String)"initialData/", fixtureClasses);
        log.info((Object)"Populating initial data for models...");
        String className = "";
        SessionFactory sessionFactory = (SessionFactory)this.ctx.getBean("sessionFactory");
        Session session = sessionFactory.openSession();
        session.beginTransaction();
        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)new SessionHolder((org.hibernate.Session)session));
        TransactionSynchronizationManager.initSynchronization();
        try {
            for (Class clazz : fixtures.keySet()) {
                className = clazz.getName();
                if (ArrayUtils.isEmpty((Object[])((Object[])fixtures.get(clazz)))) {
                    log.warn((Object)("Population of " + FixtureHelper.getModelName((Class)clazz) + " skipped (empty fixture file?)"));
                    continue;
                }
                this.populateTableForModel(clazz, (Object[])fixtures.get(clazz));
            }
            fixtures.clear();
            log.info((Object)"Populating initial data for models done!");
            session.getTransaction().commit();
            if (session.isOpen()) {
                session.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            log.error((Object)("Error while populating initial data for models " + e.getMessage()), (Throwable)e);
            log.debug((Object)"Rolling back the populating database transaction");
            session.getTransaction().rollback();
        }
        finally {
            try {
                if (session.isOpen()) {
                    session.close();
                }
            }
            catch (Exception e) {}
            TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            TransactionSynchronizationManager.clearSynchronization();
        }
    }

    private List<Class> getFixtureClasses() {
        Collection<ApplicationContextPlugin> plugins = new PluginHelper(this.ctx).getApplicationContextPlugins();
        for (ApplicationContextPlugin plugin : plugins) {
            try {
                this.clazzToPopulate.addAll(plugin.getFixtureClasses());
            }
            catch (Exception e) {
                log.error((Object)("Impossibile reperire i nomi delle fixtures da caricare per il plugin " + plugin.getName()));
            }
        }
        return this.clazzToPopulate;
    }

    private void populateTableForModel(Class clazz, Object[] fixtures) {
        String fixtureName = FixtureHelper.getModelName((Class)clazz);
        DaoProvider daos = (DaoProvider)this.ctx.getBean(DAO_PROVIDER_ID);
        GenericDaoBase dao = (GenericDaoBase)daos.getDao(clazz);
        if (dao != null) {
            int count = dao.findAll().size();
            if (count == 0) {
                log.info((Object)("Populating " + fixtureName + " with " + fixtures.length + " items..."));
                FixtureHelper.populateDbForModel((Class)clazz, (Object[])fixtures, (GenericDaoBase)dao);
                log.info((Object)("Population of " + fixtureName + " done!"));
            } else {
                log.info((Object)("Population of " + fixtureName + " skipped (already populated)"));
            }
        } else {
            log.info((Object)("Dao not found for " + fixtureName + " and po " + clazz.getName()));
        }
    }
}

