/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web.controller;

import java.lang.annotation.Annotation;
import org.apache.log4j.Logger;
import org.parancoe.util.Utils;
import org.parancoe.web.controller.annotation.DefaultUrlMapping;
import org.parancoe.web.controller.annotation.MultiUrlMapping;
import org.parancoe.web.controller.annotation.UrlMapping;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.handler.AbstractDetectingUrlHandlerMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHandlerMapping
extends AbstractDetectingUrlHandlerMapping {
    private String defaultExtension = "html";
    private static final Logger logger = Logger.getLogger(AnnotationHandlerMapping.class);

    public void setDefaultExtension(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    protected String[] determineUrlsForHandler(String name) {
        Class ctrl = this.getApplicationContext().getType(name);
        if (ctrl != null && ctrl.isAnnotationPresent(Controller.class)) {
            logger.info((Object)("processing controller: " + ctrl.getSimpleName()));
            RequestMapping requestMappingAnn = this.getMapping(this.getApplicationContext(), name, ctrl, RequestMapping.class);
            if (requestMappingAnn != null) {
                if (requestMappingAnn.value().length > 0) {
                    for (String url : requestMappingAnn.value()) {
                        logger.info((Object)("URL: " + url + " | BEAN: " + name));
                    }
                    return requestMappingAnn.value();
                }
                String[] result = this.getDefaultUrlFromControllerName(ctrl);
                logger.info((Object)("URL: " + result[0] + " | BEAN: " + name));
                return result;
            }
            DefaultUrlMapping defaultMappingAnn = this.getMapping(this.getApplicationContext(), name, ctrl, DefaultUrlMapping.class);
            if (defaultMappingAnn != null) {
                String[] result = this.getDefaultUrlFromControllerName(ctrl);
                logger.info((Object)("URL: " + result[0] + " | BEAN: " + name));
                return result;
            }
            UrlMapping urlMappingAnn = this.getMapping(this.getApplicationContext(), name, ctrl, UrlMapping.class);
            if (urlMappingAnn != null) {
                logger.info((Object)("URL: " + urlMappingAnn.value() + " | BEAN: " + name));
                String[] result = new String[]{urlMappingAnn.value()};
                return result;
            }
            MultiUrlMapping multiUrlMappingAnn = this.getMapping(this.getApplicationContext(), name, ctrl, MultiUrlMapping.class);
            if (multiUrlMappingAnn != null) {
                String[] result = new String[multiUrlMappingAnn.values().length];
                for (int i = 0; i < multiUrlMappingAnn.values().length; ++i) {
                    logger.info((Object)("URL: " + multiUrlMappingAnn.values()[i].value() + " | BEAN: " + name));
                    result[i] = multiUrlMappingAnn.values()[i].value();
                }
                return result;
            }
        }
        return null;
    }

    private <A extends Annotation> A getMapping(ApplicationContext context, String beanName, Class<?> handlerType, Class<A> annotationType) {
        AbstractBeanDefinition abd;
        ConfigurableApplicationContext cac;
        BeanDefinition bd;
        Annotation mapping = AnnotationUtils.findAnnotation(handlerType, annotationType);
        if (mapping == null && context instanceof ConfigurableApplicationContext && context.containsBeanDefinition(beanName) && (bd = (cac = (ConfigurableApplicationContext)context).getBeanFactory().getMergedBeanDefinition(beanName)) instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)bd).hasBeanClass()) {
            Class beanClass = abd.getBeanClass();
            mapping = AnnotationUtils.findAnnotation((Class)beanClass, annotationType);
        }
        return (A)mapping;
    }

    private String[] getDefaultUrlFromControllerName(Class<?> handlerType) {
        String[] values = Utils.uncamelize((String)handlerType.getSimpleName());
        StringBuffer sb = new StringBuffer();
        sb.append("/" + values[0]);
        for (int i = 1; i < values.length - 1; ++i) {
            sb.append("_");
            sb.append(values[i]);
        }
        sb.append("/*.").append(this.defaultExtension);
        String[] url = new String[]{sb.toString()};
        return url;
    }
}

