/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web.plugin;

import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.parancoe.web.plugin.ApplicationContextPlugin;
import org.parancoe.web.plugin.WebPlugin;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginHelper {
    private ApplicationContext ctx;
    private Logger log = Logger.getLogger(PluginHelper.class);

    public PluginHelper(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public Collection<WebPlugin> getWebPlugins() {
        Map pluginMap = this.ctx.getBeansOfType(WebPlugin.class);
        return pluginMap.values();
    }

    public Collection<ApplicationContextPlugin> getApplicationContextPlugins() {
        Map pluginMap = this.ctx.getBeansOfType(ApplicationContextPlugin.class);
        return pluginMap.values();
    }

    public void invokePluginContextInitialized(ServletContextEvent evt) {
        for (ApplicationContextPlugin plugin : this.getApplicationContextPlugins()) {
            for (ContextLoaderListener listener : plugin.getContextLoaderListeners()) {
                try {
                    listener.contextInitialized(evt);
                }
                catch (Exception e) {
                    this.log.error((Object)("error in contextInitialized for plugin '" + plugin.getName() + "'"), (Throwable)e);
                }
            }
        }
    }

    public void invokePluginContextDestroyed(ServletContextEvent evt) {
        for (ApplicationContextPlugin plugin : this.getApplicationContextPlugins()) {
            for (ContextLoaderListener listener : plugin.getContextLoaderListeners()) {
                try {
                    listener.contextDestroyed(evt);
                }
                catch (Exception e) {
                    this.log.error((Object)("error in contextDestroyed for plugin '" + plugin.getName() + "'"), (Throwable)e);
                }
            }
        }
    }

    public boolean invokePluginPreHandle(HttpServletRequest req, HttpServletResponse res, Object handler) {
        for (WebPlugin plugin : this.getWebPlugins()) {
            for (HandlerInterceptorAdapter interceptor : plugin.getInterceptors()) {
                try {
                    boolean result = interceptor.preHandle(req, res, handler);
                    if (result) continue;
                    return false;
                }
                catch (Exception e) {
                    this.log.error((Object)("error in preHandle for plugin '" + plugin.getName() + "'"), (Throwable)e);
                }
            }
        }
        return true;
    }

    public void invokePluginPostHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        for (WebPlugin plugin : this.getWebPlugins()) {
            for (HandlerInterceptorAdapter interceptor : plugin.getInterceptors()) {
                try {
                    interceptor.postHandle(request, response, handler, modelAndView);
                }
                catch (Exception e) {
                    this.log.error((Object)("error in postHandle for plugin '" + plugin.getName() + "'"), (Throwable)e);
                }
            }
        }
    }

    public void invokeAfterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        for (WebPlugin plugin : this.getWebPlugins()) {
            for (HandlerInterceptorAdapter interceptor : plugin.getInterceptors()) {
                try {
                    interceptor.afterCompletion(request, response, handler, exception);
                }
                catch (Exception e) {
                    this.log.error((Object)("error in afterCompletion for plugin '" + plugin.getName() + "'"), (Throwable)e);
                }
            }
        }
    }

    public void initWebPlugins() {
        Collection<WebPlugin> plugins = new PluginHelper(this.ctx).getWebPlugins();
        this.log.info((Object)("Loaded " + plugins.size() + " plugins"));
        for (WebPlugin plugin : plugins) {
            this.log.info((Object)("   - " + plugin.getName()));
        }
    }

    public void initApplicationContextPlugins() {
        Collection<ApplicationContextPlugin> plugins = new PluginHelper(this.ctx).getApplicationContextPlugins();
        this.log.info((Object)("Loaded " + plugins.size() + " plugins"));
        for (ApplicationContextPlugin plugin : plugins) {
            this.log.info((Object)("   - " + plugin.getName()));
        }
    }
}

