/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web.tag;

import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public class FlashTag
extends RequestContextAwareTag {
    protected String type = null;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected final int doStartTagInternal() throws JspException, IOException {
        try {
            Map flash = (Map)this.pageContext.getRequest().getAttribute("flash");
            if (flash == null) {
                flash = (Map)this.pageContext.getSession().getAttribute("flash");
            }
            if (flash != null && flash.get(this.type) != null) {
                MessageSource messageSource = this.getMessageSource();
                if (messageSource == null) {
                    throw new JspTagException("No corresponding MessageSource found");
                }
                String msg = "";
                try {
                    Object[] argumentsArray = new Object[]{};
                    msg = messageSource.getMessage((String)flash.get(this.type), argumentsArray, this.getRequestContext().getLocale());
                }
                catch (Exception ex) {
                    msg = (String)flash.get(this.type);
                }
                this.writeMessage(msg);
                flash.remove(this.type);
            }
            return 1;
        }
        catch (NoSuchMessageException ex) {
            throw new JspTagException(this.getNoSuchMessageExceptionDescription(ex));
        }
    }

    protected void writeMessage(String msg) throws IOException {
        this.pageContext.getOut().write("<div class=\"" + this.type + "_flash\"><p>" + msg + "</p></div>");
    }

    protected MessageSource getMessageSource() {
        return this.getRequestContext().getWebApplicationContext();
    }

    protected String getNoSuchMessageExceptionDescription(NoSuchMessageException ex) {
        return ex.getMessage();
    }
}

