/*
 * Decompiled with CFR 0.152.
 */
package org.parancoe.web.test;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.parancoe.test.DBTest;
import org.parancoe.util.BaseConf;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public abstract class BaseTest
extends DBTest {
    private static final Logger log = Logger.getLogger(BaseTest.class);
    @Autowired
    protected BaseConf conf;

    protected String[] getConfigLocations() {
        String parancoeServlet = null;
        String applicationContext = null;
        try {
            parancoeServlet = new File("./src/main/webapp/WEB-INF/parancoe-servlet.xml").getCanonicalPath();
            applicationContext = new File("./src/main/webapp/WEB-INF/applicationContext.xml").getCanonicalPath();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to get parancoe-servlet", ex);
        }
        return new String[]{"classpath:org/parancoe/persistence/dao/generic/genericDao.xml", "classpath:org/parancoe/persistence/applicationContextBase.xml", "classpath:org/parancoe/web/parancoeBase.xml", "classpath:database-test.xml", "file:" + applicationContext, "file:" + parancoeServlet, "classpath*:applicationContext-plugin.xml", "classpath*:parancoe-plugin.xml", "classpath:spring-test.xml"};
    }

    protected ConfigurableApplicationContext createApplicationContext(String[] locations) {
        FileSystemResourceLoader rl = new FileSystemResourceLoader();
        MockServletContext servletContext = new MockServletContext((ResourceLoader)rl);
        XmlWebApplicationContext context = new XmlWebApplicationContext();
        context.setServletContext((ServletContext)servletContext);
        context.setConfigLocations(locations);
        context.refresh();
        return context;
    }
}

