/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.accessibility;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBlockStmt;
import com.github.javaparser.ast.nodeTypes.NodeWithExpression;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.editor.Editor;
import com.vaadin.base.devserver.editor.Where;
import com.vaadin.base.devserver.themeeditor.utils.LineNumberVisitor;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Main;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.accessibility.AccessibilityCheckerException;
import org.vaadin.addons.accessibility.visitors.AltTextVisitor;
import org.vaadin.addons.accessibility.visitors.AriaLabelVisitor;
import org.vaadin.addons.accessibility.visitors.ConstructorVisitor;
import org.vaadin.addons.accessibility.visitors.GenericStringVisitor;
import org.vaadin.addons.accessibility.visitors.LabelVisitor;
import org.vaadin.addons.accessibility.visitors.TitleVisitor;

public class AccessibilityJavaSourceModifier
extends Editor {
    private final VaadinContext context;
    private final ErrorHandler errorHandler;

    public AccessibilityJavaSourceModifier(VaadinContext context, ErrorHandler errorHandler) {
        this.context = context;
        this.errorHandler = errorHandler;
    }

    public void setLabel(DevToolsInterface devToolsInterface, Integer uiId, Integer nodeId, String label) {
        assert (uiId != null && nodeId != null && label != null);
        this.runAsAccess(devToolsInterface, session -> {
            Component component = this.getComponent((VaadinSession)session, uiId, nodeId);
            if (!(component instanceof HasLabel)) {
                throw new AccessibilityCheckerException("The component does not implement HasLabel");
            }
            this.setText(component, label, new LabelVisitor());
        });
    }

    public void setAriaLabel(DevToolsInterface devToolsInterface, Integer uiId, Integer nodeId, String label) {
        assert (uiId != null && nodeId != null && label != null);
        this.runAsAccess(devToolsInterface, session -> {
            Component component = this.getComponent((VaadinSession)session, uiId, nodeId);
            if (!(component instanceof HasAriaLabel)) {
                throw new AccessibilityCheckerException("The component does not implement HasAriaLabel");
            }
            this.setText(component, label, new AriaLabelVisitor());
        });
    }

    public void setTitle(DevToolsInterface devToolsInterface, Integer uiId, Integer nodeId, String title) {
        assert (uiId != null && nodeId != null && title != null);
        this.runAsAccess(devToolsInterface, session -> {
            Component component = this.getComponent((VaadinSession)session, uiId, nodeId);
            if (!(component instanceof HtmlComponent)) {
                throw new AccessibilityCheckerException("The component is not an HtmlComponent");
            }
            this.setText(component, title, new TitleVisitor());
        });
    }

    public void setAltText(DevToolsInterface devToolsInterface, Integer uiId, Integer nodeId, String altText) {
        assert (uiId != null && nodeId != null && altText != null);
        this.runAsAccess(devToolsInterface, session -> {
            Component component = this.getComponent((VaadinSession)session, uiId, nodeId);
            if (!(component instanceof Image)) {
                throw new AccessibilityCheckerException("The component is not an image");
            }
            this.setText(component, altText, new AltTextVisitor());
        });
    }

    public static String escapeForJava(String value, boolean quote) {
        StringBuilder builder = new StringBuilder();
        if (quote) {
            builder.append("\"");
        }
        for (char c : value.toCharArray()) {
            if (c == '\'') {
                builder.append("\\'");
                continue;
            }
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\t') {
                builder.append("\\t");
                continue;
            }
            if (c < ' ' || c >= '\u007f') {
                builder.append(String.format("\\u%04x", c));
                continue;
            }
            builder.append(c);
        }
        if (quote) {
            builder.append("\"");
        }
        return builder.toString();
    }

    public void setPageTitle(DevToolsInterface devToolsInterface, Integer uiId, String pageTitle) {
        assert (uiId != null && pageTitle != null);
        this.runAsAccess(devToolsInterface, session -> {
            Component currentView = session.getUIById(uiId.intValue()).getCurrentView();
            ArrayList modifications = new ArrayList();
            ComponentTracker.Location createLocation = this.getCreateLocation(currentView);
            File sourceFile = this.getSourceFile(createLocation);
            int sourceOffset = this.modifyClass(sourceFile, cu -> {
                Optional classOrInterfaceDeclaration = cu.getClassByName(currentView.getClass().getSimpleName());
                classOrInterfaceDeclaration.ifPresent(node -> {
                    Name name = StaticJavaParser.parseName((String)PageTitle.class.getSimpleName());
                    Optional<AnnotationExpr> pageTitleAnnotationOptional = node.getAnnotations().stream().filter(expr -> name.equals((Object)expr.getName())).findFirst();
                    SingleMemberAnnotationExpr normalAnnotationExpr = new SingleMemberAnnotationExpr(name, StaticJavaParser.parseExpression((String)AccessibilityJavaSourceModifier.escapeForJava(pageTitle, true)));
                    if (pageTitleAnnotationOptional.isPresent()) {
                        AccessibilityJavaSourceModifier.getLogger().debug("update the page title {}", (Object)pageTitle);
                        modifications.add(Editor.Modification.remove((Node)((Node)pageTitleAnnotationOptional.get())));
                        node.addAnnotation((AnnotationExpr)normalAnnotationExpr);
                        modifications.add(Editor.Modification.insertLineBefore((Node)node, (Node)normalAnnotationExpr));
                    } else {
                        AccessibilityJavaSourceModifier.getLogger().debug("insert the page title {}", (Object)pageTitle);
                        node.addAnnotation((AnnotationExpr)normalAnnotationExpr);
                        modifications.add(Editor.Modification.addImport((Node)cu, (Node)new ImportDeclaration(PageTitle.class.getName(), false, false)));
                        modifications.add(Editor.Modification.insertLineBefore((Node)node, (Node)normalAnnotationExpr));
                    }
                });
                return modifications;
            });
            if (sourceOffset != 0) {
                ComponentTracker.refreshLocation((ComponentTracker.Location)createLocation, (int)sourceOffset);
            }
        });
    }

    public void updateRouteExtends(DevToolsInterface devToolsInterface, Integer uiId) {
        assert (uiId != null);
        this.runAsAccess(devToolsInterface, session -> {
            Component currentView = session.getUIById(uiId.intValue()).getCurrentView();
            ArrayList modifications = new ArrayList();
            ComponentTracker.Location createLocation = this.getCreateLocation(currentView);
            File sourceFile = this.getSourceFile(createLocation);
            int sourceOffset = this.modifyClass(sourceFile, cu -> {
                Optional classOrInterfaceDeclaration = cu.getClassByName(currentView.getClass().getSimpleName());
                classOrInterfaceDeclaration.ifPresent(node -> {
                    Optional<ClassOrInterfaceType> optionalClassOrInterfaceType = node.getExtendedTypes().stream().filter(t -> {
                        String simpleName = t.getNameAsString();
                        return simpleName.equals(Div.class.getSimpleName());
                    }).findFirst();
                    if (optionalClassOrInterfaceType.isPresent()) {
                        ClassOrInterfaceType extendedTypes = optionalClassOrInterfaceType.get();
                        ClassOrInterfaceType newNode = StaticJavaParser.parseClassOrInterfaceType((String)Main.class.getSimpleName());
                        modifications.add(Editor.Modification.addImport((Node)cu, (Node)new ImportDeclaration(Main.class.getName(), false, false)));
                        modifications.add(Editor.Modification.replace((Node)extendedTypes, (Node)newNode));
                    } else {
                        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)cu.accept((GenericVisitor)new ConstructorVisitor(), null);
                        Statement staticStatement = StaticJavaParser.parseStatement((String)"getElement().setAttribute(\"role\", \"main\");");
                        modifications.add(Editor.Modification.insertAtEndOfBlock((Node)constructorDeclaration, (Node)staticStatement));
                    }
                });
                return modifications;
            });
            if (sourceOffset != 0) {
                ComponentTracker.refreshLocation((ComponentTracker.Location)createLocation, (int)sourceOffset);
            }
        });
    }

    private void runAsAccess(DevToolsInterface devToolsInterface, Consumer<VaadinSession> runnable) {
        VaadinSession session = this.getSession();
        session.access((Command & Serializable)() -> {
            try {
                runnable.accept(session);
            }
            catch (Exception ex) {
                AccessibilityJavaSourceModifier.getLogger().error("Error during the execution", (Throwable)ex);
                this.errorHandler.sendError(devToolsInterface, ex.getMessage());
            }
        });
    }

    protected void setText(Component component, String text, GenericStringVisitor visitor) {
        ComponentTracker.Location createLocation = this.getCreateLocation(component);
        File sourceFile = this.getSourceFile(createLocation);
        int sourceOffset = this.modifyClass(sourceFile, cu -> {
            Editor.Modification mod;
            SimpleName scope = this.findLocalVariableOrField((CompilationUnit)cu, createLocation.lineNumber());
            Statement newNode = this.createAddStatement(scope, text, visitor);
            ExpressionStmt stmt = this.findStmt((CompilationUnit)cu, component, visitor);
            if (stmt == null) {
                Node node = this.findNode((CompilationUnit)cu, component);
                Where where = this.findModificationWhere((CompilationUnit)cu, component);
                mod = switch (where) {
                    default -> throw new IncompatibleClassChangeError();
                    case Where.AFTER -> Editor.Modification.insertLineAfter((Node)node, (Node)newNode);
                    case Where.INSIDE -> Editor.Modification.insertAtEndOfBlock((Node)node, (Node)newNode);
                    case Where.BEFORE -> Editor.Modification.insertLineBefore((Node)node, (Node)newNode);
                };
            } else {
                mod = Editor.Modification.replace((Node)stmt, (Node)newNode);
            }
            return Collections.singletonList(mod);
        });
        if (sourceOffset != 0) {
            ComponentTracker.refreshLocation((ComponentTracker.Location)createLocation, (int)sourceOffset);
        }
    }

    protected ComponentTracker.Location getCreateLocation(Component c) {
        ComponentTracker.Location location = ComponentTracker.findCreate((Component)c);
        if (location == null) {
            throw new AccessibilityCheckerException("Unable to find the location where the component " + c.getClass().getName() + " was created");
        }
        return location;
    }

    protected VaadinSession getSession() {
        return VaadinSession.getCurrent();
    }

    protected File getSourceFolder(ComponentTracker.Location location) {
        Path javaSourceFolder = ApplicationConfiguration.get((VaadinContext)this.context).getJavaSourceFolder().toPath();
        String[] splitted = location.className().split("\\.");
        return Path.of(javaSourceFolder.toString(), Arrays.copyOf(splitted, splitted.length - 1)).toFile();
    }

    protected Statement createAddStatement(SimpleName scope, String text, GenericStringVisitor visitor) {
        MethodCallExpr methodCallExpr = new MethodCallExpr(visitor.getMethodName(), new Expression[0]);
        if (scope != null) {
            methodCallExpr.setScope((Expression)new NameExpr(scope));
        }
        if (visitor.isTranslated()) {
            MethodCallExpr getTranslationExpr = new MethodCallExpr("getTranslation", new Expression[0]);
            getTranslationExpr.getArguments().add((Node)new StringLiteralExpr(text));
            methodCallExpr.getArguments().add((Node)getTranslationExpr);
        } else {
            methodCallExpr.getArguments().add((Node)new StringLiteralExpr(text));
        }
        ExpressionStmt statement = new ExpressionStmt((Expression)methodCallExpr);
        statement.setComment((Comment)visitor.getComment());
        return statement;
    }

    protected File getSourceFile(ComponentTracker.Location createLocation) {
        File sourceFolder = this.getSourceFolder(createLocation);
        return new File(sourceFolder, createLocation.filename());
    }

    protected Component getComponent(VaadinSession session, int uiId, int nodeId) {
        Element element = session.findElement(uiId, nodeId);
        Optional c = element.getComponent();
        if (!c.isPresent()) {
            throw new AccessibilityCheckerException("Only component locations are tracked. The given node id refers to an element and not a component.");
        }
        return (Component)c.get();
    }

    protected ExpressionStmt findStmt(CompilationUnit cu, Component component, GenericStringVisitor visitor) {
        ComponentTracker.Location createLocation = this.getCreateLocation(component);
        SimpleName scope = this.findLocalVariableOrField(cu, createLocation.lineNumber());
        return (ExpressionStmt)cu.accept((GenericVisitor)visitor, (Object)(scope != null ? scope.getIdentifier() : null));
    }

    protected Where findModificationWhere(CompilationUnit cu, Component component) {
        NodeWithExpression expr;
        Node node = this.findNode(cu, component);
        if (node instanceof NodeWithBlockStmt) {
            return Where.INSIDE;
        }
        if (node instanceof NodeWithExpression && ((expr = (NodeWithExpression)node).getExpression().isAssignExpr() || expr.getExpression().isVariableDeclarationExpr())) {
            return Where.AFTER;
        }
        throw new AccessibilityCheckerException("Cannot apply classname for " + node);
    }

    protected Node findNode(CompilationUnit cu, Component component) {
        ComponentTracker.Location createLocation = this.getCreateLocation(component);
        Node node = (Node)cu.accept((GenericVisitor)new LineNumberVisitor(), (Object)createLocation.lineNumber());
        if (node == null) {
            throw new AccessibilityCheckerException("Cannot find component.");
        }
        return node;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AccessibilityJavaSourceModifier.class);
    }

    public static interface ErrorHandler {
        public void sendError(DevToolsInterface var1, String var2);
    }
}

