/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.accessibility;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.DevToolsMessageHandler;
import com.vaadin.base.devserver.IdeIntegration;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Optional;
import org.vaadin.addons.accessibility.AccessibilityJavaSourceModifier;

@NpmPackage.Container(value={@NpmPackage(value="accessibility-checker", version="3.1.49"), @NpmPackage(value="accessibility-checker-engine", version="3.1.49")})
@JsModule(value="./accessibility-checker/accessibility-checker.ts", developmentOnly=true)
public class AccessibilityCheckerPlugin
implements DevToolsMessageHandler {
    public static final String ACCESSIBILITY_CHECKER = "accessibility-checker";
    public static final String NODE_ID = "nodeId";
    public static final String UI_ID = "uiId";
    private IdeIntegration ideIntegration;
    private AccessibilityJavaSourceModifier accessibilityJavaSourceModifier;

    public void handleConnect(DevToolsInterface devToolsInterface) {
        devToolsInterface.send("accessibility-checker-init", Json.createObject());
    }

    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("accessibility-checker-show-component-creation-location")) {
            int nodeId = (int)data.getNumber(NODE_ID);
            int uiId = (int)data.getNumber(UI_ID);
            VaadinSession session = VaadinSession.getCurrent();
            session.access((Command & Serializable)() -> {
                Element element = session.findElement(uiId, nodeId);
                Optional c = element.getComponent();
                if (c.isPresent()) {
                    this.getIdeIntegration().showComponentCreateInIde((Component)c.get());
                } else {
                    System.out.println("Only component locations are tracked. The given node id refers to an element and not a component");
                }
            });
            return true;
        }
        if (command.equals("accessibility-checker-set-label")) {
            int nodeId = (int)data.getNumber(NODE_ID);
            int uiId = (int)data.getNumber(UI_ID);
            String label = data.getString("label");
            this.getAccessibilityJavaSourceModifier().setLabel(devToolsInterface, uiId, nodeId, label);
            return true;
        }
        if (command.equals("accessibility-checker-set-aria-label")) {
            int nodeId = (int)data.getNumber(NODE_ID);
            int uiId = (int)data.getNumber(UI_ID);
            String label = data.getString("label");
            this.getAccessibilityJavaSourceModifier().setAriaLabel(devToolsInterface, uiId, nodeId, label);
            return true;
        }
        if (command.equals("accessibility-checker-set-title")) {
            int nodeId = (int)data.getNumber(NODE_ID);
            int uiId = (int)data.getNumber(UI_ID);
            String value = data.getString("title");
            this.getAccessibilityJavaSourceModifier().setTitle(devToolsInterface, uiId, nodeId, value);
            return true;
        }
        if (command.equals("accessibility-checker-set-alt-text")) {
            int nodeId = (int)data.getNumber(NODE_ID);
            int uiId = (int)data.getNumber(UI_ID);
            String label = data.getString("text");
            this.getAccessibilityJavaSourceModifier().setAltText(devToolsInterface, uiId, nodeId, label);
            return true;
        }
        if (command.equals("accessibility-checker-update-page-title")) {
            int uiId = (int)data.getNumber(UI_ID);
            String label = data.getString("label");
            this.getAccessibilityJavaSourceModifier().setPageTitle(devToolsInterface, uiId, label);
            return true;
        }
        if (command.equals("accessibility-checker-update-route-extends")) {
            int uiId = (int)data.getNumber(UI_ID);
            this.getAccessibilityJavaSourceModifier().updateRouteExtends(devToolsInterface, uiId);
            return true;
        }
        return false;
    }

    private IdeIntegration getIdeIntegration() {
        if (this.ideIntegration == null) {
            this.ideIntegration = new IdeIntegration(ApplicationConfiguration.get((VaadinContext)VaadinService.getCurrent().getContext()));
        }
        return this.ideIntegration;
    }

    private AccessibilityJavaSourceModifier getAccessibilityJavaSourceModifier() {
        if (this.accessibilityJavaSourceModifier == null) {
            this.accessibilityJavaSourceModifier = new AccessibilityJavaSourceModifier(VaadinService.getCurrent().getContext(), (devToolsInterface, errorMessage) -> {
                JsonObject object = Json.createObject();
                object.put("message", errorMessage);
                devToolsInterface.send("accessibility-checker-error", object);
            });
        }
        return this.accessibilityJavaSourceModifier;
    }
}

