/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.pekkam;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import org.vaadin.pekkam.CanvasRenderingContext2D;
import org.vaadin.pekkam.event.ImageLoadEvent;
import org.vaadin.pekkam.event.MouseClickEvent;
import org.vaadin.pekkam.event.MouseDblClickEvent;
import org.vaadin.pekkam.event.MouseDownEvent;
import org.vaadin.pekkam.event.MouseMoveEvent;
import org.vaadin.pekkam.event.MouseUpEvent;

@Tag(value="canvas")
public class Canvas
extends Component
implements HasStyle,
HasSize,
KeyNotifier {
    private CanvasRenderingContext2D context = new CanvasRenderingContext2D(this);

    public Canvas(int width, int height) {
        this.getElement().setAttribute("width", String.valueOf(width));
        this.getElement().setAttribute("height", String.valueOf(height));
    }

    public CanvasRenderingContext2D getContext() {
        return this.context;
    }

    public void setWidth(String width) {
        super.setWidth(width);
    }

    public void setHeight(String height) {
        super.setHeight(height);
    }

    public void setSizeFull() {
        super.setSizeFull();
    }

    public void loadImage(String src) {
        this.getElement().executeJs("var img = new Image();\nvar self = this;\nimg.onload = function () {\n    if (!self.images) self.images = {};\n    self.images[$0] = img;\n    self.$server.imageLoaded($0);\n};\nimg.src=$0;", new Serializable[]{src});
    }

    @ClientCallable
    public void imageLoaded(String src) {
        this.fireEvent(new ImageLoadEvent(this, true, src));
    }

    public Registration addMouseDownListener(ComponentEventListener<MouseDownEvent> listener) {
        return this.addListener(MouseDownEvent.class, listener);
    }

    public Registration addMouseUpListener(ComponentEventListener<MouseUpEvent> listener) {
        return this.addListener(MouseUpEvent.class, listener);
    }

    public Registration addMouseMoveListener(ComponentEventListener<MouseMoveEvent> listener) {
        return this.addListener(MouseMoveEvent.class, listener);
    }

    public Registration addMouseClickListener(ComponentEventListener<MouseClickEvent> listener) {
        return this.addListener(MouseClickEvent.class, listener);
    }

    public Registration addMouseDblClickListener(ComponentEventListener<MouseDblClickEvent> listener) {
        return this.addListener(MouseDblClickEvent.class, listener);
    }

    public Registration addImageLoadListener(ComponentEventListener<ImageLoadEvent> listener) {
        return this.addListener(ImageLoadEvent.class, listener);
    }
}

