/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.pekkam;

import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import org.vaadin.pekkam.Canvas;

public class CanvasRenderingContext2D {
    private Canvas canvas;

    protected CanvasRenderingContext2D(Canvas canvas) {
        this.canvas = canvas;
    }

    public void setFillStyle(String fillStyle) {
        this.setProperty("fillStyle", (Serializable)((Object)fillStyle));
    }

    public void setPatternFillStyle(String src, String type) {
        this.runScript("if ($0.images) {\n   var img = $0.images['%s'];\n   if (img) {\n     var ctx = $0.getContext('2d');\n     var pat = ctx.createPattern(img, '%s');\n     ctx.fillStyle = pat;\n   }\n}".formatted(src, type));
    }

    public void setStrokeStyle(String strokeStyle) {
        this.setProperty("strokeStyle", (Serializable)((Object)strokeStyle));
    }

    public void setPatternStrokeStyle(String src, String type) {
        this.runScript(" if ($0.images) {\n   var img = $0.images['%s'];\n   if (img) {\n     var ctx = $0.getContext('2d');\n     var pat = ctx.createPattern(img, '%s');\n     ctx.strokeStyle = pat;\n   }\n }\n".formatted(src, type));
    }

    public void setLineWidth(double lineWidth) {
        this.setProperty("lineWidth", Double.valueOf(lineWidth));
    }

    public void setFont(String font) {
        this.setProperty("font", (Serializable)((Object)font));
    }

    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean antiClockwise) {
        this.callJsMethod("arc", Double.valueOf(x), Double.valueOf(y), Double.valueOf(radius), Double.valueOf(startAngle), Double.valueOf(endAngle), Boolean.valueOf(antiClockwise));
    }

    public void beginPath() {
        this.callJsMethod("beginPath", new Serializable[0]);
    }

    public void clearRect(double x, double y, double width, double height) {
        this.callJsMethod("clearRect", Double.valueOf(x), Double.valueOf(y), Double.valueOf(width), Double.valueOf(height));
    }

    public void closePath() {
        this.callJsMethod("closePath", new Serializable[0]);
    }

    public void drawImage(String src, double x, double y) {
        this.runScript("var img = null;\nif ($0.images) img = $0.images['%s'];\nif (img != null)\n  $0.getContext('2d').drawImage(img, %s, %s);\nelse {\n  img = new Image();\n  img.onload = function () {\n    $0.getContext('2d').drawImage(img, %s, %s);\n  };\n  img.src='%s';\n}".formatted(src, x, y, x, y, src));
    }

    public void drawImage(String src, double x, double y, double width, double height) {
        this.runScript("var img = null;\nif ($0.images) img = $0.images['%s'];\nif (img != null)\n  $0.getContext('2d').drawImage(img, %s, %s, %s, %s);\nelse {\n  img = new Image();\n  img.onload = function () {\n    $0.getContext('2d').drawImage(img, %s, %s, %s, %s);\n  };\n  img.src='%s';\n}\n".formatted(src, x, y, width, height, x, y, width, height, src));
    }

    public void fill() {
        this.callJsMethod("fill", new Serializable[0]);
    }

    public void fillRect(double x, double y, double width, double height) {
        this.callJsMethod("fillRect", Double.valueOf(x), Double.valueOf(y), Double.valueOf(width), Double.valueOf(height));
    }

    public void fillText(String text, double x, double y) {
        this.callJsMethod("fillText", new Serializable[]{text, Double.valueOf(x), Double.valueOf(y)});
    }

    public void lineTo(double x, double y) {
        this.callJsMethod("lineTo", Double.valueOf(x), Double.valueOf(y));
    }

    public void moveTo(double x, double y) {
        this.callJsMethod("moveTo", Double.valueOf(x), Double.valueOf(y));
    }

    public void rect(double x, double y, double width, double height) {
        this.callJsMethod("rect", Double.valueOf(x), Double.valueOf(y), Double.valueOf(width), Double.valueOf(height));
    }

    public void restore() {
        this.callJsMethod("restore", new Serializable[0]);
    }

    public void rotate(double angle) {
        this.callJsMethod("rotate", Double.valueOf(angle));
    }

    public void save() {
        this.callJsMethod("save", new Serializable[0]);
    }

    public void scale(double x, double y) {
        this.callJsMethod("scale", Double.valueOf(x), Double.valueOf(y));
    }

    public void stroke() {
        this.callJsMethod("stroke", new Serializable[0]);
    }

    public void strokeRect(double x, double y, double width, double height) {
        this.callJsMethod("strokeRect", Double.valueOf(x), Double.valueOf(y), Double.valueOf(width), Double.valueOf(height));
    }

    public void strokeText(String text, double x, double y) {
        this.callJsMethod("strokeText", new Serializable[]{text, Double.valueOf(x), Double.valueOf(y)});
    }

    public void translate(double x, double y) {
        this.callJsMethod("translate", Double.valueOf(x), Double.valueOf(y));
    }

    protected void setProperty(String propertyName, Serializable value) {
        this.runScript("$0.getContext('2d').%s='%s'".formatted(propertyName, value));
    }

    private void runScript(String script) {
        this.canvas.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.canvas.getElement().getNode(), (SerializableConsumer & Serializable)context -> ui.getPage().executeJs(script, new Serializable[]{this.canvas.getElement()})));
    }

    protected void callJsMethod(String methodName, Serializable ... parameters) {
        this.canvas.getElement().callJsFunction("getContext('2d')." + methodName, parameters);
    }
}

