/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.hugerte;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import org.vaadin.hugerte.Language;
import org.vaadin.hugerte.Menubar;
import org.vaadin.hugerte.Plugin;
import org.vaadin.hugerte.Toolbar;
import org.vaadin.hugerte.ValueChangeMode;

@JavaScript(value="context://frontend/hugerteConnector.js")
@StyleSheet(value="context://frontend/hugerteLumo.css")
public class HugeRte
extends CustomField<String>
implements HasSize {
    private final DomListenerRegistration domListenerRegistration;
    private String id;
    private boolean initialContentSent;
    private String currentValue = "";
    private String rawConfig;
    JsonObject config = Json.createObject();
    private final Element editorContainer = new Element("div");
    private boolean connectorInitialized;
    private final int debounceTimeout = 0;
    private boolean basicEditorCreated;
    private boolean enabled = true;
    private boolean readOnly = false;

    public HugeRte() {
        super((Object)"");
        this.addClassName("vaadin-huge-rte");
        this.setHeight("500px");
        this.getStyle().setOverflow(Style.Overflow.AUTO);
        this.editorContainer.getStyle().set("height", "100%");
        this.getElement().appendChild(new Element[]{this.editorContainer});
        this.domListenerRegistration = this.getElement().addEventListener("tchange", (DomEventListener & Serializable)event -> {
            String htmlString;
            boolean value = event.getEventData().hasKey("event.htmlString");
            this.currentValue = htmlString = event.getEventData().getString("event.htmlString");
            this.setModelValue(htmlString, true);
        });
        this.domListenerRegistration.addEventData("event.htmlString");
        this.domListenerRegistration.debounce(0);
    }

    protected String generateModelValue() {
        return this.currentValue;
    }

    public void setValueChangeMode(ValueChangeMode mode) {
        if (mode == ValueChangeMode.BLUR) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setMode", new Serializable[]{"blur"}));
        } else if (mode == ValueChangeMode.TIMEOUT) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setMode", new Serializable[]{"timeout"}));
        } else if (mode == ValueChangeMode.CHANGE) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setMode", new Serializable[]{"change"}));
        }
    }

    public void setDebounceTimeout(int debounceTimeout) {
        if (debounceTimeout > 0) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEager", new Serializable[]{"timeout"}));
        } else {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEager", new Serializable[]{"change"}));
        }
        this.domListenerRegistration.debounce(debounceTimeout);
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
            this.editorContainer.setAttribute("id", this.id);
        }
        if (!this.getEventBus().hasListener(BlurNotifier.BlurEvent.class)) {
            this.addBlurListener((ComponentEventListener<BlurNotifier.BlurEvent<CustomField<String>>>)(ComponentEventListener & Serializable)e -> {});
        }
        if (!attachEvent.isInitialAttach()) {
            this.initialContentSent = true;
        }
        super.onAttach(attachEvent);
        if (attachEvent.isInitialAttach()) {
            this.injectEditorScript();
        }
        this.initConnector();
        this.saveOnClose();
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (this.isVisible()) {
            detachEvent.getUI().getPage().executeJs("hugerte.get($0).remove();\n", new Serializable[]{this.id});
        }
        super.onDetach(detachEvent);
        this.initialContentSent = false;
        this.connectorInitialized = false;
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (this.rawConfig == null) {
                this.rawConfig = "{}";
            }
            ui.getPage().executeJs("const editor = $0;const rawconfig = " + this.rawConfig + ";\nwindow.Vaadin.Flow.hugerteConnector.initLazy(rawconfig, $0, $1, $2, $3, $4)", new Serializable[]{this.getElement(), this.editorContainer, this.config, this.currentValue, Boolean.valueOf(this.enabled && !this.readOnly)}).then((SerializableConsumer & Serializable)res -> {
                this.initialContentSent = true;
            });
            this.connectorInitialized = true;
        });
    }

    private void saveOnClose() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.saveOnClose", new Serializable[0]));
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    @Deprecated
    public String getCurrentValue() {
        return (String)this.getValue();
    }

    public void setConfig(String jsConfig) {
        this.checkAlreadyInitialized();
        this.rawConfig = jsConfig;
    }

    public HugeRte configure(String configurationKey, String value) {
        this.checkAlreadyInitialized();
        this.config.put(configurationKey, value);
        return this;
    }

    public HugeRte configure(String configurationKey, String ... value) {
        this.checkAlreadyInitialized();
        JsonArray array = Json.createArray();
        for (int i = 0; i < value.length; ++i) {
            array.set(i, value[i]);
        }
        this.config.put(configurationKey, (JsonValue)array);
        return this;
    }

    public HugeRte configure(String configurationKey, boolean value) {
        this.checkAlreadyInitialized();
        this.config.put(configurationKey, value);
        return this;
    }

    public HugeRte configure(String configurationKey, double value) {
        this.checkAlreadyInitialized();
        this.config.put(configurationKey, value);
        return this;
    }

    public HugeRte configureLanguage(Language language) {
        String code = language.getCode();
        if (code != null) {
            this.config.put("language", code);
        }
        return this;
    }

    public void replaceSelectionContent(String htmlString) {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.replaceSelectionContent", new Serializable[]{htmlString}));
    }

    protected void injectEditorScript() {
        ((UI)this.getUI().orElseThrow()).getPage().addJavaScript("context://frontend/hugerte_addon/hugerte/hugerte.min.js");
    }

    public void focus() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().executeJs("const el = this;\nif(el.$connector.isInDialog()) {\n    setTimeout(() => {\n        el.$connector.focus()\n    }, 150);\n} else {\n    el.$connector.focus();\n}\n", new Serializable[0]));
    }

    public Registration addFocusListener(ComponentEventListener<FocusNotifier.FocusEvent<CustomField<String>>> listener) {
        DomListenerRegistration domListenerRegistration = this.getElement().addEventListener("tfocus", (DomEventListener & Serializable)event -> listener.onComponentEvent((ComponentEvent)new FocusNotifier.FocusEvent((Component)this, true)));
        return domListenerRegistration;
    }

    public Registration addBlurListener(ComponentEventListener<BlurNotifier.BlurEvent<CustomField<String>>> listener) {
        DomListenerRegistration domListenerRegistration = this.getElement().addEventListener("tblur", (DomEventListener & Serializable)event -> listener.onComponentEvent((ComponentEvent)new BlurNotifier.BlurEvent((Component)this, true)));
        return domListenerRegistration;
    }

    public void blur() {
        throw new UnsupportedOperationException("Not implemented, HugeRTE does not support programmatic blur.");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.adjustEnabledState();
    }

    private void adjustEnabledState() {
        boolean reallyEnabled = this.enabled && !this.readOnly;
        super.setEnabled(reallyEnabled);
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEnabled", new Serializable[]{Boolean.valueOf(reallyEnabled)}));
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        super.setReadOnly(readOnly);
        this.adjustEnabledState();
    }

    protected void setPresentationValue(String html) {
        this.currentValue = html;
        if (this.initialContentSent) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEditorContent", new Serializable[]{html}));
        }
    }

    private HugeRte initBasicEditorConfiguration() {
        this.setValue("");
        this.configure("branding", false);
        this.basicEditorCreated = true;
        this.configurePlugins(false, Plugin.ADVLIST, Plugin.AUTOLINK, Plugin.LISTS, Plugin.SEARCH_REPLACE);
        this.configureMenubar(false, Menubar.FILE, Menubar.EDIT, Menubar.VIEW, Menubar.FORMAT);
        this.configureToolbar(false, Toolbar.UNDO, Toolbar.REDO, Toolbar.SEPARATOR, Toolbar.BLOCKS, Toolbar.SEPARATOR, Toolbar.BOLD, Toolbar.ITALIC, Toolbar.SEPARATOR, Toolbar.ALIGN_LEFT, Toolbar.ALIGN_CENTER, Toolbar.ALIGN_RIGHT, Toolbar.ALIGN_JUSTIFY, Toolbar.SEPARATOR, Toolbar.OUTDENT, Toolbar.INDENT);
        return this;
    }

    public HugeRte configurePlugins(Plugin ... plugins) {
        return this.configurePlugins(false, plugins);
    }

    public HugeRte configurePlugins(boolean setupBasicConfig, Plugin ... plugins) {
        this.checkAlreadyInitialized();
        if (setupBasicConfig && !this.basicEditorCreated) {
            this.initBasicEditorConfiguration();
        }
        JsonArray jsonArray = (JsonArray)this.config.get("plugins");
        int initialIndex = 0;
        if (jsonArray != null) {
            initialIndex = jsonArray.length();
        } else {
            jsonArray = Json.createArray();
        }
        for (int i = 0; i < plugins.length; ++i) {
            jsonArray.set(initialIndex, plugins[i].pluginLabel);
            ++initialIndex;
        }
        this.config.put("plugins", (JsonValue)jsonArray);
        return this;
    }

    public HugeRte configureMenubar(Menubar ... menubars) {
        return this.configureMenubar(false, menubars);
    }

    public HugeRte configureMenubar(boolean setupBasicConfig, Menubar ... menubars) {
        Object menubar;
        this.checkAlreadyInitialized();
        if (setupBasicConfig && !this.basicEditorCreated) {
            this.initBasicEditorConfiguration();
        }
        String newconfig = Arrays.stream(menubars).map(m -> m.menubarLabel).collect(Collectors.joining(" "));
        if (this.config.hasKey("menubar")) {
            menubar = this.config.getString("menubar");
            menubar = (String)menubar + " " + newconfig;
        } else {
            menubar = newconfig;
        }
        this.config.put("menubar", (String)menubar);
        return this;
    }

    public HugeRte configureToolbar(Toolbar ... toolbars) {
        return this.configureToolbar(false, toolbars);
    }

    public HugeRte configureToolbar(boolean setupBasicConfig, Toolbar ... toolbars) {
        this.checkAlreadyInitialized();
        if (setupBasicConfig && !this.basicEditorCreated) {
            this.initBasicEditorConfiguration();
        }
        JsonValue jsonValue = this.config.get("toolbar");
        String toolbarStr = "";
        if (jsonValue != null) {
            toolbarStr = toolbarStr.concat(jsonValue.asString());
        }
        for (int i = 0; i < toolbars.length; ++i) {
            toolbarStr = toolbarStr.concat(" ").concat(toolbars[i].toolbarLabel).concat(" ");
        }
        this.config.put("toolbar", toolbarStr);
        return this;
    }

    private void checkAlreadyInitialized() {
        if (this.connectorInitialized) {
            throw new AlreadyInitializedException();
        }
    }

    public static class AlreadyInitializedException
    extends RuntimeException {
        public AlreadyInitializedException() {
            super("Cannot apply configuration to the editor, it already has been initialized. You need to detach it first");
        }
    }
}

