/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.hugerte;

import java.util.Objects;

public enum Language {
    ENGLISH(null),
    ARABIC("ar"),
    AZERBAIJANI("az"),
    BELARUSIAN("be"),
    CATALAN("ca"),
    CZECH("cs"),
    WELSH("cy"),
    DANISH("da"),
    GERMAN("de"),
    GREEK("el"),
    ESPERANTO("eo"),
    SPANISH("es"),
    ESTONIAN("et"),
    BASQUE("eu"),
    PERSIAN("fa"),
    FINNISH("fi"),
    IRISH("ga"),
    GALICIAN("gl"),
    CROATIAN("hr"),
    HUNGARIAN("hu_HU"),
    ARMENIAN("hy"),
    INDONESIAN("id"),
    ITALIAN("it"),
    JAPANESE("ja"),
    KABYLE("kab"),
    KAZAKH("kk"),
    KURDISH("ku"),
    LITHUANIAN("lt"),
    LATVIAN("lv"),
    NEPALI("ne"),
    DUTCH("nl"),
    OCCITAN("oc"),
    POLISH("pl"),
    PORTUGUESE("pt_PT"),
    ROMANIAN("ro"),
    RUSSIAN("ru"),
    SLOVAK("sk"),
    ALBANIAN("sq"),
    SERBIAN("sr"),
    TAJIK("tg"),
    TURKISH("tr"),
    UIGHUR("ug"),
    UKRAINIAN("uk"),
    UZBEK("uz"),
    VIETNAMESE("vi"),
    TAMIL("ta"),
    ARABIC_SAUDI_ARABIA("ar_SA"),
    BULGARIAN_BULGARIA("bg_BG"),
    BENGALI_BANGLADESH("bn_BD"),
    SPANISH_MEXICO("es_MX"),
    FRENCH_FRANCE("fr_FR"),
    HEBREW_ISRAEL("he_IL"),
    ICELANDIC_ICELAND("is_IS"),
    GEORGIAN_GEORGIA("ka_GE"),
    KOREAN_KOREA("ko_KR"),
    NORWEGIAN_NORWAY("nb_NO"),
    DUTCH_BELGIUM("nl_BE"),
    PORTUGUESE_BRAZIL("pt_BR"),
    SLOVENIAN_SLOVENIA("sl_SI"),
    SWEDISH_SWEDEN("sv_SE"),
    THAI_THAILAND("th_TH"),
    CHINESE_CHINA("zh_CN"),
    CHINESE_HONG_KONG("zh_HK"),
    CHINESE_MACAO("zh_MO"),
    CHINESE_SINGAPORE("zh_SG"),
    CHINESE_TAIWAN("zh_TW");

    private final String code;

    private Language(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static Language fromCode(String code) {
        for (Language lang : Language.values()) {
            if (!Objects.equals(lang.code, code)) continue;
            return lang;
        }
        throw new IllegalArgumentException("No Language enum member found for code: " + code);
    }
}

