/*
 * Decompiled with CFR 0.152.
 */
package org.parttio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import java.io.Serializable;
import java.util.UUID;
import org.parttio.LeaderLineOptions;

public class LeaderLine {
    public static ObjectMapper mapper = new ObjectMapper();
    private final UUID id = UUID.randomUUID();
    private UI ui;

    LeaderLine(UI ui, Component from, Component to, LeaderLineOptions options) {
        this.ui = ui;
        try {
            String optionsJson = mapper.writeValueAsString((Object)options);
            UI.getCurrent().getPage().executeJs("const options = %s;\ndebugger;\nwindow.leaderLine($0, $1, $2, options);\n".formatted(optionsJson), new Serializable[]{this.id.toString(), from.getElement(), to.getElement()});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void position() {
        this.ui.getPage().executeJs("window.leaderLines[$0].position();\n", new Serializable[]{this.id.toString()});
    }

    public void setOptions(LeaderLineOptions options) {
        try {
            String optionsJson = mapper.writeValueAsString((Object)options);
            this.ui.getPage().executeJs("const options = %s;\nwindow.leaderLines[$0].setOptions(options);\n".formatted(optionsJson), new Serializable[]{this.id.toString()});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove() {
        this.ui.getPage().executeJs("window.leaderLines[$0].remove();\ndelete window.leaderLines[$0];\n", new Serializable[]{this.id.toString()});
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

