package org.vaadin.lineawesome;

import java.util.Locale;

import com.vaadin.flow.component.icon.SvgIcon;

/**
 * An integration of the https://icons8.com/line-awesome icon set.
 */
public enum LineAwesomeIcon {
    _500PX("500px"),
    ACCESSIBLE_ICON,
    ACCUSOFT,
    ACQUISITIONS_INCORPORATED,
    AD_SOLID,
    ADDRESS_BOOK_SOLID,
    ADDRESS_BOOK,
    ADDRESS_CARD_SOLID,
    ADDRESS_CARD,
    ADJUST_SOLID,
    ADN,
    ADOBE,
    ADVERSAL,
    AFFILIATETHEME,
    AIR_FRESHENER_SOLID,
    AIRBNB,
    ALGOLIA,
    ALIGN_CENTER_SOLID,
    ALIGN_JUSTIFY_SOLID,
    ALIGN_LEFT_SOLID,
    ALIGN_RIGHT_SOLID,
    ALIPAY,
    ALLERGIES_SOLID,
    AMAZON_PAY,
    AMAZON,
    AMBULANCE_SOLID,
    AMERICAN_SIGN_LANGUAGE_INTERPRETING_SOLID,
    AMILIA,
    ANCHOR_SOLID,
    ANDROID,
    ANGELLIST,
    ANGLE_DOUBLE_DOWN_SOLID,
    ANGLE_DOUBLE_LEFT_SOLID,
    ANGLE_DOUBLE_RIGHT_SOLID,
    ANGLE_DOUBLE_UP_SOLID,
    ANGLE_DOWN_SOLID,
    ANGLE_LEFT_SOLID,
    ANGLE_RIGHT_SOLID,
    ANGLE_UP_SOLID,
    ANGRY_SOLID,
    ANGRY,
    ANGRYCREATIVE,
    ANGULAR,
    ANKH_SOLID,
    APP_STORE_IOS,
    APP_STORE,
    APPER,
    APPLE_ALT_SOLID,
    APPLE_PAY,
    APPLE,
    ARCHIVE_SOLID,
    ARCHWAY_SOLID,
    ARROW_ALT_CIRCLE_DOWN_SOLID,
    ARROW_ALT_CIRCLE_DOWN,
    ARROW_ALT_CIRCLE_LEFT_SOLID,
    ARROW_ALT_CIRCLE_LEFT,
    ARROW_ALT_CIRCLE_RIGHT_SOLID,
    ARROW_ALT_CIRCLE_RIGHT,
    ARROW_ALT_CIRCLE_UP_SOLID,
    ARROW_ALT_CIRCLE_UP,
    ARROW_CIRCLE_DOWN_SOLID,
    ARROW_CIRCLE_LEFT_SOLID,
    ARROW_CIRCLE_RIGHT_SOLID,
    ARROW_CIRCLE_UP_SOLID,
    ARROW_DOWN_SOLID,
    ARROW_LEFT_SOLID,
    ARROW_RIGHT_SOLID,
    ARROW_UP_SOLID,
    ARROWS_ALT_H_SOLID,
    ARROWS_ALT_SOLID,
    ARROWS_ALT_V_SOLID,
    ARTSTATION,
    ASSISTIVE_LISTENING_SYSTEMS_SOLID,
    ASTERISK_SOLID,
    ASYMMETRIK,
    AT_SOLID,
    ATLAS_SOLID,
    ATLASSIAN,
    ATOM_SOLID,
    AUDIBLE,
    AUDIO_DESCRIPTION_SOLID,
    AUTOPREFIXER,
    AVIANEX,
    AVIATO,
    AWARD_SOLID,
    AWS,
    BABY_CARRIAGE_SOLID,
    BABY_SOLID,
    BACKSPACE_SOLID,
    BACKWARD_SOLID,
    BACON_SOLID,
    BALANCE_SCALE_LEFT_SOLID,
    BALANCE_SCALE_RIGHT_SOLID,
    BALANCE_SCALE_SOLID,
    BAN_SOLID,
    BAND_AID_SOLID,
    BANDCAMP,
    BARCODE_SOLID,
    BARS_SOLID,
    BASEBALL_BALL_SOLID,
    BASKETBALL_BALL_SOLID,
    BATH_SOLID,
    BATTERY_EMPTY_SOLID,
    BATTERY_FULL_SOLID,
    BATTERY_HALF_SOLID,
    BATTERY_QUARTER_SOLID,
    BATTERY_THREE_QUARTERS_SOLID,
    BATTLE_NET,
    BED_SOLID,
    BEER_SOLID,
    BEHANCE_SQUARE,
    BEHANCE,
    BELL_SLASH_SOLID,
    BELL_SLASH,
    BELL_SOLID,
    BELL,
    BEZIER_CURVE_SOLID,
    BIBLE_SOLID,
    BICYCLE_SOLID,
    BIKING_SOLID,
    BIMOBJECT,
    BINOCULARS_SOLID,
    BIOHAZARD_SOLID,
    BIRTHDAY_CAKE_SOLID,
    BITBUCKET,
    BITCOIN,
    BITY,
    BLACK_TIE,
    BLACKBERRY,
    BLENDER_PHONE_SOLID,
    BLENDER_SOLID,
    BLIND_SOLID,
    BLOG_SOLID,
    BLOGGER_B,
    BLOGGER,
    BLUETOOTH_B,
    BLUETOOTH,
    BOLD_SOLID,
    BOLT_SOLID,
    BOMB_SOLID,
    BONE_SOLID,
    BONG_SOLID,
    BOOK_DEAD_SOLID,
    BOOK_MEDICAL_SOLID,
    BOOK_OPEN_SOLID,
    BOOK_READER_SOLID,
    BOOK_SOLID,
    BOOKMARK_SOLID,
    BOOKMARK,
    BOOTSTRAP,
    BORDER_ALL_SOLID,
    BORDER_NONE_SOLID,
    BORDER_STYLE_SOLID,
    BOWLING_BALL_SOLID,
    BOX_OPEN_SOLID,
    BOX_SOLID,
    BOXES_SOLID,
    BRAILLE_SOLID,
    BRAIN_SOLID,
    BREAD_SLICE_SOLID,
    BRIEFCASE_MEDICAL_SOLID,
    BRIEFCASE_SOLID,
    BROADCAST_TOWER_SOLID,
    BROOM_SOLID,
    BRUSH_SOLID,
    BTC,
    BUFFER,
    BUG_SOLID,
    BUILDING_SOLID,
    BUILDING,
    BULLHORN_SOLID,
    BULLSEYE_SOLID,
    BURN_SOLID,
    BUROMOBELEXPERTE,
    BUS_ALT_SOLID,
    BUS_SOLID,
    BUSINESS_TIME_SOLID,
    BUY_N_LARGE,
    BUYSELLADS,
    CALCULATOR_SOLID,
    CALENDAR_ALT_SOLID,
    CALENDAR_ALT,
    CALENDAR_CHECK_SOLID,
    CALENDAR_CHECK,
    CALENDAR_DAY_SOLID,
    CALENDAR_MINUS_SOLID,
    CALENDAR_MINUS,
    CALENDAR_PLUS_SOLID,
    CALENDAR_PLUS,
    CALENDAR_SOLID,
    CALENDAR_TIMES_SOLID,
    CALENDAR_TIMES,
    CALENDAR_WEEK_SOLID,
    CALENDAR,
    CAMERA_RETRO_SOLID,
    CAMERA_SOLID,
    CAMPGROUND_SOLID,
    CANADIAN_MAPLE_LEAF,
    CANDY_CANE_SOLID,
    CANNABIS_SOLID,
    CAPSULES_SOLID,
    CAR_ALT_SOLID,
    CAR_BATTERY_SOLID,
    CAR_CRASH_SOLID,
    CAR_SIDE_SOLID,
    CAR_SOLID,
    CARET_DOWN_SOLID,
    CARET_LEFT_SOLID,
    CARET_RIGHT_SOLID,
    CARET_SQUARE_DOWN_SOLID,
    CARET_SQUARE_DOWN,
    CARET_SQUARE_LEFT_SOLID,
    CARET_SQUARE_LEFT,
    CARET_SQUARE_RIGHT_SOLID,
    CARET_SQUARE_RIGHT,
    CARET_SQUARE_UP_SOLID,
    CARET_SQUARE_UP,
    CARET_UP_SOLID,
    CARROT_SOLID,
    CART_ARROW_DOWN_SOLID,
    CART_PLUS_SOLID,
    CASH_REGISTER_SOLID,
    CAT_SOLID,
    CC_AMAZON_PAY,
    CC_AMEX,
    CC_APPLE_PAY,
    CC_DINERS_CLUB,
    CC_DISCOVER,
    CC_JCB,
    CC_MASTERCARD,
    CC_PAYPAL,
    CC_STRIPE,
    CC_VISA,
    CENTERCODE,
    CENTOS,
    CERTIFICATE_SOLID,
    CHAIR_SOLID,
    CHALKBOARD_SOLID,
    CHALKBOARD_TEACHER_SOLID,
    CHARGING_STATION_SOLID,
    CHART_AREA_SOLID,
    CHART_BAR_SOLID,
    CHART_BAR,
    CHART_LINE_SOLID,
    CHART_PIE_SOLID,
    CHECK_CIRCLE_SOLID,
    CHECK_CIRCLE,
    CHECK_DOUBLE_SOLID,
    CHECK_SOLID,
    CHECK_SQUARE_SOLID,
    CHECK_SQUARE,
    CHEESE_SOLID,
    CHESS_BISHOP_SOLID,
    CHESS_BOARD_SOLID,
    CHESS_KING_SOLID,
    CHESS_KNIGHT_SOLID,
    CHESS_PAWN_SOLID,
    CHESS_QUEEN_SOLID,
    CHESS_ROOK_SOLID,
    CHESS_SOLID,
    CHEVRON_CIRCLE_DOWN_SOLID,
    CHEVRON_CIRCLE_LEFT_SOLID,
    CHEVRON_CIRCLE_RIGHT_SOLID,
    CHEVRON_CIRCLE_UP_SOLID,
    CHEVRON_DOWN_SOLID,
    CHEVRON_LEFT_SOLID,
    CHEVRON_RIGHT_SOLID,
    CHEVRON_UP_SOLID,
    CHILD_SOLID,
    CHROME,
    CHROMECAST,
    CHURCH_SOLID,
    CIRCLE_NOTCH_SOLID,
    CIRCLE_SOLID,
    CIRCLE,
    CITY_SOLID,
    CLINIC_MEDICAL_SOLID,
    CLIPBOARD_CHECK_SOLID,
    CLIPBOARD_LIST_SOLID,
    CLIPBOARD_SOLID,
    CLIPBOARD,
    CLOCK_SOLID,
    CLOCK,
    CLONE_SOLID,
    CLONE,
    CLOSED_CAPTIONING_SOLID,
    CLOSED_CAPTIONING,
    CLOUD_DOWNLOAD_ALT_SOLID,
    CLOUD_MEATBALL_SOLID,
    CLOUD_MOON_RAIN_SOLID,
    CLOUD_MOON_SOLID,
    CLOUD_RAIN_SOLID,
    CLOUD_SHOWERS_HEAVY_SOLID,
    CLOUD_SOLID,
    CLOUD_SUN_RAIN_SOLID,
    CLOUD_SUN_SOLID,
    CLOUD_UPLOAD_ALT_SOLID,
    CLOUDSCALE,
    CLOUDSMITH,
    CLOUDVERSIFY,
    COCKTAIL_SOLID,
    CODE_BRANCH_SOLID,
    CODE_SOLID,
    CODEPEN,
    CODIEPIE,
    COFFEE_SOLID,
    COG_SOLID,
    COGS_SOLID,
    COINS_SOLID,
    COLUMNS_SOLID,
    COMMENT_ALT_SOLID,
    COMMENT_ALT,
    COMMENT_DOLLAR_SOLID,
    COMMENT_DOTS_SOLID,
    COMMENT_DOTS,
    COMMENT_MEDICAL_SOLID,
    COMMENT_SLASH_SOLID,
    COMMENT_SOLID,
    COMMENT,
    COMMENTS_DOLLAR_SOLID,
    COMMENTS_SOLID,
    COMMENTS,
    COMPACT_DISC_SOLID,
    COMPASS_SOLID,
    COMPASS,
    COMPRESS_ARROWS_ALT_SOLID,
    COMPRESS_SOLID,
    CONCIERGE_BELL_SOLID,
    CONFLUENCE,
    CONNECTDEVELOP,
    CONTAO,
    COOKIE_BITE_SOLID,
    COOKIE_SOLID,
    COPY_SOLID,
    COPY,
    COPYRIGHT_SOLID,
    COPYRIGHT,
    COTTON_BUREAU,
    COUCH_SOLID,
    CPANEL,
    CREATIVE_COMMONS_BY,
    CREATIVE_COMMONS_NC_EU,
    CREATIVE_COMMONS_NC_JP,
    CREATIVE_COMMONS_NC,
    CREATIVE_COMMONS_ND,
    CREATIVE_COMMONS_PD_ALT,
    CREATIVE_COMMONS_PD,
    CREATIVE_COMMONS_REMIX,
    CREATIVE_COMMONS_SA,
    CREATIVE_COMMONS_SAMPLING_PLUS,
    CREATIVE_COMMONS_SAMPLING,
    CREATIVE_COMMONS_SHARE,
    CREATIVE_COMMONS_ZERO,
    CREATIVE_COMMONS,
    CREDIT_CARD_SOLID,
    CREDIT_CARD,
    CRITICAL_ROLE,
    CROP_ALT_SOLID,
    CROP_SOLID,
    CROSS_SOLID,
    CROSSHAIRS_SOLID,
    CROW_SOLID,
    CROWN_SOLID,
    CRUTCH_SOLID,
    CSS3_ALT,
    CSS3,
    CUBE_SOLID,
    CUBES_SOLID,
    CUT_SOLID,
    CUTTLEFISH,
    D_AND_D_BEYOND,
    D_AND_D,
    DASHCUBE,
    DATABASE_SOLID,
    DEAF_SOLID,
    DELICIOUS,
    DEMOCRAT_SOLID,
    DEPLOYDOG,
    DESKPRO,
    DESKTOP_SOLID,
    DEV,
    DEVIANTART,
    DHARMACHAKRA_SOLID,
    DHL,
    DIAGNOSES_SOLID,
    DIASPORA,
    DICE_D20_SOLID,
    DICE_D6_SOLID,
    DICE_FIVE_SOLID,
    DICE_FOUR_SOLID,
    DICE_ONE_SOLID,
    DICE_SIX_SOLID,
    DICE_SOLID,
    DICE_THREE_SOLID,
    DICE_TWO_SOLID,
    DIGG,
    DIGITAL_OCEAN,
    DIGITAL_TACHOGRAPH_SOLID,
    DIRECTIONS_SOLID,
    DISCORD,
    DISCOURSE,
    DIVIDE_SOLID,
    DIZZY_SOLID,
    DIZZY,
    DNA_SOLID,
    DOCHUB,
    DOCKER,
    DOG_SOLID,
    DOLLAR_SIGN_SOLID,
    DOLLY_FLATBED_SOLID,
    DOLLY_SOLID,
    DONATE_SOLID,
    DOOR_CLOSED_SOLID,
    DOOR_OPEN_SOLID,
    DOT_CIRCLE_SOLID,
    DOT_CIRCLE,
    DOVE_SOLID,
    DOWNLOAD_SOLID,
    DRAFT2DIGITAL,
    DRAFTING_COMPASS_SOLID,
    DRAGON_SOLID,
    DRAW_POLYGON_SOLID,
    DRIBBBLE_SQUARE,
    DRIBBBLE,
    DROPBOX,
    DRUM_SOLID,
    DRUM_STEELPAN_SOLID,
    DRUMSTICK_BITE_SOLID,
    DRUPAL,
    DUMBBELL_SOLID,
    DUMPSTER_FIRE_SOLID,
    DUMPSTER_SOLID,
    DUNGEON_SOLID,
    DYALOG,
    EARLYBIRDS,
    EBAY,
    EDGE,
    EDIT_SOLID,
    EDIT,
    EGG_SOLID,
    EJECT_SOLID,
    ELEMENTOR,
    ELLIPSIS_H_SOLID,
    ELLIPSIS_V_SOLID,
    ELLO,
    EMBER,
    EMPIRE,
    ENVELOPE_OPEN_SOLID,
    ENVELOPE_OPEN_TEXT_SOLID,
    ENVELOPE_OPEN,
    ENVELOPE_SOLID,
    ENVELOPE_SQUARE_SOLID,
    ENVELOPE,
    ENVIRA,
    EQUALS_SOLID,
    ERASER_SOLID,
    ERLANG,
    ETHEREUM,
    ETHERNET_SOLID,
    ETSY,
    EURO_SIGN_SOLID,
    EVERNOTE,
    EXCHANGE_ALT_SOLID,
    EXCLAMATION_CIRCLE_SOLID,
    EXCLAMATION_SOLID,
    EXCLAMATION_TRIANGLE_SOLID,
    EXPAND_ARROWS_ALT_SOLID,
    EXPAND_SOLID,
    EXPEDITEDSSL,
    EXTERNAL_LINK_ALT_SOLID,
    EXTERNAL_LINK_SQUARE_ALT_SOLID,
    EYE_DROPPER_SOLID,
    EYE_SLASH_SOLID,
    EYE_SLASH,
    EYE_SOLID,
    EYE,
    FACEBOOK_F,
    FACEBOOK_MESSENGER,
    FACEBOOK_SQUARE,
    FACEBOOK,
    FAN_SOLID,
    FANTASY_FLIGHT_GAMES,
    FAST_BACKWARD_SOLID,
    FAST_FORWARD_SOLID,
    FAX_SOLID,
    FEATHER_ALT_SOLID,
    FEATHER_SOLID,
    FEDEX,
    FEDORA,
    FEMALE_SOLID,
    FIGHTER_JET_SOLID,
    FIGMA,
    FILE_ALT_SOLID,
    FILE_ALT,
    FILE_ARCHIVE_SOLID,
    FILE_ARCHIVE,
    FILE_AUDIO_SOLID,
    FILE_AUDIO,
    FILE_CODE_SOLID,
    FILE_CODE,
    FILE_CONTRACT_SOLID,
    FILE_CSV_SOLID,
    FILE_DOWNLOAD_SOLID,
    FILE_EXCEL_SOLID,
    FILE_EXCEL,
    FILE_EXPORT_SOLID,
    FILE_IMAGE_SOLID,
    FILE_IMAGE,
    FILE_IMPORT_SOLID,
    FILE_INVOICE_DOLLAR_SOLID,
    FILE_INVOICE_SOLID,
    FILE_MEDICAL_ALT_SOLID,
    FILE_MEDICAL_SOLID,
    FILE_PDF_SOLID,
    FILE_PDF,
    FILE_POWERPOINT_SOLID,
    FILE_POWERPOINT,
    FILE_PRESCRIPTION_SOLID,
    FILE_SIGNATURE_SOLID,
    FILE_SOLID,
    FILE_UPLOAD_SOLID,
    FILE_VIDEO_SOLID,
    FILE_VIDEO,
    FILE_WORD_SOLID,
    FILE_WORD,
    FILE,
    FILL_DRIP_SOLID,
    FILL_SOLID,
    FILM_SOLID,
    FILTER_SOLID,
    FINGERPRINT_SOLID,
    FIRE_ALT_SOLID,
    FIRE_EXTINGUISHER_SOLID,
    FIRE_SOLID,
    FIREFOX,
    FIRST_AID_SOLID,
    FIRST_ORDER_ALT,
    FIRST_ORDER,
    FIRSTDRAFT,
    FISH_SOLID,
    FIST_RAISED_SOLID,
    FLAG_CHECKERED_SOLID,
    FLAG_SOLID,
    FLAG_USA_SOLID,
    FLAG,
    FLASK_SOLID,
    FLICKR,
    FLIPBOARD,
    FLUSHED_SOLID,
    FLUSHED,
    FLY,
    FOLDER_MINUS_SOLID,
    FOLDER_OPEN_SOLID,
    FOLDER_OPEN,
    FOLDER_PLUS_SOLID,
    FOLDER_SOLID,
    FOLDER,
    FONT_AWESOME_ALT,
    FONT_AWESOME_FLAG,
    FONT_AWESOME,
    FONT_SOLID,
    FONTICONS_FI,
    FONTICONS,
    FOOTBALL_BALL_SOLID,
    FORT_AWESOME_ALT,
    FORT_AWESOME,
    FORUMBEE,
    FORWARD_SOLID,
    FOURSQUARE,
    FREE_CODE_CAMP,
    FREEBSD,
    FROG_SOLID,
    FROWN_OPEN_SOLID,
    FROWN_OPEN,
    FROWN_SOLID,
    FROWN,
    FULCRUM,
    FUNNEL_DOLLAR_SOLID,
    FUTBOL_SOLID,
    FUTBOL,
    GALACTIC_REPUBLIC,
    GALACTIC_SENATE,
    GAMEPAD_SOLID,
    GAS_PUMP_SOLID,
    GAVEL_SOLID,
    GEM_SOLID,
    GEM,
    GENDERLESS_SOLID,
    GET_POCKET,
    GG_CIRCLE,
    GG,
    GHOST_SOLID,
    GIFT_SOLID,
    GIFTS_SOLID,
    GIT_ALT,
    GIT_SQUARE,
    GIT,
    GITHUB_ALT,
    GITHUB_SQUARE,
    GITHUB,
    GITKRAKEN,
    GITLAB,
    GITTER,
    GLASS_CHEERS_SOLID,
    GLASS_MARTINI_ALT_SOLID,
    GLASS_MARTINI_SOLID,
    GLASS_WHISKEY_SOLID,
    GLASSES_SOLID,
    GLIDE_G,
    GLIDE,
    GLOBE_AFRICA_SOLID,
    GLOBE_AMERICAS_SOLID,
    GLOBE_ASIA_SOLID,
    GLOBE_EUROPE_SOLID,
    GLOBE_SOLID,
    GOFORE,
    GOLF_BALL_SOLID,
    GOODREADS_G,
    GOODREADS,
    GOOGLE_DRIVE,
    GOOGLE_PLAY,
    GOOGLE_PLUS_G,
    GOOGLE_PLUS_SQUARE,
    GOOGLE_PLUS,
    GOOGLE_WALLET,
    GOOGLE,
    GOPURAM_SOLID,
    GRADUATION_CAP_SOLID,
    GRATIPAY,
    GRAV,
    GREATER_THAN_EQUAL_SOLID,
    GREATER_THAN_SOLID,
    GRIMACE_SOLID,
    GRIMACE,
    GRIN_ALT_SOLID,
    GRIN_ALT,
    GRIN_BEAM_SOLID,
    GRIN_BEAM_SWEAT_SOLID,
    GRIN_BEAM_SWEAT,
    GRIN_BEAM,
    GRIN_HEARTS_SOLID,
    GRIN_HEARTS,
    GRIN_SOLID,
    GRIN_SQUINT_SOLID,
    GRIN_SQUINT_TEARS_SOLID,
    GRIN_SQUINT_TEARS,
    GRIN_SQUINT,
    GRIN_STARS_SOLID,
    GRIN_STARS,
    GRIN_TEARS_SOLID,
    GRIN_TEARS,
    GRIN_TONGUE_SOLID,
    GRIN_TONGUE_SQUINT_SOLID,
    GRIN_TONGUE_SQUINT,
    GRIN_TONGUE_WINK_SOLID,
    GRIN_TONGUE_WINK,
    GRIN_TONGUE,
    GRIN_WINK_SOLID,
    GRIN_WINK,
    GRIN,
    GRIP_HORIZONTAL_SOLID,
    GRIP_LINES_SOLID,
    GRIP_LINES_VERTICAL_SOLID,
    GRIP_VERTICAL_SOLID,
    GRIPFIRE,
    GRUNT,
    GUITAR_SOLID,
    GULP,
    H_SQUARE_SOLID,
    HACKER_NEWS_SQUARE,
    HACKER_NEWS,
    HACKERRANK,
    HAMBURGER_SOLID,
    HAMMER_SOLID,
    HAMSA_SOLID,
    HAND_HOLDING_HEART_SOLID,
    HAND_HOLDING_SOLID,
    HAND_HOLDING_USD_SOLID,
    HAND_LIZARD_SOLID,
    HAND_LIZARD,
    HAND_MIDDLE_FINGER_SOLID,
    HAND_PAPER_SOLID,
    HAND_PAPER,
    HAND_PEACE_SOLID,
    HAND_PEACE,
    HAND_POINT_DOWN_SOLID,
    HAND_POINT_DOWN,
    HAND_POINT_LEFT_SOLID,
    HAND_POINT_LEFT,
    HAND_POINT_RIGHT_SOLID,
    HAND_POINT_RIGHT,
    HAND_POINT_UP_SOLID,
    HAND_POINT_UP,
    HAND_POINTER_SOLID,
    HAND_POINTER,
    HAND_ROCK_SOLID,
    HAND_ROCK,
    HAND_SCISSORS_SOLID,
    HAND_SCISSORS,
    HAND_SPOCK_SOLID,
    HAND_SPOCK,
    HANDS_HELPING_SOLID,
    HANDS_SOLID,
    HANDSHAKE_SOLID,
    HANDSHAKE,
    HANUKIAH_SOLID,
    HARD_HAT_SOLID,
    HASHTAG_SOLID,
    HAT_COWBOY_SIDE_SOLID,
    HAT_COWBOY_SOLID,
    HAT_WIZARD_SOLID,
    HAYKAL_SOLID,
    HDD_SOLID,
    HDD,
    HEADING_SOLID,
    HEADPHONES_ALT_SOLID,
    HEADPHONES_SOLID,
    HEADSET_SOLID,
    HEART_BROKEN_SOLID,
    HEART_SOLID,
    HEART,
    HEARTBEAT_SOLID,
    HELICOPTER_SOLID,
    HIGHLIGHTER_SOLID,
    HIKING_SOLID,
    HIPPO_SOLID,
    HIPS,
    HIRE_A_HELPER,
    HISTORY_SOLID,
    HOCKEY_PUCK_SOLID,
    HOLLY_BERRY_SOLID,
    HOME_SOLID,
    HOOLI,
    HORNBILL,
    HORSE_HEAD_SOLID,
    HORSE_SOLID,
    HOSPITAL_ALT_SOLID,
    HOSPITAL_SOLID,
    HOSPITAL_SYMBOL_SOLID,
    HOSPITAL,
    HOT_TUB_SOLID,
    HOTDOG_SOLID,
    HOTEL_SOLID,
    HOTJAR,
    HOURGLASS_END_SOLID,
    HOURGLASS_HALF_SOLID,
    HOURGLASS_SOLID,
    HOURGLASS_START_SOLID,
    HOURGLASS,
    HOUSE_DAMAGE_SOLID,
    HOUZZ,
    HRYVNIA_SOLID,
    HTML5,
    HUBSPOT,
    I_CURSOR_SOLID,
    ICE_CREAM_SOLID,
    ICICLES_SOLID,
    ICONS_SOLID,
    ID_BADGE_SOLID,
    ID_BADGE,
    ID_CARD_ALT_SOLID,
    ID_CARD_SOLID,
    ID_CARD,
    IGLOO_SOLID,
    IMAGE_SOLID,
    IMAGE,
    IMAGES_SOLID,
    IMAGES,
    IMDB,
    INBOX_SOLID,
    INDENT_SOLID,
    INDUSTRY_SOLID,
    INFINITY_SOLID,
    INFO_CIRCLE_SOLID,
    INFO_SOLID,
    INSTAGRAM,
    INTERCOM,
    INTERNET_EXPLORER,
    INVISION,
    IOXHOST,
    ITALIC_SOLID,
    ITCH_IO,
    ITUNES_NOTE,
    ITUNES,
    JAVA,
    JEDI_ORDER,
    JEDI_SOLID,
    JENKINS,
    JIRA,
    JOGET,
    JOINT_SOLID,
    JOOMLA,
    JOURNAL_WHILLS_SOLID,
    JS_SQUARE,
    JS,
    JSFIDDLE,
    KAABA_SOLID,
    KAGGLE,
    KEY_SOLID,
    KEYBASE,
    KEYBOARD_SOLID,
    KEYBOARD,
    KEYCDN,
    KHANDA_SOLID,
    KICKSTARTER_K,
    KICKSTARTER,
    KISS_BEAM_SOLID,
    KISS_BEAM,
    KISS_SOLID,
    KISS_WINK_HEART_SOLID,
    KISS_WINK_HEART,
    KISS,
    KIWI_BIRD_SOLID,
    KORVUE,
    LANDMARK_SOLID,
    LANGUAGE_SOLID,
    LAPTOP_CODE_SOLID,
    LAPTOP_MEDICAL_SOLID,
    LAPTOP_SOLID,
    LARAVEL,
    LASTFM_SQUARE,
    LASTFM,
    LAUGH_BEAM_SOLID,
    LAUGH_BEAM,
    LAUGH_SOLID,
    LAUGH_SQUINT_SOLID,
    LAUGH_SQUINT,
    LAUGH_WINK_SOLID,
    LAUGH_WINK,
    LAUGH,
    LAYER_GROUP_SOLID,
    LEAF_SOLID,
    LEANPUB,
    LEMON_SOLID,
    LEMON,
    LESS_THAN_EQUAL_SOLID,
    LESS_THAN_SOLID,
    LESS,
    LEVEL_DOWN_ALT_SOLID,
    LEVEL_UP_ALT_SOLID,
    LIFE_RING_SOLID,
    LIFE_RING,
    LIGHTBULB_SOLID,
    LIGHTBULB,
    LINE,
    LINK_SOLID,
    LINKEDIN_IN,
    LINKEDIN,
    LINODE,
    LINUX,
    LIRA_SIGN_SOLID,
    LIST_ALT_SOLID,
    LIST_ALT,
    LIST_OL_SOLID,
    LIST_SOLID,
    LIST_UL_SOLID,
    LOCATION_ARROW_SOLID,
    LOCK_OPEN_SOLID,
    LOCK_SOLID,
    LONG_ARROW_ALT_DOWN_SOLID,
    LONG_ARROW_ALT_LEFT_SOLID,
    LONG_ARROW_ALT_RIGHT_SOLID,
    LONG_ARROW_ALT_UP_SOLID,
    LOW_VISION_SOLID,
    LUGGAGE_CART_SOLID,
    LYFT,
    MAGENTO,
    MAGIC_SOLID,
    MAGNET_SOLID,
    MAIL_BULK_SOLID,
    MAILCHIMP,
    MALE_SOLID,
    MANDALORIAN,
    MAP_MARKED_ALT_SOLID,
    MAP_MARKED_SOLID,
    MAP_MARKER_ALT_SOLID,
    MAP_MARKER_SOLID,
    MAP_PIN_SOLID,
    MAP_SIGNS_SOLID,
    MAP_SOLID,
    MAP,
    MARKDOWN,
    MARKER_SOLID,
    MARS_DOUBLE_SOLID,
    MARS_SOLID,
    MARS_STROKE_H_SOLID,
    MARS_STROKE_SOLID,
    MARS_STROKE_V_SOLID,
    MASK_SOLID,
    MASTODON,
    MAXCDN,
    MDB,
    MEDAL_SOLID,
    MEDAPPS,
    MEDIUM_M,
    MEDIUM,
    MEDKIT_SOLID,
    MEDRT,
    MEETUP,
    MEGAPORT,
    MEH_BLANK_SOLID,
    MEH_BLANK,
    MEH_ROLLING_EYES_SOLID,
    MEH_ROLLING_EYES,
    MEH_SOLID,
    MEH,
    MEMORY_SOLID,
    MENDELEY,
    MENORAH_SOLID,
    MERCURY_SOLID,
    METEOR_SOLID,
    MICROCHIP_SOLID,
    MICROPHONE_ALT_SLASH_SOLID,
    MICROPHONE_ALT_SOLID,
    MICROPHONE_SLASH_SOLID,
    MICROPHONE_SOLID,
    MICROSCOPE_SOLID,
    MICROSOFT,
    MINUS_CIRCLE_SOLID,
    MINUS_SOLID,
    MINUS_SQUARE_SOLID,
    MINUS_SQUARE,
    MITTEN_SOLID,
    MIX,
    MIXCLOUD,
    MIZUNI,
    MOBILE_ALT_SOLID,
    MOBILE_SOLID,
    MODX,
    MONERO,
    MONEY_BILL_ALT_SOLID,
    MONEY_BILL_ALT,
    MONEY_BILL_SOLID,
    MONEY_BILL_WAVE_ALT_SOLID,
    MONEY_BILL_WAVE_SOLID,
    MONEY_CHECK_ALT_SOLID,
    MONEY_CHECK_SOLID,
    MONUMENT_SOLID,
    MOON_SOLID,
    MOON,
    MORTAR_PESTLE_SOLID,
    MOSQUE_SOLID,
    MOTORCYCLE_SOLID,
    MOUNTAIN_SOLID,
    MOUSE_POINTER_SOLID,
    MOUSE_SOLID,
    MUG_HOT_SOLID,
    MUSIC_SOLID,
    NAPSTER,
    NEOS,
    NETWORK_WIRED_SOLID,
    NEUTER_SOLID,
    NEWSPAPER_SOLID,
    NEWSPAPER,
    NIMBLR,
    NODE_JS,
    NODE,
    NOT_EQUAL_SOLID,
    NOTES_MEDICAL_SOLID,
    NPM,
    NS8,
    NUTRITIONIX,
    OBJECT_GROUP_SOLID,
    OBJECT_GROUP,
    OBJECT_UNGROUP_SOLID,
    OBJECT_UNGROUP,
    ODNOKLASSNIKI_SQUARE,
    ODNOKLASSNIKI,
    OIL_CAN_SOLID,
    OLD_REPUBLIC,
    OM_SOLID,
    OPENCART,
    OPENID,
    OPERA,
    OPTIN_MONSTER,
    ORCID,
    OSI,
    OTTER_SOLID,
    OUTDENT_SOLID,
    PAGE4,
    PAGELINES,
    PAGER_SOLID,
    PAINT_BRUSH_SOLID,
    PAINT_ROLLER_SOLID,
    PALETTE_SOLID,
    PALFED,
    PALLET_SOLID,
    PAPER_PLANE_SOLID,
    PAPER_PLANE,
    PAPERCLIP_SOLID,
    PARACHUTE_BOX_SOLID,
    PARAGRAPH_SOLID,
    PARKING_SOLID,
    PASSPORT_SOLID,
    PASTAFARIANISM_SOLID,
    PASTE_SOLID,
    PATREON,
    PAUSE_CIRCLE_SOLID,
    PAUSE_CIRCLE,
    PAUSE_SOLID,
    PAW_SOLID,
    PAYPAL,
    PEACE_SOLID,
    PEN_ALT_SOLID,
    PEN_FANCY_SOLID,
    PEN_NIB_SOLID,
    PEN_SOLID,
    PEN_SQUARE_SOLID,
    PENCIL_ALT_SOLID,
    PENCIL_RULER_SOLID,
    PENNY_ARCADE,
    PEOPLE_CARRY_SOLID,
    PEPPER_HOT_SOLID,
    PERCENT_SOLID,
    PERCENTAGE_SOLID,
    PERISCOPE,
    PERSON_BOOTH_SOLID,
    PHABRICATOR,
    PHOENIX_FRAMEWORK,
    PHOENIX_SQUADRON,
    PHONE_ALT_SOLID,
    PHONE_SLASH_SOLID,
    PHONE_SOLID,
    PHONE_SQUARE_ALT_SOLID,
    PHONE_SQUARE_SOLID,
    PHONE_VOLUME_SOLID,
    PHOTO_VIDEO_SOLID,
    PHP,
    PIED_PIPER_ALT,
    PIED_PIPER_HAT,
    PIED_PIPER_PP,
    PIED_PIPER,
    PIGGY_BANK_SOLID,
    PILLS_SOLID,
    PINTEREST_P,
    PINTEREST_SQUARE,
    PINTEREST,
    PIZZA_SLICE_SOLID,
    PLACE_OF_WORSHIP_SOLID,
    PLANE_ARRIVAL_SOLID,
    PLANE_DEPARTURE_SOLID,
    PLANE_SOLID,
    PLAY_CIRCLE_SOLID,
    PLAY_CIRCLE,
    PLAY_SOLID,
    PLAYSTATION,
    PLUG_SOLID,
    PLUS_CIRCLE_SOLID,
    PLUS_SOLID,
    PLUS_SQUARE_SOLID,
    PLUS_SQUARE,
    PODCAST_SOLID,
    POLL_H_SOLID,
    POLL_SOLID,
    POO_SOLID,
    POO_STORM_SOLID,
    POOP_SOLID,
    PORTRAIT_SOLID,
    POUND_SIGN_SOLID,
    POWER_OFF_SOLID,
    PRAY_SOLID,
    PRAYING_HANDS_SOLID,
    PRESCRIPTION_BOTTLE_ALT_SOLID,
    PRESCRIPTION_BOTTLE_SOLID,
    PRESCRIPTION_SOLID,
    PRINT_SOLID,
    PROCEDURES_SOLID,
    PRODUCT_HUNT,
    PROJECT_DIAGRAM_SOLID,
    PUSHED,
    PUZZLE_PIECE_SOLID,
    PYTHON,
    QQ,
    QRCODE_SOLID,
    QUESTION_CIRCLE_SOLID,
    QUESTION_CIRCLE,
    QUESTION_SOLID,
    QUIDDITCH_SOLID,
    QUINSCAPE,
    QUORA,
    QUOTE_LEFT_SOLID,
    QUOTE_RIGHT_SOLID,
    QURAN_SOLID,
    R_PROJECT,
    RADIATION_ALT_SOLID,
    RADIATION_SOLID,
    RAINBOW_SOLID,
    RANDOM_SOLID,
    RASPBERRY_PI,
    RAVELRY,
    REACT,
    REACTEUROPE,
    README,
    REBEL,
    RECEIPT_SOLID,
    RECORD_VINYL_SOLID,
    RECYCLE_SOLID,
    RED_RIVER,
    REDDIT_ALIEN,
    REDDIT_SQUARE,
    REDDIT,
    REDHAT,
    REDO_ALT_SOLID,
    REDO_SOLID,
    REGISTERED_SOLID,
    REGISTERED,
    REMOVE_FORMAT_SOLID,
    RENREN,
    REPLY_ALL_SOLID,
    REPLY_SOLID,
    REPLYD,
    REPUBLICAN_SOLID,
    RESEARCHGATE,
    RESOLVING,
    RESTROOM_SOLID,
    RETWEET_SOLID,
    REV,
    RIBBON_SOLID,
    RING_SOLID,
    ROAD_SOLID,
    ROBOT_SOLID,
    ROCKET_SOLID,
    ROCKETCHAT,
    ROCKRMS,
    ROUTE_SOLID,
    RSS_SOLID,
    RSS_SQUARE_SOLID,
    RUBLE_SIGN_SOLID,
    RULER_COMBINED_SOLID,
    RULER_HORIZONTAL_SOLID,
    RULER_SOLID,
    RULER_VERTICAL_SOLID,
    RUNNING_SOLID,
    RUPEE_SIGN_SOLID,
    SAD_CRY_SOLID,
    SAD_CRY,
    SAD_TEAR_SOLID,
    SAD_TEAR,
    SAFARI,
    SALESFORCE,
    SASS,
    SATELLITE_DISH_SOLID,
    SATELLITE_SOLID,
    SAVE_SOLID,
    SAVE,
    SCHLIX,
    SCHOOL_SOLID,
    SCREWDRIVER_SOLID,
    SCRIBD,
    SCROLL_SOLID,
    SD_CARD_SOLID,
    SEARCH_DOLLAR_SOLID,
    SEARCH_LOCATION_SOLID,
    SEARCH_MINUS_SOLID,
    SEARCH_PLUS_SOLID,
    SEARCH_SOLID,
    SEARCHENGIN,
    SEEDLING_SOLID,
    SELLCAST,
    SELLSY,
    SERVER_SOLID,
    SERVICESTACK,
    SHAPES_SOLID,
    SHARE_ALT_SOLID,
    SHARE_ALT_SQUARE_SOLID,
    SHARE_SOLID,
    SHARE_SQUARE_SOLID,
    SHARE_SQUARE,
    SHEKEL_SIGN_SOLID,
    SHIELD_ALT_SOLID,
    SHIP_SOLID,
    SHIPPING_FAST_SOLID,
    SHIRTSINBULK,
    SHOE_PRINTS_SOLID,
    SHOPPING_BAG_SOLID,
    SHOPPING_BASKET_SOLID,
    SHOPPING_CART_SOLID,
    SHOPWARE,
    SHOWER_SOLID,
    SHUTTLE_VAN_SOLID,
    SIGN_IN_ALT_SOLID,
    SIGN_LANGUAGE_SOLID,
    SIGN_OUT_ALT_SOLID,
    SIGN_SOLID,
    SIGNAL_SOLID,
    SIGNATURE_SOLID,
    SIM_CARD_SOLID,
    SIMPLYBUILT,
    SISTRIX,
    SITEMAP_SOLID,
    SITH,
    SKATING_SOLID,
    SKETCH,
    SKIING_NORDIC_SOLID,
    SKIING_SOLID,
    SKULL_CROSSBONES_SOLID,
    SKULL_SOLID,
    SKYATLAS,
    SKYPE,
    SLACK_HASH,
    SLACK,
    SLASH_SOLID,
    SLEIGH_SOLID,
    SLIDERS_H_SOLID,
    SLIDESHARE,
    SMILE_BEAM_SOLID,
    SMILE_BEAM,
    SMILE_SOLID,
    SMILE_WINK_SOLID,
    SMILE_WINK,
    SMILE,
    SMOG_SOLID,
    SMOKING_BAN_SOLID,
    SMOKING_SOLID,
    SMS_SOLID,
    SNAPCHAT_GHOST,
    SNAPCHAT_SQUARE,
    SNAPCHAT,
    SNOWBOARDING_SOLID,
    SNOWFLAKE_SOLID,
    SNOWFLAKE,
    SNOWMAN_SOLID,
    SNOWPLOW_SOLID,
    SOCKS_SOLID,
    SOLAR_PANEL_SOLID,
    SORT_ALPHA_DOWN_ALT_SOLID,
    SORT_ALPHA_DOWN_SOLID,
    SORT_ALPHA_UP_ALT_SOLID,
    SORT_ALPHA_UP_SOLID,
    SORT_AMOUNT_DOWN_ALT_SOLID,
    SORT_AMOUNT_DOWN_SOLID,
    SORT_AMOUNT_UP_ALT_SOLID,
    SORT_AMOUNT_UP_SOLID,
    SORT_DOWN_SOLID,
    SORT_NUMERIC_DOWN_ALT_SOLID,
    SORT_NUMERIC_DOWN_SOLID,
    SORT_NUMERIC_UP_ALT_SOLID,
    SORT_NUMERIC_UP_SOLID,
    SORT_SOLID,
    SORT_UP_SOLID,
    SOUNDCLOUD,
    SOURCETREE,
    SPA_SOLID,
    SPACE_SHUTTLE_SOLID,
    SPEAKAP,
    SPEAKER_DECK,
    SPELL_CHECK_SOLID,
    SPIDER_SOLID,
    SPINNER_SOLID,
    SPLOTCH_SOLID,
    SPOTIFY,
    SPRAY_CAN_SOLID,
    SQUARE_FULL_SOLID,
    SQUARE_ROOT_ALT_SOLID,
    SQUARE_SOLID,
    SQUARE,
    SQUARESPACE,
    STACK_EXCHANGE,
    STACK_OVERFLOW,
    STACKPATH,
    STAMP_SOLID,
    STAR_AND_CRESCENT_SOLID,
    STAR_HALF_ALT_SOLID,
    STAR_HALF_SOLID,
    STAR_HALF,
    STAR_OF_DAVID_SOLID,
    STAR_OF_LIFE_SOLID,
    STAR_SOLID,
    STAR,
    STAYLINKED,
    STEAM_SQUARE,
    STEAM_SYMBOL,
    STEAM,
    STEP_BACKWARD_SOLID,
    STEP_FORWARD_SOLID,
    STETHOSCOPE_SOLID,
    STICKER_MULE,
    STICKY_NOTE_SOLID,
    STICKY_NOTE,
    STOP_CIRCLE_SOLID,
    STOP_CIRCLE,
    STOP_SOLID,
    STOPWATCH_SOLID,
    STORE_ALT_SOLID,
    STORE_SOLID,
    STRAVA,
    STREAM_SOLID,
    STREET_VIEW_SOLID,
    STRIKETHROUGH_SOLID,
    STRIPE_S,
    STRIPE,
    STROOPWAFEL_SOLID,
    STUDIOVINARI,
    STUMBLEUPON_CIRCLE,
    STUMBLEUPON,
    SUBSCRIPT_SOLID,
    SUBWAY_SOLID,
    SUITCASE_ROLLING_SOLID,
    SUITCASE_SOLID,
    SUN_SOLID,
    SUN,
    SUPERPOWERS,
    SUPERSCRIPT_SOLID,
    SUPPLE,
    SURPRISE_SOLID,
    SURPRISE,
    SUSE,
    SWATCHBOOK_SOLID,
    SWIFT,
    SWIMMER_SOLID,
    SWIMMING_POOL_SOLID,
    SYMFONY,
    SYNAGOGUE_SOLID,
    SYNC_ALT_SOLID,
    SYNC_SOLID,
    SYRINGE_SOLID,
    TABLE_SOLID,
    TABLE_TENNIS_SOLID,
    TABLET_ALT_SOLID,
    TABLET_SOLID,
    TABLETS_SOLID,
    TACHOMETER_ALT_SOLID,
    TAG_SOLID,
    TAGS_SOLID,
    TAPE_SOLID,
    TASKS_SOLID,
    TAXI_SOLID,
    TEAMSPEAK,
    TEETH_OPEN_SOLID,
    TEETH_SOLID,
    TELEGRAM_PLANE,
    TELEGRAM,
    TEMPERATURE_HIGH_SOLID,
    TEMPERATURE_LOW_SOLID,
    TENCENT_WEIBO,
    TENGE_SOLID,
    TERMINAL_SOLID,
    TEXT_HEIGHT_SOLID,
    TEXT_WIDTH_SOLID,
    TH_LARGE_SOLID,
    TH_LIST_SOLID,
    TH_SOLID,
    THE_RED_YETI,
    THEATER_MASKS_SOLID,
    THEMECO,
    THEMEISLE,
    THERMOMETER_EMPTY_SOLID,
    THERMOMETER_FULL_SOLID,
    THERMOMETER_HALF_SOLID,
    THERMOMETER_QUARTER_SOLID,
    THERMOMETER_SOLID,
    THERMOMETER_THREE_QUARTERS_SOLID,
    THINK_PEAKS,
    THUMBS_DOWN_SOLID,
    THUMBS_DOWN,
    THUMBS_UP_SOLID,
    THUMBS_UP,
    THUMBTACK_SOLID,
    TICKET_ALT_SOLID,
    TIMES_CIRCLE_SOLID,
    TIMES_CIRCLE,
    TIMES_SOLID,
    TINT_SLASH_SOLID,
    TINT_SOLID,
    TIRED_SOLID,
    TIRED,
    TOGGLE_OFF_SOLID,
    TOGGLE_ON_SOLID,
    TOILET_PAPER_SOLID,
    TOILET_SOLID,
    TOOLBOX_SOLID,
    TOOLS_SOLID,
    TOOTH_SOLID,
    TORAH_SOLID,
    TORII_GATE_SOLID,
    TRACTOR_SOLID,
    TRADE_FEDERATION,
    TRADEMARK_SOLID,
    TRAFFIC_LIGHT_SOLID,
    TRAIN_SOLID,
    TRAM_SOLID,
    TRANSGENDER_ALT_SOLID,
    TRANSGENDER_SOLID,
    TRASH_ALT_SOLID,
    TRASH_ALT,
    TRASH_RESTORE_ALT_SOLID,
    TRASH_RESTORE_SOLID,
    TRASH_SOLID,
    TREE_SOLID,
    TRELLO,
    TRIPADVISOR,
    TROPHY_SOLID,
    TRUCK_LOADING_SOLID,
    TRUCK_MONSTER_SOLID,
    TRUCK_MOVING_SOLID,
    TRUCK_PICKUP_SOLID,
    TRUCK_SOLID,
    TSHIRT_SOLID,
    TTY_SOLID,
    TUMBLR_SQUARE,
    TUMBLR,
    TV_SOLID,
    TWITCH,
    TWITTER_SQUARE,
    TWITTER,
    TYPO3,
    UBER,
    UBUNTU,
    UIKIT,
    UMBRACO,
    UMBRELLA_BEACH_SOLID,
    UMBRELLA_SOLID,
    UNDERLINE_SOLID,
    UNDO_ALT_SOLID,
    UNDO_SOLID,
    UNIREGISTRY,
    UNIVERSAL_ACCESS_SOLID,
    UNIVERSITY_SOLID,
    UNLINK_SOLID,
    UNLOCK_ALT_SOLID,
    UNLOCK_SOLID,
    UNTAPPD,
    UPLOAD_SOLID,
    UPS,
    USB,
    USER_ALT_SLASH_SOLID,
    USER_ALT_SOLID,
    USER_ASTRONAUT_SOLID,
    USER_CHECK_SOLID,
    USER_CIRCLE_SOLID,
    USER_CIRCLE,
    USER_CLOCK_SOLID,
    USER_COG_SOLID,
    USER_EDIT_SOLID,
    USER_FRIENDS_SOLID,
    USER_GRADUATE_SOLID,
    USER_INJURED_SOLID,
    USER_LOCK_SOLID,
    USER_MD_SOLID,
    USER_MINUS_SOLID,
    USER_NINJA_SOLID,
    USER_NURSE_SOLID,
    USER_PLUS_SOLID,
    USER_SECRET_SOLID,
    USER_SHIELD_SOLID,
    USER_SLASH_SOLID,
    USER_SOLID,
    USER_TAG_SOLID,
    USER_TIE_SOLID,
    USER_TIMES_SOLID,
    USER,
    USERS_COG_SOLID,
    USERS_SOLID,
    USPS,
    USSUNNAH,
    UTENSIL_SPOON_SOLID,
    UTENSILS_SOLID,
    VAADIN,
    VECTOR_SQUARE_SOLID,
    VENUS_DOUBLE_SOLID,
    VENUS_MARS_SOLID,
    VENUS_SOLID,
    VIACOIN,
    VIADEO_SQUARE,
    VIADEO,
    VIAL_SOLID,
    VIALS_SOLID,
    VIBER,
    VIDEO_SLASH_SOLID,
    VIDEO_SOLID,
    VIHARA_SOLID,
    VIMEO_SQUARE,
    VIMEO_V,
    VIMEO,
    VINE,
    VK,
    VNV,
    VOICEMAIL_SOLID,
    VOLLEYBALL_BALL_SOLID,
    VOLUME_DOWN_SOLID,
    VOLUME_MUTE_SOLID,
    VOLUME_OFF_SOLID,
    VOLUME_UP_SOLID,
    VOTE_YEA_SOLID,
    VR_CARDBOARD_SOLID,
    VUEJS,
    WALKING_SOLID,
    WALLET_SOLID,
    WAREHOUSE_SOLID,
    WATER_SOLID,
    WAVE_SQUARE_SOLID,
    WAZE,
    WEEBLY,
    WEIBO,
    WEIGHT_HANGING_SOLID,
    WEIGHT_SOLID,
    WEIXIN,
    WHATSAPP_SQUARE,
    WHATSAPP,
    WHEELCHAIR_SOLID,
    WHMCS,
    WIFI_SOLID,
    WIKIPEDIA_W,
    WIND_SOLID,
    WINDOW_CLOSE_SOLID,
    WINDOW_CLOSE,
    WINDOW_MAXIMIZE_SOLID,
    WINDOW_MAXIMIZE,
    WINDOW_MINIMIZE_SOLID,
    WINDOW_MINIMIZE,
    WINDOW_RESTORE_SOLID,
    WINDOW_RESTORE,
    WINDOWS,
    WINE_BOTTLE_SOLID,
    WINE_GLASS_ALT_SOLID,
    WINE_GLASS_SOLID,
    WIX,
    WIZARDS_OF_THE_COAST,
    WOLF_PACK_BATTALION,
    WON_SIGN_SOLID,
    WORDPRESS_SIMPLE,
    WORDPRESS,
    WPBEGINNER,
    WPEXPLORER,
    WPFORMS,
    WPRESSR,
    WRENCH_SOLID,
    X_RAY_SOLID,
    XBOX,
    XING_SQUARE,
    XING,
    Y_COMBINATOR,
    YAHOO,
    YAMMER,
    YANDEX_INTERNATIONAL,
    YANDEX,
    YARN,
    YELP,
    YEN_SIGN_SOLID,
    YIN_YANG_SOLID,
    YOAST,
    YOUTUBE_SQUARE,
    YOUTUBE,
    ZHIHU;

    private String svgName;

    private LineAwesomeIcon() {
        this.svgName = name().toLowerCase(Locale.ENGLISH).replace("_", "-");
    }

    private LineAwesomeIcon(String svgName) {
        this.svgName = svgName;
    }

    /**
     * Returns the name of the icon svg.
     * 
     * @return the name of the svg, without the ".svg" extension
     */
    public String getSvgName() {
        return svgName;
    }

    /**
     * Creates an icon instance.
     * 
     * @return the icon
     */
    public SvgIcon create() {
        return new SvgIcon("line-awesome/svg/" + getSvgName() + ".svg");
    }
}
