/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.StyleSheet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.vaadin.addons.maplibre.FillPaint;
import org.vaadin.addons.maplibre.GeoJsonHelper;
import org.vaadin.addons.maplibre.Layer;
import org.vaadin.addons.maplibre.LinePaint;
import org.vaadin.addons.maplibre.Marker;
import org.vaadin.addons.velocitycomponent.AbstractVelocityJsComponent;

@JavaScript(value="https://unpkg.com/maplibre-gl@latest/dist/maplibre-gl.js")
@StyleSheet(value="https://unpkg.com/maplibre-gl@latest/dist/maplibre-gl.css")
@Tag(value="div")
public class MapLibre
extends AbstractVelocityJsComponent
implements HasSize,
HasStyle {
    private Coordinate center = new Coordinate(0.0, 0.0);
    private int zoomLevel = 15;

    public MapLibre(URI styleUrl) {
        this.init(null, styleUrl.toString());
    }

    public MapLibre(String styleUrl) {
        this.init(null, styleUrl);
    }

    public MapLibre(InputStream styleJson) {
        try {
            this.init(IOUtils.toString((InputStream)styleJson, (Charset)Charset.defaultCharset()), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void init(String styleJson, String styleUrl) {
        this.setId("map");
        this.setWidth("800px");
        this.setHeight("500px");
        this.velocityJs("var style = $style;\nif(!style) {\n    style = '$styleUrl';\n}\nconst component = this;\nthis.map = new maplibregl.Map({\n  container: this,\n  style: style,\n  center: $GeoJsonHelper.toJs($this.center),\n  zoom: $this.zoomLevel\n});\nthis.map.on('load', () => {\n    component.styleloaded = true;\n});\nthis.map.addControl(new maplibregl.NavigationControl());\nsetTimeout(() => this.map.resize(),0);\n", Map.of("style", styleJson == null ? "null" : styleJson, "styleUrl", styleUrl == null ? "null" : styleUrl));
    }

    public Integer getZoomLevel() {
        return 15;
    }

    public Coordinate getCenter() {
        return this.center;
    }

    public String getMapStyle() {
        try {
            String s = IOUtils.resourceToString((String)"/kiinteistojaotus-taustakartalla.json", (Charset)Charset.defaultCharset());
            return s;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addSource(String name, Geometry geometry) {
        this.js("    map.addSource('$name', {\n      'type': 'geojson',\n      'data': $GeoJsonHelper.toJs($geometry)\n    });\n", Map.of("name", name, "geometry", geometry));
    }

    public Layer addLineLayer(Geometry geometry, LinePaint linePaint) {
        String id = UUID.randomUUID().toString();
        this.addSource(id, geometry);
        return this.addLineLayer(id, id, null, linePaint, geometry);
    }

    public Layer addFillLayer(Polygon polygon, FillPaint style) {
        String id = UUID.randomUUID().toString();
        this.addSource(id, (Geometry)polygon);
        return this.addFillLayer(id, id, null, style, (Geometry)polygon);
    }

    protected Layer addFillLayer(String name, String source, String sourceLayer, FillPaint paintJson, Geometry geom) {
        sourceLayer = sourceLayer == null ? "" : "'source-layer': '%s',".formatted(sourceLayer);
        this.js("    map.addLayer({\n      'id': '%s',\n      'type': 'fill',\n      'source': '%s',\n      %s\n      'layout': {},\n      'paint': %s\n    });\n".formatted(name, source, sourceLayer, paintJson), Collections.emptyMap());
        return new Layer(this, name, geom);
    }

    protected Layer addLineLayer(String name, String source, String sourceLayer, LinePaint paint, Geometry geom) {
        sourceLayer = sourceLayer == null ? "" : "'source-layer': '%s',".formatted(sourceLayer);
        this.js("    map.addLayer({\n      'id': '$name',\n      'type': 'line',\n      'source': '$source',\n       $sourceLayer\n      'layout': {\n        'line-join': 'round',\n        'line-cap': 'round'\n      },\n      'paint': $paint\n    });\n", Map.of("name", name, "source", source, "sourceLayer", sourceLayer, "paint", paint));
        return new Layer(this, name, geom);
    }

    public void removeLayer(Layer layer) {
        if (layer instanceof Marker) {
            Marker m = (Marker)layer;
            this.js("    component.markers['$id'].remove();\n", Map.of("id", m.id));
        } else {
            this.js("    map.removeLayer('$id');\n    map.removeSource('$id');\n", Map.of("id", layer.id));
        }
    }

    public void addSource(String name, String sourceDeclarationJson) {
        this.js("    map.addSource('$name', $sourceDeclarationJson);\n", Map.of("name", name, "sourceDeclarationJson", sourceDeclarationJson));
    }

    public Marker addMarker(double x, double y) {
        String id = UUID.randomUUID().toString();
        this.js("    component.markers = component.markers || {};\n    component.markers['$id'] = new maplibregl.Marker()\n            .setLngLat([$x, $y])\n            .addTo(map);\n", Map.of("id", id, "x", x, "y", y));
        return new Marker(this, id, new Coordinate(x, y));
    }

    protected VelocityContext getVelocityContext() {
        VelocityContext velocityContext = super.getVelocityContext();
        velocityContext.put("GeoJsonHelper", GeoJsonHelper.class);
        return velocityContext;
    }

    public void setCenter(double x, double y) {
        this.center = new Coordinate(x, y);
        this.js("map.setCenter($GeoJsonHelper.toJs($this.center));");
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
        this.js("map.setZoom($this.zoomLevel);");
    }

    public void fitTo(Geometry geom, double padding) {
        Envelope envelope = geom.getEnvelopeInternal();
        envelope.expandBy(padding);
        this.js("    const bounds = new maplibregl.LngLatBounds(\n    [%s, %s], [%s, %s]);;\n    map.fitBounds(bounds);\n".formatted(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY()));
    }

    public void flyTo(double x, double y, double zoom) {
        this.js("    map.flyTo({\n        center: [%s, %s],\n        zoom: %s\n    });\n".formatted(x, y, zoom));
    }

    protected void js(String js, Map<String, Object> variables) {
        this.velocityJs("    const map = this.map;\n    const component = this;\n    const action = () => {\n        %s\n    };\n    if(!this.styleloaded) {\n        map.on('load', action);\n    } else {\n        action();\n    }\n".formatted(js), variables);
    }

    protected void js(String js) {
        this.js(js, Collections.emptyMap());
    }

    public void flyTo(Geometry geometry, int i) {
        Point centroid = geometry.getCentroid();
        this.flyTo(centroid.getX(), centroid.getY(), i);
    }
}

