/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import com.vaadin.flow.component.AttachEvent;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.vaadin.addons.maplibre.AbstractFeatureField;
import org.vaadin.addons.maplibre.DrawControl;

public class LineStringField
extends AbstractFeatureField<LineString> {
    private LineString lineString;

    public LineStringField() {
    }

    public LineStringField(String label) {
        super(label);
    }

    @Override
    public LineStringField withStyleUrl(String styleUrl) {
        super.withStyleUrl(styleUrl);
        this.drawControl.addGeometryChangeListener(e -> {
            GeometryCollection geom = e.getGeom();
            this.lineString = (LineString)geom.getGeometryN(0);
            this.updateValue();
        });
        return this;
    }

    @Override
    public void setHeight(String height) {
        super.setHeight(height);
        this.map.setHeight("280px");
    }

    @Override
    public void setWidth(String width) {
        super.setWidth(width);
        this.map.setWidth(width);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.lineString == null) {
            this.drawControl.setMode(DrawControl.DrawMode.DRAW_LINE_STRING);
        }
    }

    protected LineString generateModelValue() {
        return this.lineString;
    }

    protected void setPresentationValue(LineString lineString) {
        this.lineString = lineString;
        if (lineString == null) {
            this.drawControl.setMode(DrawControl.DrawMode.DRAW_POLYGON);
        } else {
            this.drawControl.setGeometry((Geometry)lineString);
            this.drawControl.directSelectFirst();
            this.map.fitBounds((Geometry)lineString);
        }
    }
}

