/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.DomEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.geojson.GeoJsonWriter;
import org.parttio.vaadinjsloader.JSLoader;
import org.vaadin.addons.maplibre.AbstractKebabCasedDto;
import org.vaadin.addons.maplibre.FillPaint;
import org.vaadin.addons.maplibre.GeoJsonHelper;
import org.vaadin.addons.maplibre.Layer;
import org.vaadin.addons.maplibre.LinePaint;
import org.vaadin.addons.maplibre.Marker;
import org.vaadin.addons.velocitycomponent.AbstractVelocityJsComponent;

@Tag(value="div")
public class MapLibre
extends AbstractVelocityJsComponent
implements HasSize,
HasStyle {
    private final HashMap<String, Layer> idToLayer = new HashMap();
    private Coordinate center = new Coordinate(0.0, 0.0);
    private int zoomLevel = 0;
    private HashMap<String, Runnable> jsCallbacks = new HashMap();
    private List<MapClickListener> mapClickListeners;

    public MapLibre(URI styleUrl) {
        this.init(null, styleUrl.toString());
    }

    public MapLibre(String styleUrl) {
        this.init(null, styleUrl);
    }

    public MapLibre(InputStream styleJson) {
        try {
            this.init(IOUtils.toString((InputStream)styleJson, (Charset)Charset.defaultCharset()), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void init(String styleJson, String styleUrl) {
        this.loadMapLibreJs();
        this.setId("map");
        this.setWidth("800px");
        this.setHeight("500px");
        this.jsTemplate("org/vaadin/addons/maplibre/mapinit.js", Map.of("style", styleJson == null ? "null" : styleJson, "styleUrl", styleUrl == null ? "null" : styleUrl));
    }

    protected void loadMapLibreJs() {
        JSLoader.loadUnpkg((Component)this, (String)"maplibre-gl", (String)"latest", (String[])new String[]{"dist/maplibre-gl.js", "dist/maplibre-gl.css"});
    }

    public Integer getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
        this.js("map.setZoom($this.zoomLevel);");
    }

    public Coordinate getCenter() {
        return this.center;
    }

    public String getMapStyle() {
        try {
            String s = IOUtils.resourceToString((String)"/kiinteistojaotus-taustakartalla.json", (Charset)Charset.defaultCharset());
            return s;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addSource(String name, Geometry geometry) {
        this.js("    map.addSource('$name', {\n      'type': 'geojson',\n      'data': $GeoJsonHelper.toJs($geometry)\n    });\n", Map.of("name", name, "geometry", geometry));
    }

    public Layer addLineLayer(Geometry geometry, LinePaint linePaint) {
        String id = UUID.randomUUID().toString();
        this.addSource(id, geometry);
        return this.addLineLayer(id, id, null, linePaint, geometry);
    }

    public Layer addFillLayer(Polygon polygon, FillPaint style) {
        String id = UUID.randomUUID().toString();
        this.addSource(id, (Geometry)polygon);
        return this.addFillLayer(id, id, null, style, (Geometry)polygon);
    }

    protected Layer addFillLayer(String name, String source, String sourceLayer, FillPaint paintJson, Geometry geom) {
        sourceLayer = sourceLayer == null ? "" : "'source-layer': '%s',".formatted(sourceLayer);
        this.js("    map.addLayer({\n      'id': '%s',\n      'type': 'fill',\n      'source': '%s',\n      %s\n      'layout': {},\n      'paint': %s\n    });\n".formatted(name, source, sourceLayer, paintJson), Collections.emptyMap());
        return new Layer(this, name, geom);
    }

    protected Layer addLineLayer(String name, String source, String sourceLayer, LinePaint paint, Geometry geom) {
        sourceLayer = sourceLayer == null ? "" : "'source-layer': '%s',".formatted(sourceLayer);
        this.js("    map.addLayer({\n      'id': '$name',\n      'type': 'line',\n      'source': '$source',\n       $sourceLayer\n      'layout': {\n        'line-join': 'round',\n        'line-cap': 'round'\n      },\n      'paint': $paint\n    });\n", Map.of("name", name, "source", source, "sourceLayer", sourceLayer, "paint", paint));
        return new Layer(this, name, geom);
    }

    public void removeLayer(Layer layer) {
        if (layer instanceof Marker) {
            Marker m = (Marker)layer;
            this.js("    component.markers['$id'].remove();\n", Map.of("id", m.id));
        } else {
            this.js("    map.removeLayer('$id');\n    map.removeSource('$id');\n", Map.of("id", layer.id));
        }
        this.idToLayer.remove(layer.id);
    }

    public void addSource(String name, String sourceDeclarationJson) {
        this.js("    map.addSource('$name', $sourceDeclarationJson);\n", Map.of("name", name, "sourceDeclarationJson", sourceDeclarationJson));
    }

    public Marker addMarker(Point point) {
        return this.addMarker(point.getX(), point.getY());
    }

    public Marker addMarker(double x, double y) {
        String id = UUID.randomUUID().toString();
        this.js("    component.markers = component.markers || {};\n    component.markers['$id'] = new maplibregl.Marker()\n            .setLngLat([$x, $y])\n            .addTo(map);\n", Map.of("id", id, "x", x, "y", y));
        return new Marker(this, id, new Coordinate(x, y));
    }

    protected VelocityContext getVelocityContext() {
        VelocityContext velocityContext = super.getVelocityContext();
        velocityContext.put("GeoJsonHelper", GeoJsonHelper.class);
        return velocityContext;
    }

    public void setCenter(double x, double y) {
        this.center = new Coordinate(x, y);
        this.js("map.setCenter($GeoJsonHelper.toJs($this.center));");
    }

    public void fitTo(Geometry geom, double padding) {
        Envelope envelope = geom.getEnvelopeInternal();
        envelope.expandBy(padding);
        this.js("    const bounds = new maplibregl.LngLatBounds(\n    [%s, %s], [%s, %s]);;\n    map.fitBounds(bounds);\n".formatted(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY()));
    }

    public void flyTo(double x, double y, double zoom) {
        this.js("    map.flyTo({\n        center: [%s, %s],\n        zoom: %s\n    });\n".formatted(x, y, zoom));
    }

    protected PendingJavaScriptResult js(String js, Map<String, Object> variables) {
        return this.velocityJs("    const map = this.map;\n    const component = this;\n    const action = () => {\n        %s\n    };\n    if(!this.styleloaded) {\n        map.on('load', action);\n    } else {\n        return action();\n    }\n".formatted(js), variables);
    }

    protected void js(String js) {
        this.js(js, Collections.emptyMap());
    }

    public void flyTo(Geometry geometry, int i) {
        Point centroid = geometry.getCentroid();
        this.flyTo(centroid.getX(), centroid.getY(), i);
    }

    String registerJsCallback(Runnable r) {
        String id = UUID.randomUUID().toString();
        this.jsCallbacks.put(id, r);
        return id;
    }

    void deregisterJsCallback(String id) {
        this.jsCallbacks.remove(id);
    }

    @ClientCallable
    private void jsCallback(String cbId) {
        this.jsCallbacks.get(cbId).run();
    }

    void registerLayer(String id, Layer layer) {
        this.idToLayer.put(id, layer);
    }

    public void addMapClickListener(MapClickListener listener) {
        if (this.mapClickListeners == null) {
            this.mapClickListeners = new ArrayList<MapClickListener>();
            this.js("map.on(\"click\", e => {\n    var evt = new Event(\"map-click\");\n    const features = map.queryRenderedFeatures(e.point)\n    if(features[0]) {\n        evt.featureId = features[0].layer.id;\n    }\n    evt.lngLat = JSON.stringify(e.lngLat);\n    evt.point = JSON.stringify(e.point);\n    component.dispatchEvent(evt);\n});\n\n");
            this.getElement().addEventListener("map-click", (DomEventListener & Serializable)domEvent -> {
                MapClickEvent mapClickEvent = new MapClickEvent(domEvent);
                for (MapClickListener l : this.mapClickListeners) {
                    l.onClick(mapClickEvent);
                }
            }).addEventData("event.lngLat").addEventData("event.point").addEventData("event.featureId");
        }
        this.mapClickListeners.add(listener);
    }

    @ClientCallable
    private void _fireClick() {
    }

    public void fitBounds(Geometry geometry) {
        String geojson = new GeoJsonWriter().write(geometry.getEnvelope().getBoundary());
        this.js("const bbox = JSON.parse('$bbox');\nconst b = new maplibregl.LngLatBounds(bbox.coordinates[0],bbox.coordinates[1]);\nbbox.coordinates.forEach(c => {\n    b.extend([c[0],c[1]]);\n});\nmap.fitBounds(b, {padding: 20});\n", Map.of("bbox", geojson));
    }

    public class MapClickEvent {
        private final Layer layer;
        private final Coordinate point;
        private final Coordinate pixelCoordinate;

        public MapClickEvent(DomEvent domEvent) {
            String fId = domEvent.getEventData().getString("event.featureId");
            this.layer = MapLibre.this.idToLayer.get(fId);
            try {
                LngLatRecord ll = (LngLatRecord)AbstractKebabCasedDto.mapper.readValue(domEvent.getEventData().getString("event.lngLat"), LngLatRecord.class);
                PointRecord p = (PointRecord)AbstractKebabCasedDto.mapper.readValue(domEvent.getEventData().getString("event.point"), PointRecord.class);
                this.point = new Coordinate(ll.lng, ll.lat);
                this.pixelCoordinate = new Coordinate(p.x, p.y);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public Coordinate getPoint() {
            return this.point;
        }

        public Layer getLayer() {
            return this.layer;
        }

        record LngLatRecord(double lng, double lat) {
        }

        record PointRecord(double x, double y) {
        }
    }

    public static interface MapClickListener {
        public void onClick(MapClickEvent var1);
    }
}

