/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import com.vaadin.flow.dom.DomEventListener;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.vaadin.addons.maplibre.Layer;
import org.vaadin.addons.maplibre.MapLibre;

public class Marker
extends Layer {
    private List<String> listeners;

    Marker(MapLibre map, String id, Coordinate coordinate) {
        super(map, id, (Geometry)new GeometryFactory().createPoint(coordinate));
    }

    public void withPopup(String html) {
        this.map.js("    const marker = component.markers['$id'];\n    const popup = new maplibregl.Popup({closeButton: true, closeOnClick: true})\n        .setLngLat(marker.getLngLat())\n        .setHTML('$html');\n    marker.setPopup(popup);\n", Map.of("id", this.id, "html", html));
    }

    public void setPoint(Point point) {
        this.map.js("    const marker = component.markers['$id'];\n    marker.setLngLat(new maplibregl.LngLat($x, $y));\n", Map.of("id", this.id, "x", point.getX(), "y", point.getY()));
    }

    public Marker addDragEndListener(DragEndListener listener) {
        this.map.js("    const marker = component.markers['$id'];\n    marker.on('dragend', e => {\n        const lngLat = marker.getLngLat();\n        const evt = new Event(\"de-$id\");\n        evt.lat = lngLat.lat;\n        evt.lng = lngLat.lng;\n        component.dispatchEvent(evt);\n    });\n    marker.setDraggable(true);\n", Map.of("id", this.id));
        this.map.getElement().addEventListener("de-" + this.id, (DomEventListener & Serializable)e -> {
            double lat = e.getEventData().getNumber("event.lat");
            double lng = e.getEventData().getNumber("event.lng");
            Coordinate coordinate = new Coordinate(lng, lat);
            listener.dragEnd(coordinate);
        }).addEventData("event.lat").addEventData("event.lng");
        return this;
    }

    public void addClickListener(ClickListener l) {
        String cbId = this.map.registerJsCallback(() -> l.onClick());
        this.map.js("    const marker = component.markers['$id'];\n    const cbId = '$cbId';\n    marker.getElement().addEventListener(\"click\", e => {\n        component.$server.jsCallback(cbId);\n    });\n", Map.of("id", this.id, "cbId", cbId));
        if (this.listeners == null) {
            this.listeners = new LinkedList<String>();
        }
        this.listeners.add(cbId);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.listeners != null) {
            this.listeners.forEach(this.map::deregisterJsCallback);
        }
    }

    public static interface DragEndListener {
        public void dragEnd(Coordinate var1);
    }

    public static interface ClickListener {
        public void onClick();
    }
}

