/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.customfield.CustomField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.vaadin.addons.maplibre.MapLibre;
import org.vaadin.addons.maplibre.Marker;

public class PointField
extends CustomField<Point>
implements Marker.DragEndListener {
    MapLibre map;
    private Point point;
    private Marker marker;

    public PointField(String label) {
        this.setLabel(label);
    }

    public PointField() {
    }

    public void setHeight(String height) {
        super.setHeight(height);
        this.map.setHeight("280px");
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this.map.setWidth(width);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
    }

    protected Point generateModelValue() {
        return this.point;
    }

    protected void setPresentationValue(Point point) {
        this.point = point;
        if (point != null) {
            if (this.marker == null) {
                this.marker = this.map.addMarker(point).addDragEndListener(this);
            } else {
                this.marker.setPoint(point);
            }
            this.map.setCenter(point.getX(), point.getY());
        }
    }

    public PointField withStyleUrl(String styleUrl) {
        this.map = new MapLibre(styleUrl);
        this.map.addMapClickListener(event -> {
            Coordinate coordinate = event.getPoint();
            this.assingPointFromCoordinate(coordinate);
            if (this.marker == null) {
                this.marker = this.map.addMarker(this.point).addDragEndListener(this);
            } else {
                this.marker.setPoint(this.point);
            }
            this.updateValue();
        });
        this.add(new Component[]{this.map});
        return this;
    }

    private void assingPointFromCoordinate(Coordinate coordinate) {
        this.point = new GeometryFactory().createPoint(coordinate);
    }

    @Override
    public void dragEnd(Coordinate coordinate) {
        this.assingPointFromCoordinate(coordinate);
        this.updateValue();
    }
}

