/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import com.vaadin.flow.component.AttachEvent;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;
import org.vaadin.addons.maplibre.AbstractFeatureField;
import org.vaadin.addons.maplibre.DrawControl;

public class PolygonField
extends AbstractFeatureField<Polygon> {
    private Polygon polygon;

    public PolygonField() {
    }

    public PolygonField(String label) {
        this.setLabel(label);
    }

    @Override
    public PolygonField withStyleUrl(String styleUrl) {
        super.withStyleUrl(styleUrl);
        this.drawControl.addGeometryChangeListener(e -> {
            GeometryCollection geom = e.getGeom();
            this.polygon = (Polygon)geom.getGeometryN(0);
            this.updateValue();
        });
        return this;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.polygon == null) {
            this.drawControl.setMode(DrawControl.DrawMode.DRAW_POLYGON);
        }
    }

    protected Polygon generateModelValue() {
        return this.polygon;
    }

    protected void setPresentationValue(Polygon polygon) {
        this.polygon = polygon;
        if (polygon == null) {
            this.drawControl.setMode(DrawControl.DrawMode.DRAW_POLYGON);
        } else {
            this.drawControl.setGeometry((Geometry)polygon);
            this.drawControl.setMode(DrawControl.DrawMode.SIMPLE_SELECT);
            this.drawControl.directSelectFirst();
            this.map.fitBounds((Geometry)polygon);
        }
    }
}

