/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.io.Serializable;
import org.vaadin.addons.maplibre.DrawControl;
import org.vaadin.addons.maplibre.MapLibre;

@StyleSheet(value="context://org/vaadin/addons/maplibre/maplibre-addon.css")
public abstract class AbstractFeatureField<T>
extends CustomField<T> {
    protected Runnable deferredTask;
    private DrawControl drawControl;
    private MapLibre map;
    private HorizontalLayout toolbar = new HorizontalLayout();
    private Button resetButton = new Button((Component)VaadinIcon.TRASH.create(), (ComponentEventListener & Serializable)e -> this.reset());
    private String stylesJson;

    protected void reset() {
        if (this.drawControl != null) {
            this.drawControl.clear();
        }
        this.getResetButton().setVisible(false);
    }

    public AbstractFeatureField() {
        this.toolbar.setSpacing(false);
        this.toolbar.add(new Component[]{this.resetButton});
        this.resetButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.resetButton.setTooltipText("Reset current geometry");
        this.resetButton.setVisible(false);
    }

    public AbstractFeatureField(String label) {
        this();
        this.setLabel(label);
    }

    public AbstractFeatureField initWithBaseLayer(String styleUrl) {
        this.setMap(new MapLibre(styleUrl));
        return this;
    }

    public MapLibre getMap() {
        if (this.map == null) {
            this.setMap(new MapLibre());
        }
        return this.map;
    }

    protected void setMap(MapLibre map) {
        this.toolbar.setPadding(false);
        this.toolbar.setClassName("maplibre-toolbar");
        this.add(new Component[]{this.toolbar});
        this.map = map;
        this.add(new Component[]{map});
        this.drawControl = null;
    }

    protected HorizontalLayout getToolbar() {
        return this.toolbar;
    }

    protected Button getResetButton() {
        return this.resetButton;
    }

    public DrawControl getDrawControl() {
        if (this.drawControl == null) {
            this.drawControl = new DrawControl(this.getMap(), this.stylesJson);
        }
        return this.drawControl;
    }

    public void setHeight(String height) {
        super.setHeight(height);
        this.addClassName("maplibre-field-has-size");
        this.getMap().setHeightFull();
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this.getMap().setWidth(width);
    }

    protected void runAttached(Runnable task) {
        if (!this.isAttached()) {
            this.deferredTask = task;
        } else {
            task.run();
        }
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.getWidth() == null) {
            this.setMinWidth("100px");
            this.setWidthFull();
        }
        if (attachEvent.isInitialAttach() && this.getValue() == null) {
            this.setPresentationValue(null);
        }
        super.onAttach(attachEvent);
        if (this.deferredTask != null) {
            this.deferredTask.run();
            this.deferredTask = null;
        }
    }

    public void setStylesJson(String stylesJson) {
        this.stylesJson = stylesJson;
    }
}

