/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.geojson.GeoJsonReader;
import org.locationtech.jts.io.geojson.GeoJsonWriter;
import org.parttio.vaadinjsloader.JSLoader;
import org.vaadin.addons.maplibre.MapLibre;

public class DrawControl {
    private final MapLibre map;
    private final String id = "draw" + UUID.randomUUID().toString().substring(0, 4);
    private String stylesJson = "null";
    private List<DrawEventListener<ModeChangeEvent>> modeChangeListeners;
    private DrawMode mode = DrawMode.SIMPLE_SELECT;
    private ArrayList<DrawEventListener<GeometryChangeEvent>> changeListeners;

    public DrawControl(MapLibre map) {
        this(map, null);
    }

    public DrawControl(MapLibre map, String stylesJson) {
        this.map = map;
        this.stylesJson = stylesJson;
        this.injectScript();
        if (map.isAttached()) {
            this.doInit();
        } else {
            map.addAttachListener((ComponentEventListener & Serializable)e -> this.doInit());
        }
    }

    public void addModeChangeListener(DrawEventListener<ModeChangeEvent> listener) {
        if (this.modeChangeListeners == null) {
            this.modeChangeListeners = new ArrayList<DrawEventListener<ModeChangeEvent>>();
            this.map.getElement().addEventListener("modechange", (DomEventListener & Serializable)e -> {
                ModeChangeEvent event = new ModeChangeEvent(DrawMode.valueOf(e.getEventData().getString("event.mode").toUpperCase()));
                this.modeChangeListeners.forEach(l -> l.onEvent(event));
            }).addEventData("event.mode");
        }
        this.modeChangeListeners.add(listener);
    }

    public void addGeometryChangeListener(DrawEventListener<GeometryChangeEvent> listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
            this.map.getElement().addEventListener("change", (DomEventListener & Serializable)e -> {
                String geojson = e.getEventData().getString("event.geom");
                try {
                    GeometryCollection geom = (GeometryCollection)new GeoJsonReader().read(geojson);
                    GeometryChangeEvent event = new GeometryChangeEvent(geom);
                    this.changeListeners.forEach((Consumer<DrawEventListener<GeometryChangeEvent>>)((Consumer<DrawEventListener>)l -> l.onEvent(event)));
                }
                catch (ParseException ex) {
                    throw new RuntimeException(ex);
                }
            }).addEventData("event.geom");
        }
        this.changeListeners.add(listener);
    }

    private void doInit() {
        this.map.js("const drawOptions = {\n    defaultMode : \"%s\",\n    displayControlsDefault: false\n};\nconst styles = %s;\nif(styles != null) {\n    drawOptions.styles = styles;\n}\n\nconst id = \"%s\";\nconst draw = new MapboxDraw(drawOptions);\nmap[id] = draw;\nmap.addControl(draw);\n\nmap.on(\"draw.modechange\", e => {\n\n    // TODO figure out a proper way for cursors\n    if(e.mode == \"direct_select\") {\n        map._canvasContainer.style.cursor = \"default\";\n    } else {\n        map._canvasContainer.style.cursor = \"\";\n    }\n\n    const evt = new Event(\"modechange\");\n    evt.mode = e.mode;\n    component.dispatchEvent(evt);\n});\n\nmap.on(\"draw.create\", e => {\n    const evt = new Event(\"change\");\n    evt.geom = JSON.stringify(draw.getAll());\n    component.dispatchEvent(evt);\n});\nmap.on(\"draw.update\", e => {\n    const evt = new Event(\"change\");\n    evt.geom = JSON.stringify(draw.getAll());\n    component.dispatchEvent(evt);\n});\n\n\n".formatted(this.mode.toString().toLowerCase(), this.stylesJson, this.id));
    }

    public void setMode(DrawMode mode) {
        this.mode = mode;
        if (this.map.isAttached()) {
            this.js("const mode = \"$mode\";\ndraw.changeMode(mode);\nif(mode.indexOf(\"draw\") != -1 ) {\n    map._canvasContainer.style.cursor = \"default\";\n}\n", Map.of("mode", mode.toString().toLowerCase()));
        } else {
            this.js("if($mode.indexOf(\"draw\") != -1 ) {\n    map._canvasContainer.style.cursor = \"default\";\n}\n", Map.of("mode", mode.toString().toLowerCase()));
        }
    }

    protected void injectScript() {
        JSLoader.loadFiles((Component)this.map, (String)"https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-draw/v1.4.3/mapbox-gl-draw.js", (String)"mapbox-gl-draw", (String)"v1.4.3", (String[])new String[0]);
    }

    private PendingJavaScriptResult js(String js, Map args) {
        js = "const draw = map['%s'];\n".formatted(this.id) + (String)js;
        return this.map.js((String)js, args);
    }

    public CompletableFuture<GeometryCollection> getAll() {
        CompletableFuture<GeometryCollection> v = new CompletableFuture<GeometryCollection>();
        this.js("const all = draw.getAll();\nreturn JSON.stringify(all);\n", Collections.emptyMap()).then(String.class, (SerializableConsumer & Serializable)str -> {
            try {
                GeometryCollection geom = (GeometryCollection)new GeoJsonReader().read(str);
                v.complete(geom);
            }
            catch (ParseException e) {
                v.completeExceptionally(e);
            }
        });
        return v;
    }

    public void clear() {
        this.js("draw.deleteAll()", Collections.emptyMap());
    }

    public void setGeometry(Geometry geometry) {
        String geojsonstr = new GeoJsonWriter().write(geometry);
        this.js("    const geojson = JSON.parse('$geojsonstr');\n    draw.deleteAll();\n    if(geojson.type == \"GeometryCollection\") {\n       geojson.geometries.forEach(g => draw.add(g));\n    } else {\n        draw.add(geojson);\n    }\n", Map.of("geojsonstr", geojsonstr));
    }

    public void directSelectFirst() {
        this.js("    const id = draw.getAll().features[0].id;\n    draw.changeMode(\"direct_select\", {\n        featureId : id\n    });\n", Collections.emptyMap());
    }

    public void removeGeometryChangeListener(DrawEventListener<GeometryChangeEvent> l) {
        this.changeListeners.remove(l);
    }

    public static enum DrawMode {
        SIMPLE_SELECT,
        DIRECT_SELECT,
        DRAW_LINE_STRING,
        DRAW_POLYGON,
        DRAW_POINT;

    }

    public class GeometryChangeEvent
    extends EventObject {
        private final GeometryCollection geom;

        public GeometryChangeEvent(GeometryCollection geom) {
            super(DrawControl.this);
            this.geom = geom;
        }

        public GeometryCollection getGeom() {
            return this.geom;
        }
    }

    @FunctionalInterface
    public static interface DrawEventListener<T extends EventObject> {
        public void onEvent(T var1);
    }

    public class ModeChangeEvent
    extends EventObject {
        private final DrawMode drawMode;

        public ModeChangeEvent(DrawMode drawMode) {
            super(DrawControl.this);
            this.drawMode = drawMode;
        }

        public DrawMode getDrawMode() {
            return this.drawMode;
        }
    }
}

