/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.vaadin.addons.maplibre.AbstractFeatureField;
import org.vaadin.addons.maplibre.DrawControl;
import org.vaadin.addons.maplibre.MapLibre;

public class LineStringField
extends AbstractFeatureField<LineString> {
    private LineString lineString;

    public LineStringField() {
    }

    public LineStringField(String label) {
        super(label);
    }

    @Override
    protected void setMap(MapLibre map) {
        super.setMap(map);
        this.getDrawControl().addGeometryChangeListener(e -> {
            GeometryCollection geom = e.getGeom();
            this.lineString = (LineString)geom.getGeometryN(0);
            this.updateValue();
            this.getResetButton().setVisible(true);
        });
        this.getDrawControl().addModeChangeListener(e -> {
            if (this.lineString == null && e.getDrawMode() != DrawControl.DrawMode.DRAW_LINE_STRING) {
                this.getDrawControl().setMode(DrawControl.DrawMode.DRAW_LINE_STRING);
            }
        });
    }

    @Override
    protected void reset() {
        super.reset();
        this.lineString = null;
        this.getDrawControl().setMode(DrawControl.DrawMode.DRAW_LINE_STRING);
        this.updateValue();
    }

    protected LineString generateModelValue() {
        return this.lineString;
    }

    protected void setPresentationValue(LineString lineString) {
        this.lineString = lineString;
        this.getResetButton().setVisible(lineString != null);
        this.runAttached(() -> {
            if (lineString == null) {
                this.getDrawControl().setMode(DrawControl.DrawMode.DRAW_LINE_STRING);
            } else {
                this.getDrawControl().setGeometry((Geometry)lineString);
                this.getDrawControl().directSelectFirst();
                this.getMap().fitBounds((Geometry)lineString);
            }
        });
    }
}

