/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import elemental.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.geojson.GeoJsonWriter;
import org.parttio.vaadinjsloader.JSLoader;
import org.vaadin.addons.maplibre.AbstractKebabCasedDto;
import org.vaadin.addons.maplibre.FillPaint;
import org.vaadin.addons.maplibre.GeoJsonHelper;
import org.vaadin.addons.maplibre.Layer;
import org.vaadin.addons.maplibre.LineLayer;
import org.vaadin.addons.maplibre.LinePaint;
import org.vaadin.addons.maplibre.MapLibreBaseMapProvider;
import org.vaadin.addons.maplibre.Marker;
import org.vaadin.addons.velocitycomponent.AbstractVelocityJsComponent;

@Tag(value="div")
public class MapLibre
extends AbstractVelocityJsComponent
implements HasSize,
HasStyle {
    static GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
    private final HashMap<String, Layer> idToLayer = new HashMap();
    private String styleJson;
    private String styleUrl;
    private ArrayList<MoveEndListener> moveEndListeners;
    private Coordinate center;
    private Double zoomLevel;
    private HashMap<String, Runnable> jsCallbacks = new HashMap();
    private List<MapClickListener> mapClickListeners;
    private boolean initialized;
    private boolean detached;
    private LinkedList<Runnable> deferredJsCalls = new LinkedList();

    public MapLibre() {
        VaadinContext context = VaadinService.getCurrent().getContext();
        MapLibreBaseMapProvider provider = (MapLibreBaseMapProvider)context.getAttribute(MapLibreBaseMapProvider.class);
        if (provider == null) {
            this.styleUrl = "https://demotiles.maplibre.org/style.json";
            return;
        }
        Object o = provider.provideBaseStyle();
        if (o instanceof String) {
            String url;
            this.styleUrl = url = (String)o;
        } else if (o instanceof InputStream) {
            InputStream styleJson = (InputStream)o;
            try {
                this.styleJson = IOUtils.toString((InputStream)styleJson, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (o instanceof URI) {
            URI uri = (URI)o;
            this.styleUrl = uri.toString();
        }
    }

    public MapLibre(URI styleUrl) {
        this.styleUrl = styleUrl.toString();
    }

    public MapLibre(String styleUrl) {
        this.styleUrl = styleUrl;
    }

    public MapLibre(InputStream styleJson) {
        try {
            this.styleJson = IOUtils.toString((InputStream)styleJson, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void init() {
        if (!this.initialized) {
            if (this.getWidth() == null && this.getMinWidth() == null) {
                this.setWidth("100%");
                this.setMinWidth("100px");
            }
            if (this.getHeight() == null && this.getMinHeight() == null) {
                this.setHeight("100%");
                this.setMinHeight("100px");
            }
            this.loadMapLibreJs();
            this.jsTemplate("org/vaadin/addons/maplibre/mapinit.js", Map.of("style", this.styleJson == null ? "null" : this.styleJson, "styleUrl", this.styleUrl == null ? "null" : this.styleUrl, "setCenter", this.center != null, "setZoom", this.zoomLevel != null));
            this.initialized = true;
        }
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.init();
        if (this.detached) {
            throw new IllegalStateException("Re-attaching old map not currently supported!");
        }
        super.onAttach(attachEvent);
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.detached = true;
    }

    protected void loadMapLibreJs() {
        JSLoader.loadUnpkg((Component)this, (String)"maplibre-gl", (String)"4.1.2", (String[])new String[]{"dist/maplibre-gl.js", "dist/maplibre-gl.css"});
    }

    public Double getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(double zoomLevel) {
        this.zoomLevel = zoomLevel;
        if (this.initialized) {
            this.js("map.setZoom($this.zoomLevel);");
        }
    }

    @Deprecated
    public Coordinate getCenter() {
        return this.center;
    }

    public void setCenter(Coordinate coordinate) {
        this.center = coordinate;
        if (this.initialized) {
            this.js("map.setCenter($GeoJsonHelper.toJs($this.center));");
        }
    }

    public void setCenter(Geometry geom) {
        this.setCenter(geom.getCentroid().getCoordinate());
    }

    private void addSource(String name, Geometry geometry) {
        this.js("    map.addSource('$name', {\n      'type': 'geojson',\n      'data': $GeoJsonHelper.toJs($geometry)\n    });\n", Map.of("name", name, "geometry", geometry));
    }

    public LineLayer addLineLayer(LineString geometry, LinePaint linePaint) {
        String id = UUID.randomUUID().toString();
        this.addSource(id, (Geometry)geometry);
        return this.addLineLayer(id, id, null, linePaint, (Geometry)geometry);
    }

    public Layer addFillLayer(Polygon polygon, FillPaint style) {
        String id = UUID.randomUUID().toString();
        this.addSource(id, (Geometry)polygon);
        return this.addFillLayer(id, id, null, style, (Geometry)polygon);
    }

    public Layer addFillLayer(Geometry geom, FillPaint style) {
        String id = UUID.randomUUID().toString();
        this.addSource(id, geom);
        return this.addFillLayer(id, id, null, style, geom);
    }

    protected Layer addFillLayer(String name, String source, String sourceLayer, FillPaint paintJson, Geometry geom) {
        sourceLayer = sourceLayer == null ? "" : "'source-layer': '%s',".formatted(sourceLayer);
        this.js("    map.addLayer({\n      'id': '%s',\n      'type': 'fill',\n      'source': '%s',\n      %s\n      'layout': {},\n      'paint': %s\n    });\n".formatted(name, source, sourceLayer, paintJson), Collections.emptyMap());
        return new Layer(this, name, geom);
    }

    public LineLayer addLineLayer(String name, String source, String sourceLayer, LinePaint paint) {
        return this.addLineLayer(name, source, sourceLayer, paint, null);
    }

    protected LineLayer addLineLayer(String name, String source, String sourceLayer, LinePaint paint, Geometry geom) {
        sourceLayer = sourceLayer == null ? "" : "'source-layer': '%s',".formatted(sourceLayer);
        this.js("    map.addLayer({\n      'id': '$name',\n      'type': 'line',\n      'source': '$source',\n       $sourceLayer\n      'layout': {\n        'line-join': 'round',\n        'line-cap': 'round'\n      },\n      'paint': $paint\n    });\n", Map.of("name", name, "source", source, "sourceLayer", sourceLayer, "paint", paint));
        return new LineLayer(this, name, geom);
    }

    public void removeLayer(Layer layer) {
        if (layer instanceof Marker) {
            Marker m = (Marker)layer;
            this.js("    component.markers['$id'].remove();\n", Map.of("id", m.id));
        } else {
            this.js("    map.removeLayer('$id');\n    map.removeSource('$id');\n", Map.of("id", layer.id));
        }
        this.idToLayer.remove(layer.id);
    }

    public void addSource(String name, String sourceDeclarationJson) {
        this.js("    map.addSource('$name', $sourceDeclarationJson);\n", Map.of("name", name, "sourceDeclarationJson", sourceDeclarationJson));
    }

    public Marker addMarker(Point point) {
        return this.addMarker(point.getX(), point.getY());
    }

    public Marker addMarker(double x, double y) {
        String id = UUID.randomUUID().toString();
        this.js("    component.markers = component.markers || {};\n    component.markers['$id'] = new maplibregl.Marker()\n            .setLngLat([$x, $y])\n            .addTo(map);\n", Map.of("id", id, "x", x, "y", y));
        return new Marker(this, id, new Coordinate(x, y));
    }

    protected VelocityContext getVelocityContext() {
        VelocityContext velocityContext = super.getVelocityContext();
        velocityContext.put("GeoJsonHelper", GeoJsonHelper.class);
        return velocityContext;
    }

    public void setCenter(double x, double y) {
        this.setCenter(new Coordinate(x, y));
    }

    public void fitTo(Geometry geom, double padding) {
        Envelope envelope = geom.getEnvelopeInternal();
        this.fitTo(envelope, padding);
    }

    protected void fitTo(Envelope envelope, double padding) {
        this.fitTo("    const bounds = new maplibregl.LngLatBounds(\n    [%s, %s], [%s, %s]);;\n    map.fitBounds(bounds, {padding: %s});\n".formatted(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), padding));
    }

    private void fitTo(String envelope) {
        this.js(envelope);
    }

    public void flyTo(double x, double y, Double zoom) {
        this.js("    const opts = {\n        center: [%s, %s]\n    }\n    const z = %s;\n    if(z != null) {\n        opts.zoom = z;\n    }\n    map.flyTo(opts);\n".formatted(x, y, zoom));
    }

    protected PendingJavaScriptResult js(String js, Map<String, Object> variables) {
        this.init();
        return this.velocityJs("    const map = this.map;\n    const component = this;\n    const action = () => {\n        %s\n    };\n    if(!this.styleloaded) {\n        map.on('load', action);\n    } else {\n        return action();\n    }\n".formatted(js), variables);
    }

    protected PendingJavaScriptResult js(String js) {
        return this.js(js, Collections.emptyMap());
    }

    public void flyTo(Geometry geometry, double zoomLevel) {
        Point centroid = geometry.getCentroid();
        this.flyTo(centroid.getX(), centroid.getY(), zoomLevel);
    }

    public void flyTo(Geometry geometry) {
        Point centroid = geometry.getCentroid();
        this.flyTo(centroid.getX(), centroid.getY(), null);
    }

    String registerJsCallback(Runnable r) {
        String id = UUID.randomUUID().toString();
        this.jsCallbacks.put(id, r);
        return id;
    }

    void deregisterJsCallback(String id) {
        this.jsCallbacks.remove(id);
    }

    @ClientCallable
    private void jsCallback(String cbId) {
        this.jsCallbacks.get(cbId).run();
    }

    void registerLayer(String id, Layer layer) {
        this.idToLayer.put(id, layer);
    }

    public void addMapClickListener(MapClickListener listener) {
        if (this.mapClickListeners == null) {
            this.mapClickListeners = new ArrayList<MapClickListener>();
            this.js("map.on(\"click\", e => {\n    var evt = new Event(\"map-click\");\n    const features = map.queryRenderedFeatures(e.point)\n    if(features[0]) {\n        evt.featureId = features[0].layer.id;\n    }\n    evt.lngLat = JSON.stringify(e.lngLat);\n    evt.point = JSON.stringify(e.point);\n    component.dispatchEvent(evt);\n});\n\n");
            this.getElement().addEventListener("map-click", (DomEventListener & Serializable)domEvent -> {
                MapClickEvent mapClickEvent = new MapClickEvent(domEvent);
                for (MapClickListener l : this.mapClickListeners) {
                    l.onClick(mapClickEvent);
                }
            }).addEventData("event.lngLat").addEventData("event.point").addEventData("event.featureId");
        }
        this.mapClickListeners.add(listener);
    }

    public void fitBounds(Geometry geometry) {
        String geojson = new GeoJsonWriter().write(geometry.getEnvelope().getBoundary());
        this.js("const bbox = JSON.parse('$bbox');\nconst b = new maplibregl.LngLatBounds(bbox.coordinates[0],bbox.coordinates[1]);\nbbox.coordinates.forEach(c => {\n    b.extend([c[0],c[1]]);\n});\nmap.fitBounds(b, {padding: 20});\n", Map.of("bbox", geojson));
    }

    public void addMoveEndListener(MoveEndListener listener) {
        if (this.moveEndListeners == null) {
            this.moveEndListeners = new ArrayList();
            this.js("map.on(\"moveend\", e => {\n    var evt = new Event(\"map-moveend\");\n    evt.viewport = component.getViewPort();\n    evt.zoom = map.getZoom();\n    component.dispatchEvent(evt);\n});\n");
            this.getElement().addEventListener("map-moveend", (DomEventListener & Serializable)domEvent -> {
                MoveEndEvent event = new MoveEndEvent(domEvent);
                for (MoveEndListener l : this.moveEndListeners) {
                    l.onMove(event);
                }
            }).addEventData("event.viewport").addEventData("event.zoom").debounce(150);
        }
        this.moveEndListeners.add(listener);
    }

    public CompletableFuture<ViewPort> getViewPort() {
        CompletableFuture<ViewPort> res = new CompletableFuture<ViewPort>();
        this.getElement().callJsFunction("getViewPort", new Serializable[0]).then(JsonObject.class, (SerializableConsumer & Serializable)jso -> res.complete(ViewPort.of(jso)));
        return res;
    }

    public void fitToContent() {
        ArrayList geometries = new ArrayList();
        this.idToLayer.values().forEach(layer -> geometries.add(layer.getGeometry()));
        if (geometries.size() > 0) {
            Envelope env = ((Geometry)geometries.get(0)).getEnvelopeInternal();
            for (Geometry g : geometries) {
                if (g == null) continue;
                env.expandToInclude(g.getEnvelopeInternal());
            }
            this.fitTo(env, 20.0);
        }
    }

    public void removeAll() {
        ArrayList<Layer> layers = new ArrayList<Layer>(this.idToLayer.values());
        layers.forEach(l -> this.removeLayer((Layer)l));
    }

    public void setStyle(String styleUrl) {
        this.removeAll();
        this.js("map.setStyle(\"$style\");\n", Map.of("style", styleUrl));
    }

    public record ViewPort(Point southWest, Point northEast, Point center, double bearing, double pitch) {
        public static ViewPort of(JsonObject o) {
            Point southWest = gf.createPoint(new Coordinate(o.getObject("sw").getNumber("lng"), o.getObject("sw").getNumber("lat")));
            double nelat = o.getObject("ne").getNumber("lat");
            double nelng = o.getObject("ne").getNumber("lng");
            Point northEast = gf.createPoint(new Coordinate(nelng, nelat));
            double clat = o.getObject("c").getNumber("lat");
            double clng = o.getObject("c").getNumber("lng");
            return new ViewPort(southWest, northEast, gf.createPoint(new Coordinate(clng, clat)), o.getNumber("bearing"), o.getNumber("pitch"));
        }

        public Polygon getBounds() {
            Coordinate[] shell = new Coordinate[5];
            shell[0] = this.southWest.getCoordinate();
            shell[4] = this.southWest.getCoordinate();
            shell[2] = this.northEast.getCoordinate();
            shell[1] = new Coordinate(this.southWest.getX(), this.northEast.getY());
            shell[3] = new Coordinate(this.northEast.getX(), this.southWest.getY());
            return gf.createPolygon(shell);
        }
    }

    public class MoveEndEvent {
        ViewPort viewPort;
        double zoomLevel;

        public MoveEndEvent(DomEvent domEvent) {
            this.viewPort = ViewPort.of(domEvent.getEventData().getObject("event.viewport"));
            this.zoomLevel = domEvent.getEventData().getNumber("event.zoom");
            MapLibre.this.zoomLevel = this.zoomLevel;
        }

        public ViewPort getViewPort() {
            return this.viewPort;
        }

        public double getZoomLevel() {
            return this.zoomLevel;
        }

        public String toString() {
            return "MoveEndEvent{viewPort=" + this.viewPort + "}";
        }
    }

    public static interface MoveEndListener {
        public void onMove(MoveEndEvent var1);
    }

    public class MapClickEvent {
        private final Coordinate coordinate;
        private final Coordinate pixelCoordinate;
        private Layer layer;

        public MapClickEvent(DomEvent domEvent) {
            if (domEvent.getEventData().hasKey("event.featureId")) {
                String fId = domEvent.getEventData().getString("event.featureId");
                this.layer = MapLibre.this.idToLayer.get(fId);
            }
            try {
                LngLatRecord ll = (LngLatRecord)AbstractKebabCasedDto.mapper.readValue(domEvent.getEventData().getString("event.lngLat"), LngLatRecord.class);
                PointRecord p = (PointRecord)AbstractKebabCasedDto.mapper.readValue(domEvent.getEventData().getString("event.point"), PointRecord.class);
                this.coordinate = new Coordinate(ll.lng, ll.lat);
                this.pixelCoordinate = new Coordinate(p.x, p.y);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public Coordinate getCoordinate() {
            return this.coordinate;
        }

        public Point getPoint() {
            return gf.createPoint(this.coordinate);
        }

        public Layer getLayer() {
            return this.layer;
        }

        record LngLatRecord(double lng, double lat) {
        }

        record PointRecord(double x, double y) {
        }
    }

    public static interface MapClickListener {
        public void onClick(MapClickEvent var1);
    }
}

