/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.vaadin.addons.maplibre.AbstractFeatureField;
import org.vaadin.addons.maplibre.MapLibre;
import org.vaadin.addons.maplibre.Marker;

public class PointField
extends AbstractFeatureField<Point>
implements Marker.DragEndListener {
    private Point point;
    private Marker marker;

    public PointField(String label) {
        this();
        this.setLabel(label);
    }

    public PointField() {
    }

    @Override
    protected void reset() {
        super.reset();
        this.point = null;
        this.updateValue();
        this.marker.remove();
        this.marker = null;
    }

    protected Point generateModelValue() {
        return this.point;
    }

    protected void setPresentationValue(Point point) {
        this.point = point;
        this.getResetButton().setVisible(point != null);
        if (point == null) {
            if (this.marker != null) {
                this.marker.remove();
                this.marker = null;
            }
        } else {
            if (this.marker == null) {
                this.marker = this.getMap().addMarker(point).addDragEndListener(this);
            } else {
                this.marker.setPoint(point);
            }
            this.getMap().setCenter(point.getX(), point.getY());
        }
    }

    @Override
    protected void setMap(MapLibre map) {
        super.setMap(map);
        this.getMap().addMapClickListener(event -> {
            Coordinate coordinate = event.getCoordinate();
            this.assignPointFromCoordinate(coordinate);
            if (this.marker == null) {
                this.marker = this.getMap().addMarker(this.point).addDragEndListener(this);
            } else {
                this.marker.setPoint(this.point);
            }
            this.getResetButton().setVisible(true);
            this.updateValue();
        });
    }

    private void assignPointFromCoordinate(Coordinate coordinate) {
        this.point = MapLibre.gf.createPoint(coordinate);
    }

    @Override
    public void dragEnd(Coordinate coordinate) {
        this.assignPointFromCoordinate(coordinate);
        this.updateValue();
    }
}

