/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.maplibre;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.io.Serializable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;
import org.vaadin.addons.maplibre.AbstractFeatureField;
import org.vaadin.addons.maplibre.DrawControl;
import org.vaadin.addons.maplibre.MapLibre;

public class PolygonField
extends AbstractFeatureField<Polygon> {
    private boolean cuttingHole;
    private boolean allowCuttingHoles = false;
    private Polygon polygon;
    Button cutHole = new Button((Component)VaadinIcon.SCISSORS.create());

    public PolygonField() {
        this.getToolbar().add(new Component[]{this.cutHole});
        this.cutHole.setVisible(false);
        this.cutHole.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.cutHole.addClassName("maplibre-cut-hole");
        this.cutHole.setTooltipText("Cut a new whole to the current polygon.");
        this.cutHole.addClickListener((ComponentEventListener & Serializable)e -> {
            this.getDrawControl().setMode(DrawControl.DrawMode.DRAW_POLYGON);
            this.cuttingHole = true;
        });
    }

    public PolygonField(String label) {
        this();
        this.setLabel(label);
    }

    @Override
    protected void setMap(MapLibre map) {
        super.setMap(map);
        this.getDrawControl().addGeometryChangeListener(e -> {
            GeometryCollection geom = e.getGeom();
            if (this.cuttingHole) {
                this.cuttingHole = false;
                try {
                    Geometry hole = geom.getGeometryN(1);
                    this.polygon = (Polygon)geom.getGeometryN(0).symDifference(hole);
                }
                catch (Exception ex) {
                    Notification.show((String)"Cutting hole failed, make sure it is withing the existing Polygon and doesn't conflict other holes.");
                }
                this.getDrawControl().setGeometry((Geometry)this.polygon);
            } else {
                this.polygon = (Polygon)geom.getGeometryN(0);
                this.cutHole.setVisible(this.allowCuttingHoles && this.polygon != null);
                this.getResetButton().setVisible(this.polygon != null);
            }
            this.updateValue();
        });
        this.getDrawControl().addModeChangeListener(e -> {
            if (this.polygon == null && e.getDrawMode() != DrawControl.DrawMode.DRAW_POLYGON) {
                this.getDrawControl().setMode(DrawControl.DrawMode.DRAW_POLYGON);
            }
        });
    }

    public PolygonField withAllowCuttingHoles(boolean allow) {
        this.allowCuttingHoles = allow;
        return this;
    }

    protected Polygon generateModelValue() {
        return this.polygon;
    }

    @Override
    protected void reset() {
        super.reset();
        this.getDrawControl().setMode(DrawControl.DrawMode.DRAW_POLYGON);
        this.cutHole.setVisible(false);
        this.polygon = null;
        this.updateValue();
    }

    protected void setPresentationValue(Polygon polygon) {
        this.polygon = polygon;
        this.cutHole.setVisible(this.allowCuttingHoles && polygon != null);
        this.getResetButton().setVisible(polygon != null);
        this.runAttached(() -> {
            if (polygon == null) {
                this.getDrawControl().setMode(DrawControl.DrawMode.DRAW_POLYGON);
            } else {
                this.getDrawControl().setGeometry((Geometry)polygon);
                this.getDrawControl().setMode(DrawControl.DrawMode.SIMPLE_SELECT);
                this.getDrawControl().directSelectFirst();
                this.getMap().fitBounds((Geometry)polygon);
            }
        });
    }
}

