/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tinymce;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Version;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.UUID;
import org.github.legioth.field.Field;
import org.github.legioth.field.ValueMapper;

@Tag(value="div")
@JavaScript(value="./tinymceConnector.js")
public class TinyMce
extends Component
implements Field<TinyMce, String>,
HasSize {
    private String id;
    private boolean initialContentSent;
    private String currentValue = "";
    private final ValueMapper<String> valueMapper;
    private String rawConfig;
    JsonObject config = Json.createObject();
    private Element ta = new Element("div");

    public TinyMce(boolean shadowRoot) {
        this.setHeight("500px");
        this.ta.getStyle().set("height", "100%");
        if (shadowRoot) {
            ShadowRoot shadow = this.getElement().attachShadow();
            shadow.appendChild(new Element[]{this.ta});
        } else {
            this.getElement().appendChild(new Element[]{this.ta});
        }
        this.valueMapper = Field.init((Component)this, (Object)"", this::setEditorContent);
    }

    public TinyMce() {
        this(false);
    }

    public void setEditorContent(String html) {
        this.currentValue = html;
        if (this.initialContentSent) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEditorContent", new Serializable[]{html}));
        } else {
            this.ta.setProperty("innerHTML", html);
        }
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.id = UUID.randomUUID().toString();
        this.ta.setAttribute("id", this.id);
        this.ta.setProperty("innerHTML", this.currentValue);
        super.onAttach(attachEvent);
        if (attachEvent.isInitialAttach()) {
            this.injectTinyMceScript();
        }
        this.initConnector();
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.initialContentSent = false;
    }

    private void initConnector() {
        this.initialContentSent = true;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("window.Vaadin.Flow.tinymceConnector.initLazy($0, $1, $2, $3)", new Serializable[]{this.rawConfig, this.getElement(), this.ta, this.config}));
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    @ClientCallable
    private void updateValue(String htmlString) {
        this.currentValue = htmlString;
        this.valueMapper.setModelValue((Object)this.currentValue, true);
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setConfig(String jsonConfig) {
        this.rawConfig = jsonConfig;
    }

    public TinyMce configure(String configurationKey, String value) {
        this.config.put(configurationKey, value);
        return this;
    }

    public TinyMce configure(String configurationKey, String ... value) {
        JsonArray array = Json.createArray();
        for (int i = 0; i < value.length; ++i) {
            array.set(i, value[i]);
        }
        this.config.put(configurationKey, (JsonValue)array);
        return this;
    }

    public TinyMce configure(String configurationKey, boolean value) {
        this.config.put(configurationKey, value);
        return this;
    }

    public TinyMce configure(String configurationKey, double value) {
        this.config.put(configurationKey, value);
        return this;
    }

    public void replaceSelectionContent(String htmlString) {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.replaceSelectionContent", new Serializable[]{htmlString}));
    }

    protected void injectTinyMceScript() {
        int majorVersion = Version.getMajorVersion();
        if (majorVersion > 2) {
            ((UI)this.getUI().get()).getPage().addJavaScript("frontend/tinymce_addon/tinymce/tinymce.js");
        } else {
            ((UI)this.getUI().get()).getPage().addJavaScript("tinymce_addon/tinymce/tinymce.js");
        }
    }

    public void focus() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.focus", new Serializable[0]));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEnabled", new Serializable[]{Boolean.valueOf(enabled)}));
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.setEnabled(!readOnly);
    }
}

