/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tinymce;

import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.UUID;
import org.vaadin.tinymce.Menubar;
import org.vaadin.tinymce.Plugin;
import org.vaadin.tinymce.Toolbar;

@Tag(value="div")
@JavaScript(value="./tinymceConnector.js")
public class TinyMce
extends AbstractCompositeField<Div, TinyMce, String>
implements HasSize,
Focusable<TinyMce> {
    private final DomListenerRegistration domListenerRegistration;
    private String id;
    private boolean initialContentSent;
    private String currentValue = "";
    private String rawConfig;
    JsonObject config = Json.createObject();
    private Element ta = new Element("div");
    private int debounceTimeout = 5000;
    private boolean basicTinyMCECreated;

    public TinyMce(boolean shadowRoot) {
        super((Object)"");
        this.setHeight("500px");
        this.ta.getStyle().set("height", "100%");
        if (shadowRoot) {
            ShadowRoot shadow = this.getElement().attachShadow();
            shadow.appendChild(new Element[]{this.ta});
        } else {
            this.getElement().appendChild(new Element[]{this.ta});
        }
        this.domListenerRegistration = this.getElement().addEventListener("tchange", (DomEventListener & Serializable)event -> {
            String htmlString;
            boolean value = event.getEventData().hasKey("event.htmlString");
            this.currentValue = htmlString = event.getEventData().getString("event.htmlString");
            this.setModelValue(htmlString, true);
        });
        this.domListenerRegistration.addEventData("event.htmlString");
        this.domListenerRegistration.debounce(this.debounceTimeout);
    }

    public void setDebounceTimeout(int debounceTimeout) {
        this.debounceTimeout = debounceTimeout;
        this.domListenerRegistration.debounce(debounceTimeout);
    }

    public TinyMce() {
        this(false);
    }

    @Deprecated(forRemoval=true)
    public void setEditorContent(String html) {
        this.setPresentationValue(html);
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
            this.ta.setAttribute("id", this.id);
        }
        super.onAttach(attachEvent);
        if (attachEvent.isInitialAttach()) {
            this.injectTinyMceScript();
        }
        this.initConnector();
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.initialContentSent = false;
    }

    private void initConnector() {
        this.initialContentSent = true;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("window.Vaadin.Flow.tinymceConnector.initLazy($0, $1, $2, $3, $4)", new Serializable[]{this.rawConfig, this.getElement(), this.ta, this.config, this.currentValue}));
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setConfig(String jsonConfig) {
        this.rawConfig = jsonConfig;
    }

    public TinyMce configure(String configurationKey, String value) {
        this.config.put(configurationKey, value);
        return this;
    }

    public TinyMce configure(String configurationKey, String ... value) {
        JsonArray array = Json.createArray();
        for (int i = 0; i < value.length; ++i) {
            array.set(i, value[i]);
        }
        this.config.put(configurationKey, (JsonValue)array);
        return this;
    }

    public TinyMce configure(String configurationKey, boolean value) {
        this.config.put(configurationKey, value);
        return this;
    }

    public TinyMce configure(String configurationKey, double value) {
        this.config.put(configurationKey, value);
        return this;
    }

    public void replaceSelectionContent(String htmlString) {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.replaceSelectionContent", new Serializable[]{htmlString}));
    }

    protected void injectTinyMceScript() {
        ((UI)this.getUI().get()).getPage().addJavaScript("context://frontend/tinymce_addon/tinymce/tinymce.min.js");
    }

    public void focus() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.focus", new Serializable[0]));
    }

    public Registration addFocusListener(ComponentEventListener<FocusNotifier.FocusEvent<TinyMce>> listener) {
        DomListenerRegistration domListenerRegistration = this.getElement().addEventListener("tfocus", (DomEventListener & Serializable)event -> listener.onComponentEvent((ComponentEvent)new FocusNotifier.FocusEvent((Component)this, false)));
        return domListenerRegistration;
    }

    public Registration addBlurListener(ComponentEventListener<BlurNotifier.BlurEvent<TinyMce>> listener) {
        DomListenerRegistration domListenerRegistration = this.getElement().addEventListener("tblur", (DomEventListener & Serializable)event -> listener.onComponentEvent((ComponentEvent)new BlurNotifier.BlurEvent((Component)this, false)));
        return domListenerRegistration;
    }

    public void blur() {
        throw new RuntimeException("Not implemented, TinyMce does not support programmatic blur.");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEnabled", new Serializable[]{Boolean.valueOf(enabled)}));
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.setEnabled(!readOnly);
    }

    protected void setPresentationValue(String html) {
        this.currentValue = html;
        if (this.initialContentSent) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEditorContent", new Serializable[]{html}));
        }
    }

    private TinyMce createBasicTinyMce() {
        this.setValue("");
        this.configure("branding", false);
        this.basicTinyMCECreated = true;
        this.configurePlugin(false, Plugin.ADVLIST, Plugin.AUTOLINK, Plugin.LISTS, Plugin.SEARCH_REPLACE);
        this.configureMenubar(false, Menubar.FILE, Menubar.EDIT, Menubar.VIEW, Menubar.FORMAT);
        this.configureToolbar(false, Toolbar.UNDO, Toolbar.REDO, Toolbar.SEPARATOR, Toolbar.FORMAT_SELECT, Toolbar.SEPARATOR, Toolbar.BOLD, Toolbar.ITALIC, Toolbar.SEPARATOR, Toolbar.ALIGN_LEFT, Toolbar.ALIGN_CENTER, Toolbar.ALIGN_RIGHT, Toolbar.ALIGN_JUSTIFY, Toolbar.SEPARATOR, Toolbar.OUTDENT, Toolbar.INDENT);
        return this;
    }

    public TinyMce configurePlugin(boolean basicTinyMCE, Plugin ... plugins) {
        if (basicTinyMCE && !this.basicTinyMCECreated) {
            this.createBasicTinyMce();
        }
        JsonArray jsonArray = (JsonArray)this.config.get("plugins");
        int initialIndex = 0;
        if (jsonArray != null) {
            initialIndex = jsonArray.length();
        } else {
            jsonArray = Json.createArray();
        }
        for (int i = 0; i < plugins.length; ++i) {
            jsonArray.set(initialIndex, plugins[i].pluginLabel);
            ++initialIndex;
        }
        this.config.put("plugins", (JsonValue)jsonArray);
        return this;
    }

    public TinyMce configureMenubar(boolean basicTinyMCE, Menubar ... menubars) {
        if (basicTinyMCE && !this.basicTinyMCECreated) {
            this.createBasicTinyMce();
        }
        JsonArray jsonArray = (JsonArray)this.config.get("menubar");
        int initialIndex = 0;
        if (jsonArray != null) {
            initialIndex = jsonArray.length();
        } else {
            jsonArray = Json.createArray();
        }
        for (int i = 0; i < menubars.length; ++i) {
            jsonArray.set(initialIndex, menubars[i].menubarLabel);
            ++initialIndex;
        }
        this.config.put("menubar", (JsonValue)jsonArray);
        return this;
    }

    public TinyMce configureToolbar(boolean basicTinyMCE, Toolbar ... toolbars) {
        if (basicTinyMCE && !this.basicTinyMCECreated) {
            this.createBasicTinyMce();
        }
        JsonValue jsonValue = this.config.get("toolbar");
        String toolbarStr = "";
        if (jsonValue != null) {
            toolbarStr = toolbarStr.concat(jsonValue.asString());
        }
        for (int i = 0; i < toolbars.length; ++i) {
            toolbarStr = toolbarStr.concat(" ").concat(toolbars[i].toolbarLabel).concat(" ");
        }
        this.config.put("toolbar", toolbarStr);
        return this;
    }
}

