/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tinymce;

import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import org.vaadin.tinymce.Language;
import org.vaadin.tinymce.Menubar;
import org.vaadin.tinymce.Plugin;
import org.vaadin.tinymce.Toolbar;
import org.vaadin.tinymce.ValueChangeMode;

@Tag(value="div")
@JavaScript(value="context://frontend/tinymceConnector.js")
@StyleSheet(value="context://frontend/tinymceLumo.css")
public class TinyMce
extends AbstractCompositeField<Div, TinyMce, String>
implements HasSize,
Focusable<TinyMce> {
    private final DomListenerRegistration domListenerRegistration;
    private String id;
    private boolean initialContentSent;
    private String currentValue = "";
    private String rawConfig;
    JsonObject config = Json.createObject();
    private Element ta = new Element("div");
    private int debounceTimeout = 0;
    private boolean basicTinyMCECreated;
    private boolean enabled = true;
    private boolean readOnly = false;

    @Deprecated
    public TinyMce(boolean shadowRoot) {
        super((Object)"");
        this.setHeight("500px");
        this.ta.getStyle().set("height", "100%");
        if (shadowRoot) {
            ShadowRoot shadow = this.getElement().attachShadow();
            shadow.appendChild(new Element[]{this.ta});
        } else {
            this.getElement().appendChild(new Element[]{this.ta});
        }
        this.domListenerRegistration = this.getElement().addEventListener("tchange", (DomEventListener & Serializable)event -> {
            String htmlString;
            boolean value = event.getEventData().hasKey("event.htmlString");
            this.currentValue = htmlString = event.getEventData().getString("event.htmlString");
            this.setModelValue(htmlString, true);
        });
        this.domListenerRegistration.addEventData("event.htmlString");
        this.domListenerRegistration.debounce(this.debounceTimeout);
    }

    public void setValueChangeMode(ValueChangeMode mode) {
        if (mode == ValueChangeMode.BLUR) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setMode", new Serializable[]{"blur"}));
        } else if (mode == ValueChangeMode.TIMEOUT) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setMode", new Serializable[]{"timeout"}));
        } else if (mode == ValueChangeMode.CHANGE) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setMode", new Serializable[]{"change"}));
        }
    }

    public void setDebounceTimeout(int debounceTimeout) {
        if (debounceTimeout > 0) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEager", new Serializable[]{"timeout"}));
        } else {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEager", new Serializable[]{"change"}));
        }
        this.domListenerRegistration.debounce(debounceTimeout);
    }

    public TinyMce() {
        this(false);
    }

    @Deprecated(forRemoval=true)
    public void setEditorContent(String html) {
        this.setPresentationValue(html);
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
            this.ta.setAttribute("id", this.id);
        }
        if (!this.getEventBus().hasListener(BlurNotifier.BlurEvent.class)) {
            this.addBlurListener((ComponentEventListener<BlurNotifier.BlurEvent<TinyMce>>)(ComponentEventListener & Serializable)e -> {});
        }
        if (!attachEvent.isInitialAttach()) {
            this.initialContentSent = true;
        }
        super.onAttach(attachEvent);
        if (attachEvent.isInitialAttach()) {
            this.injectTinyMceScript();
        }
        this.initConnector();
        this.saveOnClose();
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (this.isVisible()) {
            detachEvent.getUI().getPage().executeJs("tinymce.get($0).remove();\n", new Serializable[]{this.id});
        }
        super.onDetach(detachEvent);
        this.initialContentSent = false;
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (this.rawConfig == null) {
                this.rawConfig = "{}";
            }
            ui.getPage().executeJs("const editor = $0;const rawconfig = " + this.rawConfig + ";\nwindow.Vaadin.Flow.tinymceConnector.initLazy(rawconfig, $0, $1, $2, $3, $4)", new Serializable[]{this.getElement(), this.ta, this.config, this.currentValue, Boolean.valueOf(this.enabled && !this.readOnly)}).then((SerializableConsumer & Serializable)res -> {
                this.initialContentSent = true;
            });
        });
    }

    private void saveOnClose() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.saveOnClose", new Serializable[0]));
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setConfig(String jsConfig) {
        this.rawConfig = jsConfig;
    }

    public TinyMce configure(String configurationKey, String value) {
        this.config.put(configurationKey, value);
        return this;
    }

    public TinyMce configure(String configurationKey, String ... value) {
        JsonArray array = Json.createArray();
        for (int i = 0; i < value.length; ++i) {
            array.set(i, value[i]);
        }
        this.config.put(configurationKey, (JsonValue)array);
        return this;
    }

    public TinyMce configure(String configurationKey, boolean value) {
        this.config.put(configurationKey, value);
        return this;
    }

    public TinyMce configure(String configurationKey, double value) {
        this.config.put(configurationKey, value);
        return this;
    }

    public TinyMce configureLanguage(Language language) {
        this.config.put("language", language.toString());
        return this;
    }

    public void replaceSelectionContent(String htmlString) {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.replaceSelectionContent", new Serializable[]{htmlString}));
    }

    protected void injectTinyMceScript() {
        ((UI)this.getUI().get()).getPage().addJavaScript("context://frontend/tinymce_addon/tinymce/tinymce.min.js");
    }

    public void focus() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().executeJs("const el = this;\nif(el.$connector.isInDialog()) {\n    setTimeout(() => {\n        el.$connector.focus()\n    }, 150);\n} else {\n    el.$connetor.focus();\n}\n", new Serializable[0]));
    }

    public Registration addFocusListener(ComponentEventListener<FocusNotifier.FocusEvent<TinyMce>> listener) {
        DomListenerRegistration domListenerRegistration = this.getElement().addEventListener("tfocus", (DomEventListener & Serializable)event -> listener.onComponentEvent((ComponentEvent)new FocusNotifier.FocusEvent((Component)this, false)));
        return domListenerRegistration;
    }

    public Registration addBlurListener(ComponentEventListener<BlurNotifier.BlurEvent<TinyMce>> listener) {
        DomListenerRegistration domListenerRegistration = this.getElement().addEventListener("tblur", (DomEventListener & Serializable)event -> listener.onComponentEvent((ComponentEvent)new BlurNotifier.BlurEvent((Component)this, false)));
        return domListenerRegistration;
    }

    public void blur() {
        throw new RuntimeException("Not implemented, TinyMce does not support programmatic blur.");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.adjustEnabledState();
    }

    private void adjustEnabledState() {
        boolean reallyEnabled = this.enabled && !this.readOnly;
        super.setEnabled(reallyEnabled);
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEnabled", new Serializable[]{Boolean.valueOf(reallyEnabled)}));
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        super.setReadOnly(readOnly);
        this.adjustEnabledState();
    }

    protected void setPresentationValue(String html) {
        this.currentValue = html;
        if (this.initialContentSent) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setEditorContent", new Serializable[]{html}));
        }
    }

    private TinyMce createBasicTinyMce() {
        this.setValue("");
        this.configure("branding", false);
        this.basicTinyMCECreated = true;
        this.configurePlugin(false, Plugin.ADVLIST, Plugin.AUTOLINK, Plugin.LISTS, Plugin.SEARCH_REPLACE);
        this.configureMenubar(false, Menubar.FILE, Menubar.EDIT, Menubar.VIEW, Menubar.FORMAT);
        this.configureToolbar(false, Toolbar.UNDO, Toolbar.REDO, Toolbar.SEPARATOR, Toolbar.FORMAT_SELECT, Toolbar.SEPARATOR, Toolbar.BOLD, Toolbar.ITALIC, Toolbar.SEPARATOR, Toolbar.ALIGN_LEFT, Toolbar.ALIGN_CENTER, Toolbar.ALIGN_RIGHT, Toolbar.ALIGN_JUSTIFY, Toolbar.SEPARATOR, Toolbar.OUTDENT, Toolbar.INDENT);
        return this;
    }

    public TinyMce configurePlugin(boolean basicTinyMCE, Plugin ... plugins) {
        if (basicTinyMCE && !this.basicTinyMCECreated) {
            this.createBasicTinyMce();
        }
        JsonArray jsonArray = (JsonArray)this.config.get("plugins");
        int initialIndex = 0;
        if (jsonArray != null) {
            initialIndex = jsonArray.length();
        } else {
            jsonArray = Json.createArray();
        }
        for (int i = 0; i < plugins.length; ++i) {
            jsonArray.set(initialIndex, plugins[i].pluginLabel);
            ++initialIndex;
        }
        this.config.put("plugins", (JsonValue)jsonArray);
        return this;
    }

    public TinyMce configureMenubar(boolean basicTinyMCE, Menubar ... menubars) {
        Object menubar;
        if (basicTinyMCE && !this.basicTinyMCECreated) {
            this.createBasicTinyMce();
        }
        String newconfig = Arrays.stream(menubars).map(m -> m.menubarLabel).collect(Collectors.joining(" "));
        if (this.config.hasKey("menubar")) {
            menubar = this.config.getString("menubar");
            menubar = (String)menubar + " " + newconfig;
        } else {
            menubar = newconfig;
        }
        this.config.put("menubar", (String)menubar);
        return this;
    }

    public TinyMce configureToolbar(boolean basicTinyMCE, Toolbar ... toolbars) {
        if (basicTinyMCE && !this.basicTinyMCECreated) {
            this.createBasicTinyMce();
        }
        JsonValue jsonValue = this.config.get("toolbar");
        String toolbarStr = "";
        if (jsonValue != null) {
            toolbarStr = toolbarStr.concat(jsonValue.asString());
        }
        for (int i = 0; i < toolbars.length; ++i) {
            toolbarStr = toolbarStr.concat(" ").concat(toolbars[i].toolbarLabel).concat(" ");
        }
        this.config.put("toolbar", toolbarStr);
        return this;
    }
}

