/*
 * Decompiled with CFR 0.152.
 */
package org.parttio.vaadinjsloader;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.RequestHandler;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class JSLoader {
    public static final String CDNJS = "https://cdnjs.cloudflare.com/ajax/libs/{library}/{version}/{file}";
    public static final String CDNJS_MIN = "https://cdnjs.cloudflare.com/ajax/libs/{library}/{version}/{file}";
    public static final String URL_PATTERN_UNPKGCOM = "https://unpkg.com/{library}@{version}";
    public static final String URL_PATTERN_UNPKGCOM_FILES = "https://unpkg.com/{library}@{version}/{file}";
    public static final String PUBLIC_JAVA_RESOURCE_PATH = "/resources/";
    private static final Map<String, String> loaded = new HashMap<String, String>();

    public static void load(Component component, String libraryName, String version, String libraryFile, String urlPattern) {
        JSLoader.loadFiles(component, urlPattern, libraryName, version, libraryFile);
    }

    public static void loadFiles(Component component, String urlPattern, String libraryName, String version, String ... file) {
        assert (component != null) : "Component cannot be null";
        assert (libraryName != null && !libraryName.isEmpty()) : "Library name cannot be null or empty";
        assert (urlPattern != null && !urlPattern.isEmpty()) : "URL Pattern cannot be null or empty";
        if (version == null || version.isEmpty()) {
            version = "latest";
        }
        if (JSLoader.isLoaded(component, libraryName)) {
            return;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("library", libraryName);
        replacements.put("version", version);
        UI ui = JSLoader.getUI(component);
        if (file != null && file.length > 0) {
            for (String f : file) {
                replacements.put("file", f);
                String fileUrl = JSLoader.replacePlaceholders(urlPattern, replacements);
                if (f.toLowerCase().endsWith(".css")) {
                    ui.getPage().addStyleSheet(fileUrl);
                    continue;
                }
                if (f.toLowerCase().endsWith(".mjs")) {
                    ui.getPage().addJsModule(fileUrl);
                    JSLoader.importModuleExports(ui, libraryName, fileUrl);
                    continue;
                }
                ui.getPage().addJavaScript(fileUrl);
            }
        } else {
            String scriptUrl = JSLoader.replacePlaceholders(urlPattern, replacements);
            if (scriptUrl.toLowerCase().endsWith(".mjs")) {
                ui.getPage().addJsModule(scriptUrl);
                JSLoader.importModuleExports(ui, libraryName, scriptUrl);
            } else {
                ui.getPage().addJavaScript(scriptUrl);
            }
        }
        JSLoader.setLoadedVersion(ui, libraryName, version);
    }

    private static void importModuleExports(UI ui, String libraryName, String fileUrl) {
        ui.getPage().executeJs("globalThis[$1]=globalThis[$1] || {}; var f = async () => { var m = await import($0); Object.keys(m).forEach(k => globalThis[$1][k] = m[k])}; return f();", new Serializable[]{fileUrl, libraryName});
    }

    public static String getLoadedVersion(Component component, String library) {
        UI ui = JSLoader.getUI(component);
        return loaded.get(ui.getSession().getSession().getId() + ui.getUIId() + "_" + library);
    }

    public static void loadCdnjs(Component component, String libraryName, String version) {
        JSLoader.load(component, libraryName, version, libraryName + ".min.js", "https://cdnjs.cloudflare.com/ajax/libs/{library}/{version}/{file}");
    }

    public static void loadCdnjs(Component component, String libraryName, String version, boolean minified) {
        if (minified) {
            JSLoader.load(component, libraryName, version, null, "https://cdnjs.cloudflare.com/ajax/libs/{library}/{version}/{file}");
        } else {
            JSLoader.load(component, libraryName, version, null, "https://cdnjs.cloudflare.com/ajax/libs/{library}/{version}/{file}");
        }
    }

    public static void loadUnpkg(Component component, String libraryName, String version, String ... libraryFile) {
        if (libraryFile != null && libraryFile.length > 0) {
            JSLoader.loadFiles(component, URL_PATTERN_UNPKGCOM_FILES, libraryName, version, libraryFile);
        } else {
            JSLoader.loadFiles(component, URL_PATTERN_UNPKGCOM, libraryName, version, libraryFile);
        }
    }

    public static void loadJavaResource(UI ui, Class<?> cls, String libraryName, String ... files) {
        if (JSLoader.isLoaded((Component)ui, libraryName)) {
            return;
        }
        JSLoader.loadFiles((Component)ui, "/resources/{library}/{file}", libraryName, "latest", files);
        RequestHandler & Serializable requestHandler = (RequestHandler & Serializable)(session, request, response) -> {
            if (!request.getPathInfo().contains(PUBLIC_JAVA_RESOURCE_PATH + libraryName)) {
                return false;
            }
            String resourceName = request.getPathInfo().substring(request.getPathInfo().indexOf(PUBLIC_JAVA_RESOURCE_PATH) + (PUBLIC_JAVA_RESOURCE_PATH + libraryName + "/").length());
            if (Arrays.asList(files).contains(resourceName)) {
                InputStream resourceStream = cls.getResourceAsStream(resourceName);
                if (resourceStream == null) {
                    response.sendError(404, "Failed to load file.");
                    return true;
                }
                try (InputStream inputStream = resourceStream;){
                    response.setContentType(JSLoader.getContentTypeForFileExtension(resourceName));
                    response.setStatus(200);
                    resourceStream.transferTo(response.getOutputStream());
                }
                catch (Exception e) {
                    try {
                        response.sendError(500, "Failed to load file.");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }
                return true;
            }
            return false;
        };
        ui.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui2 -> ui2.beforeClientResponse((Component)ui2, (SerializableConsumer & Serializable)ctx -> {
            ctx.getUI().getSession().addRequestHandler(requestHandler);
            ui2.getElement().getNode().addDetachListener((Command & Serializable)() -> ctx.getUI().getSession().removeRequestHandler(requestHandler));
        }));
    }

    private static String getContentTypeForFileExtension(String resourceName) {
        if (resourceName.endsWith(".js") || resourceName.endsWith(".mjs")) {
            return "application/javascript";
        }
        if (resourceName.endsWith(".css")) {
            return "text/css";
        }
        return "text/plain";
    }

    private static String replacePlaceholders(String baseUrlPattern, Map<String, String> replacements) {
        String result = baseUrlPattern;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            if (entry.getValue() == null) continue;
            result = result.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return result;
    }

    private static UI getUI(Component component) {
        if (component instanceof UI) {
            return (UI)component;
        }
        return component.getUI().orElse(UI.getCurrent());
    }

    private static void setLoadedVersion(UI ui, String library, String version) {
        loaded.put(ui.getSession().getSession().getId() + ui.getUIId() + "_" + library, version);
        ui.getPage().executeJs("window.vaadinjsloader = window.vaadinjsloader || {}; window.vaadinjsloader[$0] = $1; return window.vaadinjsloader;", new Serializable[]{library, version});
    }

    public static boolean isLoaded(Component component, String library) {
        return JSLoader.getLoadedVersion(component, library) != null;
    }

    public static boolean isLoaded(Component component, String library, String version) {
        return version != null && version.equals(JSLoader.getLoadedVersion(component, library));
    }
}

