/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.daveware.passwordmaker.Account;
import org.daveware.passwordmaker.AccountPatternMatcher;
import org.daveware.passwordmaker.DatabaseListener;
import org.daveware.passwordmaker.GlobalSettingKey;

public class Database {
    private final CopyOnWriteArrayList<DatabaseListener> listeners = new CopyOnWriteArrayList();
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Account rootAccount = new Account("root", "", "");
    private HashMap<String, String> globalSettings = new HashMap();
    private boolean dirty = false;

    public Database() {
        this.rootAccount.setId("http://passwordmaker.mozdev.org/accounts");
    }

    public Account getRootAccount() {
        return this.rootAccount;
    }

    public void swapAccounts(Database other) {
        Account otherRoot = other.rootAccount;
        other.rootAccount = this.rootAccount;
        this.rootAccount = otherRoot;
        boolean otherDirty = other.dirty;
        other.dirty = this.dirty;
        this.dirty = otherDirty;
        HashMap<String, String> otherGlobalSettings = other.globalSettings;
        other.globalSettings = this.globalSettings;
        this.globalSettings = otherGlobalSettings;
    }

    public void addAccount(Account parent, Account child) throws Exception {
        for (Account dup : parent.getChildren()) {
            if (dup != child) continue;
            this.logger.warning("Duplicate RDF:li=" + child.getId() + " detected. Dropping duplicate");
            return;
        }
        int iterationCount = 0;
        int maxIteration = 0x100000;
        while (this.findAccountById(child.getId()) != null && iterationCount++ < 0x100000) {
            this.logger.warning("ID collision detected on '" + child.getId() + "', attempting to regenerate ID. iteration=" + iterationCount);
            child.setId(Account.createId(child));
        }
        if (iterationCount >= 0x100000) {
            throw new Exception("Could not genererate a unique ID in " + iterationCount + " iterations, this is really rare. I know it's lame, but change the description and try again.");
        }
        parent.getChildren().add(child);
        this.sendAccountAdded(parent, child);
        this.setDirty(true);
    }

    public void changeAccount(Account account) {
        this.sendAccountChanged(account);
        this.setDirty(true);
    }

    public void removeAccount(Account accountToDelete) {
        if (accountToDelete.getId().equals(this.rootAccount.getId())) {
            return;
        }
        Account parent = this.findParent(accountToDelete);
        if (parent != null) {
            this.removeAccount(parent, accountToDelete);
            this.setDirty(true);
        }
    }

    private void removeAccount(Account parent, Account child) {
        parent.getChildren().remove(child);
        this.sendAccountRemoved(parent, child);
    }

    public void setGlobalSetting(String name, String value) {
        String oldValue;
        if (this.globalSettings.containsKey(name) && value.compareTo(oldValue = this.globalSettings.get(name)) == 0) {
            return;
        }
        this.globalSettings.put(name, value);
        this.setDirty(true);
    }

    public void setGlobalSetting(GlobalSettingKey key, String value) {
        this.setGlobalSetting(key.toString(), value);
    }

    public HashMap<String, String> getGlobalSettings() {
        return this.globalSettings;
    }

    public String getGlobalSetting(GlobalSettingKey key) {
        if (this.globalSettings.containsKey(key.toString())) {
            return this.globalSettings.get(key.toString());
        }
        return key.getDefault();
    }

    public void addDatabaseListener(DatabaseListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeDatabaseListener(DatabaseListener l) {
        this.listeners.remove(l);
    }

    private void sendAccountAdded(Account parent, Account child) {
        for (DatabaseListener listener : this.listeners) {
            listener.accountAdded(parent, child);
        }
    }

    private void sendAccountChanged(Account account) {
        for (DatabaseListener listener : this.listeners) {
            listener.accountChanged(account);
        }
    }

    private void sendAccountRemoved(Account parent, Account child) {
        for (DatabaseListener listener : this.listeners) {
            listener.accountRemoved(parent, child);
        }
    }

    private void sendDirtyStatusChanged() {
        for (DatabaseListener listener : this.listeners) {
            listener.dirtyStatusChanged(this.dirty);
        }
    }

    public void addDefaultAccount() throws Exception {
        Account defaultAccount = new Account();
        defaultAccount.setName("Defaults");
        defaultAccount.setId("http://passwordmaker.mozdev.org/defaults");
        defaultAccount.setDesc("Default settings for URLs not elsewhere in this list");
        defaultAccount.setUrlComponents(EnumSet.of(Account.UrlComponents.Domain));
        this.addAccount(this.rootAccount, defaultAccount);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean status) {
        this.dirty = status;
        this.sendDirtyStatusChanged();
    }

    public void printDatabase() {
        this.printDatabase(System.out);
    }

    public void printDatabase(PrintStream stream) {
        this.printDatabase(this.rootAccount, 0, stream);
    }

    private void printDatabase(Account acc, int level, PrintStream stream) {
        String buf = "";
        for (int i = 0; i < level; ++i) {
            buf = buf + " ";
        }
        buf = buf + "+";
        buf = buf + acc.getName() + "[" + acc.getUrl() + "] (" + acc.getPatterns().size() + " patterns)";
        stream.println(buf);
        for (Account account : acc.getChildren()) {
            this.printDatabase(account, level + 2, stream);
        }
    }

    public List<Account> findPathToAccountById(String id) {
        LinkedList<Account> result = this.getRootInLinkedList();
        this.findAccountById(result, id);
        ArrayList<Account> retValue = new ArrayList<Account>(result.size());
        Iterator<Account> iter = result.descendingIterator();
        while (iter.hasNext()) {
            retValue.add(iter.next());
        }
        return retValue;
    }

    public List<Account> getAllAccounts() {
        HashSet<Account> acc = new HashSet<Account>();
        this.getAllAccounts(this.getRootAccount(), acc);
        ArrayList<Account> sorted = new ArrayList<Account>(acc);
        Collections.sort(sorted, new Comparator<Account>(){

            @Override
            public int compare(Account o1, Account o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return sorted;
    }

    private void getAllAccounts(Account base, Collection<Account> into) {
        for (Account c : base.getChildren()) {
            if (c.hasChildren()) {
                this.getAllAccounts(c, into);
                continue;
            }
            into.add(c);
        }
    }

    public Account findAccountById(String id) {
        return this.findAccountById(this.getRootInLinkedList(), id);
    }

    private Account findAccountById(LinkedList<Account> stack, String id) {
        Account parent = stack.peek();
        if (parent == null) {
            if (!stack.isEmpty()) {
                stack.pop();
            }
            return null;
        }
        for (Account child : parent.getChildren()) {
            if (child.getId().equals(id)) {
                stack.push(child);
                return child;
            }
            if (child.getChildren().size() <= 0) continue;
            stack.push(child);
            Account foundAccount = this.findAccountById(stack, id);
            if (foundAccount == null) continue;
            return foundAccount;
        }
        stack.pop();
        return null;
    }

    private LinkedList<Account> getRootInLinkedList() {
        LinkedList<Account> stack = new LinkedList<Account>();
        stack.add(this.rootAccount);
        return stack;
    }

    public Account findAccountByUrl(String url) {
        return this.findAccountByUrl(this.rootAccount, url);
    }

    private Account findAccountByUrl(Account parent, String url) {
        if (AccountPatternMatcher.matchUrl(parent, url) && !parent.isRoot()) {
            return parent;
        }
        for (Account child : parent.getChildren()) {
            Account foundAccount = this.findAccountByUrl(child, url);
            if (foundAccount == null) continue;
            return foundAccount;
        }
        return null;
    }

    public Account findParent(Account account) {
        return this.findParent(this.rootAccount, account);
    }

    private Account findParent(Account parent, Account account) {
        if (parent == null || account == null) {
            return null;
        }
        if (parent.getChildren().contains(account)) {
            return parent;
        }
        for (Account child : parent.getChildren()) {
            Account theOne = this.findParent(child, account);
            if (theOne == null) continue;
            return theOne;
        }
        return null;
    }

    public Account findNearestRelative(Account account) {
        if (account.isRoot()) {
            return null;
        }
        Account parent = this.findParent(account);
        if (parent == null) {
            return null;
        }
        if (parent.getChildren().size() == 1) {
            return parent;
        }
        int index = parent.getChildren().indexOf(account);
        if (index == -1) {
            return parent;
        }
        if (index == parent.getChildren().size() - 1) {
            return parent.getChildren().get(index - 1);
        }
        return parent.getChildren().get(index + 1);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.printDatabase(ps);
        return baos.toString();
    }
}

