/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.daveware.passwordmaker.util.Joiner;

public class Splitter {
    private String sep;
    private boolean mOmmitEmptyStrings;

    private Splitter(String sep) {
        this.sep = sep;
    }

    public static Splitter on(String sep) {
        return new Splitter(sep);
    }

    public Splitter omitEmptyStrings() {
        this.mOmmitEmptyStrings = true;
        return this;
    }

    public Iterable<String> split(final CharSequence sequence) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                if (Splitter.this.mOmmitEmptyStrings) {
                    return Splitter.this.filterOutEmptyStrings(Splitter.this.splittingIterator(sequence));
                }
                return Splitter.this.splittingIterator(sequence);
            }

            public String toString() {
                return Joiner.on(", ").appendTo(new StringBuilder().append('['), this).append(']').toString();
            }
        };
    }

    private Iterator<String> filterOutEmptyStrings(final Iterator<String> splitted) {
        return new Iterator<String>(){
            String next = this.getNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String result = this.next;
                this.next = this.getNext();
                return result;
            }

            public String getNext() {
                while (splitted.hasNext()) {
                    String value = (String)splitted.next();
                    if (value == null || value.isEmpty()) continue;
                    return value;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Iterator<String> splittingIterator(final CharSequence toSplit) {
        if (toSplit.length() == 0) {
            return new ArrayList().iterator();
        }
        return new Iterator<String>(){
            int currentPos = 0;
            int nextPos = this.separatorStart(0);

            @Override
            public boolean hasNext() {
                return this.currentPos >= 0;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int ps = this.nextPos >= 0 ? this.nextPos : toSplit.length();
                String result = this.currentPos == toSplit.length() ? "" : toSplit.subSequence(this.currentPos, ps).toString();
                this.currentPos = this.nextPos < 0 ? -1 : this.separatorEnd(ps);
                this.nextPos = this.nextPos >= 0 ? this.separatorStart(this.currentPos) : -1;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public int separatorStart(int start) {
                if (start < 0) {
                    return start;
                }
                int separatorLength = Splitter.this.sep.length();
                int last = toSplit.length() - separatorLength;
                block0: for (int p = start; p <= last; ++p) {
                    for (int i = 0; i < separatorLength; ++i) {
                        if (toSplit.charAt(i + p) != Splitter.this.sep.charAt(i)) continue block0;
                    }
                    return p;
                }
                return -1;
            }

            public int separatorEnd(int separatorPosition) {
                if (separatorPosition < 0) {
                    return separatorPosition;
                }
                int val = separatorPosition + Splitter.this.sep.length();
                if (val > toSplit.length()) {
                    val = -1;
                }
                return val;
            }
        };
    }
}

