/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.daveware.passwordmaker.Account;
import org.daveware.passwordmaker.AccountPatternData;
import org.daveware.passwordmaker.AccountPatternType;
import org.daveware.passwordmaker.AlgorithmType;
import org.daveware.passwordmaker.CharacterSets;
import org.daveware.passwordmaker.LeetLevel;
import org.daveware.passwordmaker.LeetType;

public class AccountBuilder {
    private String name = "";
    private String desc = "";
    private String url = "";
    private String username = "";
    private AlgorithmType algorithm = AlgorithmType.MD5;
    private boolean hmac = false;
    private boolean trim = false;
    private int length = 8;
    private String characterSet = CharacterSets.ALPHANUMERIC;
    private LeetType leetType = LeetType.NONE;
    private LeetLevel leetLevel = LeetLevel.LEVEL1;
    private String modifier = "";
    private String prefix = "";
    private String suffix = "";
    private boolean sha256Bug = false;
    private String id = null;
    private List<AccountPatternData> patterns = new ArrayList<AccountPatternData>();
    private List<Account> childrenAccounts = new ArrayList<Account>();
    private EnumSet<Account.UrlComponents> urlComponents = EnumSet.noneOf(Account.UrlComponents.class);

    public Account build() throws Exception {
        Account account = new Account(this.name, this.desc, this.url, this.username, this.algorithm, this.hmac, this.trim, this.length, this.characterSet, this.leetType, this.leetLevel, this.modifier, this.prefix, this.suffix, this.sha256Bug);
        account.setPatterns(this.patterns);
        if (this.childrenAccounts.size() > 0) {
            account.getChildren().addAll(this.childrenAccounts);
        }
        if (this.urlComponents != null && !this.urlComponents.isEmpty()) {
            account.setUrlComponents(this.urlComponents);
        }
        if (this.id != null) {
            account.setId(this.id);
        }
        return account;
    }

    public Account buildDefaultAccount() throws Exception {
        this.setId("http://passwordmaker.mozdev.org/defaults");
        this.urlComponents = EnumSet.of(Account.UrlComponents.Domain);
        if (this.name == null || this.name.isEmpty()) {
            this.name = "default";
        }
        return this.build();
    }

    public String getName() {
        return this.name;
    }

    public AccountBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public String getDesc() {
        return this.desc;
    }

    public AccountBuilder setDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public AccountBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public AccountBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public AccountBuilder setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public boolean isHmac() {
        return this.hmac;
    }

    public AccountBuilder setHmac(boolean hmac) {
        this.hmac = hmac;
        return this;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public AccountBuilder setTrim(boolean trim) {
        this.trim = trim;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public AccountBuilder setLength(int length) {
        this.length = length;
        return this;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public AccountBuilder setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
        return this;
    }

    public LeetType getLeetType() {
        return this.leetType;
    }

    public AccountBuilder setLeetType(LeetType leetType) {
        this.leetType = leetType;
        return this;
    }

    public LeetLevel getLeetLevel() {
        return this.leetLevel;
    }

    public AccountBuilder setLeetLevel(LeetLevel leetLevel) {
        this.leetLevel = leetLevel;
        return this;
    }

    public String getModifier() {
        return this.modifier;
    }

    public AccountBuilder setModifier(String modifier) {
        this.modifier = modifier;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public AccountBuilder setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public AccountBuilder setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public boolean isSha256Bug() {
        return this.sha256Bug;
    }

    public AccountBuilder setSha256Bug(boolean sha256Bug) {
        this.sha256Bug = sha256Bug;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public AccountBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public AccountBuilder clearPatterns() {
        this.patterns.clear();
        return this;
    }

    public AccountBuilder addPattern(String desc, String pattern, AccountPatternType type, boolean enabled) {
        AccountPatternData apd = new AccountPatternData();
        apd.setDesc(desc);
        apd.setType(type);
        apd.setEnabled(enabled);
        apd.setPattern(pattern);
        this.patterns.add(apd);
        return this;
    }

    public AccountBuilder addWildcardPattern(String desc, String pattern) {
        return this.addPattern(desc, pattern, AccountPatternType.WILDCARD, true);
    }

    public AccountBuilder addRegexPattern(String desc, String pattern) {
        return this.addPattern(desc, pattern, AccountPatternType.REGEX, true);
    }

    public AccountBuilder clearChildren() {
        this.childrenAccounts.clear();
        return this;
    }

    public AccountBuilder addChildAccount(Account child) {
        this.childrenAccounts.add(child);
        return this;
    }

    public AccountBuilder addChildAccount(AccountBuilder child) throws Exception {
        return this.addChildAccount(child.build());
    }

    public AccountBuilder clearUrlComponents() {
        this.urlComponents.clear();
        return this;
    }

    public AccountBuilder addUrlComponent(Account.UrlComponents component) {
        this.urlComponents.add(component);
        return this;
    }
}

