/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountPatternType
implements Comparable<AccountPatternType> {
    private static final String[] NAMES = new String[]{"Wildcard", "Regular Expression"};
    public static AccountPatternType WILDCARD = new AccountPatternType(0);
    public static AccountPatternType REGEX = new AccountPatternType(1);
    private int type;

    private AccountPatternType() {
        this.type = 0;
    }

    private AccountPatternType(int i) {
        this.type = i;
    }

    public static AccountPatternType fromString(String str) throws Exception {
        if (str.length() == 0) {
            return WILDCARD;
        }
        if (str.equalsIgnoreCase("wildcard")) {
            return WILDCARD;
        }
        if (str.equalsIgnoreCase("regex") || str.equalsIgnoreCase(NAMES[1])) {
            return REGEX;
        }
        throw new Exception(String.format("Invalid AccountPatternType '%1s'", str));
    }

    @Override
    public int compareTo(AccountPatternType o) {
        if (this.type < o.type) {
            return -1;
        }
        if (this.type > o.type) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return NAMES[this.type];
    }
}

