/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import org.daveware.passwordmaker.LeetLevel;
import org.daveware.passwordmaker.SecureCharArray;

public class LeetEncoder {
    static String[][] LEVELS = new String[][]{{"4", "b", "c", "d", "3", "f", "g", "h", "i", "j", "k", "1", "m", "n", "0", "p", "9", "r", "s", "7", "u", "v", "w", "x", "y", "z"}, {"4", "b", "c", "d", "3", "f", "g", "h", "1", "j", "k", "1", "m", "n", "0", "p", "9", "r", "5", "7", "u", "v", "w", "x", "y", "2"}, {"4", "8", "c", "d", "3", "f", "6", "h", "'", "j", "k", "1", "m", "n", "0", "p", "9", "r", "5", "7", "u", "v", "w", "x", "'/", "2"}, {"@", "8", "c", "d", "3", "f", "6", "h", "'", "j", "k", "1", "m", "n", "0", "p", "9", "r", "5", "7", "u", "v", "w", "x", "'/", "2"}, {"@", "|3", "c", "d", "3", "f", "6", "#", "!", "7", "|<", "1", "m", "n", "0", "|>", "9", "|2", "$", "7", "u", "\\/", "w", "x", "'/", "2"}, {"@", "|3", "c", "|)", "&", "|=", "6", "#", "!", ",|", "|<", "1", "m", "n", "0", "|>", "9", "|2", "$", "7", "u", "\\/", "w", "x", "'/", "2"}, {"@", "|3", "[", "|)", "&", "|=", "6", "#", "!", ",|", "|<", "1", "^^", "^/", "0", "|*", "9", "|2", "5", "7", "(_)", "\\/", "\\/\\/", "><", "'/", "2"}, {"@", "8", "(", "|)", "&", "|=", "6", "|-|", "!", "_|", "|(", "1", "|\\/|", "|\\|", "()", "|>", "(,)", "|2", "$", "|", "|_|", "\\/", "\\^/", ")(", "'/", "\"/_"}, {"@", "8", "(", "|)", "&", "|=", "6", "|-|", "!", "_|", "|{", "|_", "/\\/\\", "|\\|", "()", "|>", "(,)", "|2", "$", "|", "|_|", "\\/", "\\^/", ")(", "'/", "\"/_"}};

    public static void leetConvert(LeetLevel level, SecureCharArray message) throws Exception {
        SecureCharArray ret = new SecureCharArray(message.size() * 4);
        char[] messageBytes = message.getData();
        char[] retBytes = ret.getData();
        int currentRetByte = 0;
        if (level.compareTo(LeetLevel.LEVEL1) >= 0 && level.compareTo(LeetLevel.LEVEL9) <= 0) {
            for (int i = 0; i < messageBytes.length; ++i) {
                char b = Character.toLowerCase(messageBytes[i]);
                if (b >= 'a' && b <= 'z') {
                    for (int j = 0; j < LEVELS[level.getLevel() - 1][b - 97].length(); ++j) {
                        retBytes[currentRetByte++] = LEVELS[level.getLevel() - 1][b - 97].charAt(j);
                    }
                    continue;
                }
                retBytes[currentRetByte++] = b;
            }
        }
        ret.resize(currentRetByte, true);
        message.replace(ret);
        ret.erase();
    }
}

