/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.daveware.passwordmaker.Account;
import org.daveware.passwordmaker.AccountPatternData;
import org.daveware.passwordmaker.AccountPatternType;
import org.daveware.passwordmaker.AlgorithmType;
import org.daveware.passwordmaker.Database;
import org.daveware.passwordmaker.DatabaseReader;
import org.daveware.passwordmaker.IncompatibleException;
import org.daveware.passwordmaker.LeetLevel;
import org.daveware.passwordmaker.LeetType;
import org.daveware.passwordmaker.util.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFDatabaseReader
implements DatabaseReader {
    public static final String EXTENSION = ".rdf";
    public static final String FF_GLOBAL_SETTINGS_URI = "http://passwordmaker.mozdev.org/globalSettings";
    public static final int MAX_PATTERNS = 100000;
    Logger logger = Logger.getLogger(this.getClass().getName());
    DatabaseReader.BuggyAlgoAction buggyJavascriptAction = DatabaseReader.BuggyAlgoAction.IGNORE;
    List<IncompatibleException> buggyAccounts = new ArrayList<IncompatibleException>();

    public void setIgnoreBuggyJavascript(boolean b) {
        this.buggyJavascriptAction = b ? DatabaseReader.BuggyAlgoAction.IGNORE : DatabaseReader.BuggyAlgoAction.ABORT;
    }

    @Override
    public void setBuggyAlgoUseAction(DatabaseReader.BuggyAlgoAction action) {
        this.buggyJavascriptAction = action;
    }

    @Override
    public Database read(InputStream i) throws Exception {
        Database db = new Database();
        this.buggyAccounts.clear();
        HashMap<String, Account> descriptionMap = new HashMap<String, Account>();
        HashMap<String, ArrayList<String>> seqMap = new HashMap<String, ArrayList<String>>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(i);
        doc.getDocumentElement().normalize();
        Node rdfNode = doc.getFirstChild();
        if (rdfNode.getNodeName().compareTo("RDF:RDF") != 0) {
            throw new Exception("RDF file contained no 'RDF:RDF' nodes, corrupt file?");
        }
        if (rdfNode.getNodeType() != 1) {
            throw new Exception("RDF XML node does not appear to be an element, corrupt file?");
        }
        this.readAndCreateMaps((Element)rdfNode, descriptionMap, seqMap, db);
        this.createParentChildRelationships(db, descriptionMap, seqMap);
        return db;
    }

    private void readAndCreateMaps(Element rdfElement, HashMap<String, Account> descriptionMap, HashMap<String, ArrayList<String>> seqMap, Database db) throws Exception {
        for (Node child = rdfElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            String seqAbout;
            if (child.getNodeType() != 1) continue;
            Element childElement = (Element)child;
            String nodeName = child.getNodeName();
            if (nodeName.compareTo("RDF:Description") == 0) {
                try {
                    String about = childElement.getAttribute("RDF:about").trim();
                    this.logger.fine("RDF:Desc: " + about);
                    if (about.startsWith("rdf:") || about.compareTo("http://passwordmaker.mozdev.org/defaults") == 0) {
                        Account account = this.readAccountFromDescriptionNode(childElement);
                        descriptionMap.put(account.getId(), account);
                        continue;
                    }
                    if (about.compareTo(FF_GLOBAL_SETTINGS_URI) != 0) continue;
                    NamedNodeMap nodeMap = childElement.getAttributes();
                    int mapLength = nodeMap.getLength();
                    for (int iAttribute = 0; iAttribute < mapLength; ++iAttribute) {
                        Node node = nodeMap.item(iAttribute);
                        if (!node.getNodeName().startsWith("NS1:")) continue;
                        db.setGlobalSetting(node.getNodeName(), node.getNodeValue());
                    }
                    continue;
                }
                catch (IncompatibleException e) {
                    if (this.buggyJavascriptAction == DatabaseReader.BuggyAlgoAction.IGNORE) {
                        this.logger.warning(String.format("***Incompatibility[%1s,%2s]: %2s", ((Element)child).getAttribute("RDF:about"), ((Element)child).getAttribute("NS1:name"), e.getMessage()));
                        this.buggyAccounts.add(e);
                        continue;
                    }
                    throw e;
                }
            }
            if (nodeName.compareTo("RDF:Seq") != 0 || !(seqAbout = childElement.getAttribute("RDF:about")).startsWith("rdf:#") && seqAbout.compareTo("http://passwordmaker.mozdev.org/accounts") != 0) continue;
            this.logger.fine("SEQ: " + seqAbout);
            ArrayList<String> listItems = this.readSeqListItems(childElement);
            if (listItems.size() <= 0) continue;
            this.logger.fine("   = " + listItems.size() + " items read from " + seqAbout);
            seqMap.put(seqAbout, listItems);
        }
    }

    private ArrayList<String> readSeqListItems(Element node) {
        ArrayList<String> items = new ArrayList<String>();
        for (Node childLi = node.getFirstChild(); childLi != null; childLi = childLi.getNextSibling()) {
            if (childLi.getNodeType() != 1 || childLi.getNodeName().compareTo("RDF:li") != 0) continue;
            Element child = (Element)childLi;
            this.logger.fine("    LI: " + child.getAttribute("RDF:resource"));
            items.add(child.getAttribute("RDF:resource"));
        }
        return items;
    }

    @Override
    public Account deserializeAccount(InputStream is) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(is);
        doc.getDocumentElement().normalize();
        Node rdfNode = doc.getFirstChild();
        if (rdfNode.getNodeName().compareTo("RDF:RDF") == 0) {
            if (rdfNode.getNodeType() != 1) {
                throw new Exception("RDF XML node does not appear to be an element, corrupt file?");
            }
            return this.readAccountFromDescriptionNode((Element)rdfNode.getFirstChild());
        }
        if (rdfNode.getNodeName().compareTo("RDF:Description") == 0) {
            if (rdfNode.getNodeType() != 1) {
                throw new Exception("RDF XML node does not appear to be an element, corrupt file?");
            }
            return this.readAccountFromDescriptionNode((Element)rdfNode);
        }
        throw new Exception("RDF file contained no 'RDF:RDF' nodes, corrupt file?");
    }

    private Account readAccountFromDescriptionNode(Element element) throws Exception {
        Account account = new Account();
        account.setId(element.getAttribute("RDF:about").trim());
        account.setName(element.getAttribute("NS1:name").trim());
        account.setDesc(element.getAttribute("NS1:description").trim());
        if (!element.hasAttribute("NS1:hashAlgorithmLB")) {
            account.setIsFolder(true);
        } else {
            account.setLeetType(LeetType.fromRdfString(element.getAttribute("NS1:whereLeetLB").trim().toLowerCase()));
            String level = element.getAttribute("NS1:leetLevelLB").trim();
            if (level.equals("0")) {
                level = "1";
            }
            account.setLeetLevel(LeetLevel.fromString(level));
            String algorithm = element.getAttribute("NS1:hashAlgorithmLB").trim().toLowerCase();
            Pair<AlgorithmType, Boolean> algo = this.fromRdfString(account, algorithm);
            account.setAlgorithm((AlgorithmType)algo.first);
            account.setTrim((Boolean)algo.second);
            account.setHmac(algorithm.contains("hmac-"));
            String passwordLength = element.getAttribute("NS1:passwordLength").trim();
            if (passwordLength.length() > 0) {
                account.setLength(Integer.parseInt(passwordLength));
            } else {
                account.setLength(8);
            }
            account.setUsername(element.getAttribute("NS1:usernameTB").trim());
            account.setModifier(element.getAttribute("NS1:counter").trim());
            account.setCharacterSet(element.getAttribute("NS1:charset").trim());
            account.setPrefix(element.getAttribute("NS1:prefix").trim());
            account.setSuffix(element.getAttribute("NS1:suffix").trim());
            account.setAutoPop(element.getAttribute("NS1:autoPopulate").trim().compareTo("true") == 0);
            account.clearUrlComponents();
            if (element.getAttribute("NS1:protocolCB").trim().compareToIgnoreCase("true") == 0) {
                account.addUrlComponent(Account.UrlComponents.Protocol);
            }
            if (element.getAttribute("NS1:subdomainCB").trim().compareToIgnoreCase("true") == 0) {
                account.addUrlComponent(Account.UrlComponents.Subdomain);
            }
            if (element.getAttribute("NS1:domainCB").trim().compareToIgnoreCase("true") == 0) {
                account.addUrlComponent(Account.UrlComponents.Domain);
            }
            if (element.getAttribute("NS1:pathCB").trim().compareToIgnoreCase("true") == 0) {
                account.addUrlComponent(Account.UrlComponents.PortPathAnchorQuery);
            }
            account.setUrl(element.getAttribute("NS1:urlToUse").trim());
            for (int iPattern = 0; iPattern < 100000; ++iPattern) {
                String pattern = element.getAttribute("NS1:pattern" + iPattern).trim();
                String patternType = element.getAttribute("NS1:patterntype" + iPattern).trim();
                String patternEnabled = element.getAttribute("NS1:patternenabled" + iPattern).trim();
                String patternDesc = element.getAttribute("NS1:patterndesc" + iPattern).trim();
                if (pattern.length() > 0 || patternType.length() > 0 || patternEnabled.length() > 0 || patternDesc.length() > 0) {
                    AccountPatternData data = new AccountPatternData();
                    data.setPattern(pattern);
                    data.setType(AccountPatternType.fromString(patternType));
                    data.setEnabled(patternEnabled.compareTo("true") == 0);
                    data.setDesc(patternDesc);
                    account.getPatterns().add(data);
                    continue;
                }
                iPattern = 100001;
            }
        }
        return account;
    }

    private void createParentChildRelationships(Database db, HashMap<String, Account> descriptionMap, HashMap<String, ArrayList<String>> seqMap) throws Exception {
        ArrayList<String> parentIdStack = new ArrayList<String>();
        if (!seqMap.containsKey("http://passwordmaker.mozdev.org/accounts")) {
            throw new Exception("File does not contain the root account, 'http://passwordmaker.mozdev.org/accounts'");
        }
        parentIdStack.add("http://passwordmaker.mozdev.org/accounts");
        while (parentIdStack.size() > 0) {
            String parentId = (String)parentIdStack.get(0);
            Account parentAccount = descriptionMap.get(parentId);
            parentIdStack.remove(0);
            if (parentId.compareTo("http://passwordmaker.mozdev.org/accounts") != 0) {
                if (parentAccount != null) {
                    Account parentParentAccount;
                    if (db.findAccountById(parentId) == null && (parentParentAccount = db.findParent(parentAccount)) == null) {
                        this.logger.warning("SeqNode[" + parentId + "] does not have a parent, will be dropped");
                        parentAccount = null;
                    }
                } else {
                    this.logger.warning("SeqNode[" + parentId + "] does not have a matching RDF:Description node, it will be dropped");
                }
            } else {
                parentAccount = db.getRootAccount();
            }
            if (parentAccount == null) continue;
            for (String childId : seqMap.get(parentId)) {
                Account childAccount = descriptionMap.get(childId);
                if (childAccount != null) {
                    if (!parentAccount.hasChild(childAccount)) {
                        parentAccount.getChildren().add(childAccount);
                        if (!seqMap.containsKey(childAccount.getId())) continue;
                        parentIdStack.add(childId);
                        childAccount.setIsFolder(true);
                        continue;
                    }
                    this.logger.warning("Duplicate child '" + childId + "' found of parent '" + parentAccount.getId() + "'");
                    continue;
                }
                this.logger.warning("Cannot find RDF:Description for '" + childId + "', it will be dropped");
            }
        }
    }

    @Override
    public List<IncompatibleException> getIncompatibleAccounts() {
        return this.buggyAccounts;
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    public Pair<AlgorithmType, Boolean> fromRdfString(Account account, String algorithm) throws IncompatibleException {
        try {
            return AlgorithmType.fromRdfString(algorithm, this.buggyJavascriptAction == DatabaseReader.BuggyAlgoAction.CONVERT);
        }
        catch (IncompatibleException e) {
            throw new IncompatibleException("For account: " + account.getName() + "(" + account.getId() + "): " + e.getMessage());
        }
    }
}

