/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.daveware.passwordmaker.Account;
import org.daveware.passwordmaker.AccountManagerListener;
import org.daveware.passwordmaker.AlgorithmType;
import org.daveware.passwordmaker.CharacterSets;
import org.daveware.passwordmaker.Database;
import org.daveware.passwordmaker.DatabaseListener;
import org.daveware.passwordmaker.PasswordMaker;
import org.daveware.passwordmaker.SecureCharArray;
import org.daveware.passwordmaker.util.Joiner;
import org.daveware.passwordmaker.util.Splitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountManager
implements DatabaseListener {
    private final CopyOnWriteArrayList<AccountManagerListener> listeners = new CopyOnWriteArrayList();
    private PasswordMaker pwm = new PasswordMaker();
    private Database pwmProfiles = new Database();
    private Account selectedProfile = null;
    private List<String> favoriteUrls = new ArrayList<String>();
    private static final Account masterPwdHashAccount = AccountManager.makeDefaultAccount();
    private SecureCharArray currentPasswordHash;
    private String passwordSalt;
    private boolean storePasswordHash;

    private static Account makeDefaultAccount() {
        Account account = Account.makeDefaultAccount();
        account.setAlgorithm(AlgorithmType.MD5);
        account.setCharacterSet(CharacterSets.ALPHANUMERIC);
        return account;
    }

    public AccountManager() {
        if (this.pwmProfiles.findAccountById("http://passwordmaker.mozdev.org/defaults") == null) {
            try {
                this.pwmProfiles.addAccount(this.pwmProfiles.getRootAccount(), AccountManager.makeDefaultAccount());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isAutoSelectingAccount() {
        return this.selectedProfile == null;
    }

    public SecureCharArray generatePassword(CharSequence masterPassword, String inputText) {
        SecureCharArray securedMasterPassword = !(masterPassword instanceof SecureCharArray) ? new SecureCharArray(masterPassword.toString()) : (SecureCharArray)masterPassword;
        SecureCharArray result = null;
        try {
            Account accountToUse = this.getAccountForInputText(inputText);
            result = this.pwm.makePassword(securedMasterPassword, accountToUse, inputText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result != null) {
            return result;
        }
        return new SecureCharArray();
    }

    public Account getAccountForInputText(String inputText) {
        if (this.selectedProfile != null) {
            return this.selectedProfile;
        }
        Account account = this.pwmProfiles.findAccountByUrl(inputText);
        if (account == null) {
            return this.getDefaultAccount();
        }
        return account;
    }

    public void selectAccountById(String id) throws IllegalArgumentException {
        if (id == null) {
            this.clearSelectedAccount();
            return;
        }
        Account profile = this.pwmProfiles.findAccountById(id);
        if (profile == null) {
            throw new IllegalArgumentException("Profile by the ID of " + id + " is not found.");
        }
        this.selectedProfile = profile;
    }

    public void clearSelectedAccount() {
        this.selectedProfile = null;
    }

    public void selectAccountByUrl(String url) throws IllegalArgumentException {
        Account profile = this.pwmProfiles.findAccountByUrl(url);
        if (profile == null) {
            throw new IllegalArgumentException("No profile matching the url of " + url + " was not found.");
        }
        this.selectedProfile = profile;
    }

    public PasswordMaker getPwm() {
        return this.pwm;
    }

    public Database getPwmProfiles() {
        return this.pwmProfiles;
    }

    public Account getSelectedProfile() {
        return this.selectedProfile;
    }

    @Override
    public void accountAdded(Account parent, Account account) {
    }

    @Override
    public void accountRemoved(Account parent, Account account) {
        if (account.equals(this.selectedProfile)) {
            this.selectedProfile = null;
        }
    }

    @Override
    public void accountChanged(Account account) {
    }

    @Override
    public void dirtyStatusChanged(boolean b) {
    }

    public void addDatabaseListener(DatabaseListener listener) {
        this.pwmProfiles.addDatabaseListener(listener);
    }

    public void removeDatabaseListener(DatabaseListener listener) {
        this.pwmProfiles.removeDatabaseListener(listener);
    }

    public void addListener(AccountManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(AccountManagerListener listener) {
        this.listeners.remove(listener);
    }

    public List<String> getFavoriteUrls() {
        return this.favoriteUrls;
    }

    public void addFavoriteUrl(String url) {
        this.favoriteUrls.add(url);
    }

    public void addFavoriteUrls(Collection<String> urls) {
        this.favoriteUrls.addAll(urls);
    }

    public void removeFavoriteUrl(String url) {
        this.favoriteUrls.remove(url);
    }

    public String encodeFavoriteUrls() {
        if (!this.favoriteUrls.isEmpty()) {
            return "<" + Joiner.on(">,<").join(this.favoriteUrls) + ">";
        }
        return "";
    }

    public void decodeFavoritesUrls(String encodedUrlList, boolean clearFirst) {
        int start = 0;
        int end = encodedUrlList.length();
        if (encodedUrlList.startsWith("<")) {
            ++start;
        }
        if (encodedUrlList.endsWith(">")) {
            --end;
        }
        encodedUrlList = encodedUrlList.substring(start, end);
        if (clearFirst) {
            this.favoriteUrls.clear();
        }
        for (String url : Splitter.on(">,<").omitEmptyStrings().split(encodedUrlList)) {
            this.favoriteUrls.add(url);
        }
    }

    public Account getDefaultAccount() throws NoSuchElementException {
        Account account = this.pwmProfiles.findAccountById("http://passwordmaker.mozdev.org/defaults");
        if (account != null) {
            return account;
        }
        throw new NoSuchElementException("Unable to get default account");
    }

    public boolean matchesPasswordHash(SecureCharArray masterPassword) {
        if (!this.hasPasswordHash()) {
            return true;
        }
        SecureCharArray testPassHash = null;
        try {
            testPassHash = this.pwm.makePassword(masterPassword, masterPwdHashAccount, this.passwordSalt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return testPassHash == null || Arrays.equals(testPassHash.getData(), this.getCurrentPasswordHash().getData());
    }

    public SecureCharArray getCurrentPasswordHash() {
        return this.currentPasswordHash;
    }

    public void setCurrentPasswordHashPassword(String newPassword) {
        this.passwordSalt = UUID.randomUUID().toString();
        try {
            this.currentPasswordHash = this.pwm.makePassword(new SecureCharArray(newPassword), masterPwdHashAccount, this.getPasswordSalt());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setStorePasswordHash(true);
    }

    public void replaceCurrentPasswordHash(SecureCharArray hash, String salt) {
        if (hash.length() > 0 && salt.length() > 0) {
            this.passwordSalt = salt;
            this.currentPasswordHash = hash;
            this.setStorePasswordHash(true);
        } else {
            this.disablePasswordHash();
        }
    }

    public String getPasswordSalt() {
        return this.passwordSalt;
    }

    public boolean hasPasswordHash() {
        return this.shouldStorePasswordHash() && this.passwordSalt != null && this.passwordSalt.length() > 0 && this.currentPasswordHash != null && this.currentPasswordHash.length() > 0;
    }

    public boolean shouldStorePasswordHash() {
        return this.storePasswordHash;
    }

    public void setStorePasswordHash(boolean storePasswordHash) {
        this.storePasswordHash = storePasswordHash;
        if (!storePasswordHash) {
            this.passwordSalt = null;
            if (this.currentPasswordHash != null) {
                this.currentPasswordHash.erase();
                this.currentPasswordHash = null;
            }
        }
    }

    public void disablePasswordHash() {
        this.setStorePasswordHash(false);
    }
}

