/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import org.daveware.passwordmaker.IncompatibleException;
import org.daveware.passwordmaker.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmType
implements Comparable<AlgorithmType> {
    public static final AlgorithmType MD4 = new AlgorithmType(1, "MD4", "HMAC-MD4", "md4", "hmac-md4", true);
    public static final AlgorithmType MD5 = new AlgorithmType(2, "MD5", "HMAC-MD5", "md5", "hmac-md5", true);
    public static final AlgorithmType SHA1 = new AlgorithmType(3, "SHA1", "HMAC-SHA1", "sha1", "hmac-sha1", true);
    public static final AlgorithmType RIPEMD160 = new AlgorithmType(4, "RIPEMD160", "HMAC-RIPEMD160", "rmd160", "hmac-rmd160", true);
    public static final AlgorithmType SHA256 = new AlgorithmType(5, "SHA256", "HMAC-SHA256", "sha256", "hmac-sha256-fixed", true);
    private static final AlgorithmType[] TYPES = new AlgorithmType[]{MD4, MD5, SHA1, RIPEMD160, SHA256};
    private int type;
    private String name;
    private String hmacName;
    private boolean compatible;
    private String rdfName;
    private String rdfHmacName;

    private AlgorithmType() {
        this.type = 2;
        this.name = "";
        this.compatible = false;
        this.rdfName = "";
        this.rdfHmacName = "";
    }

    private AlgorithmType(int i, String n, String hmac, String rdfN, String rdfH, boolean c) {
        this.type = i;
        this.name = n;
        this.hmacName = hmac;
        this.compatible = c;
        this.rdfName = rdfN;
        this.rdfHmacName = rdfH;
    }

    public static AlgorithmType[] getTypes() {
        return TYPES;
    }

    public static Pair<AlgorithmType, Boolean> fromRdfString(String str, boolean convert) throws IncompatibleException {
        if (str.length() == 0) {
            return Pair.pair(MD5, true);
        }
        for (AlgorithmType algoType : TYPES) {
            String name = algoType.rdfName.toLowerCase();
            String hmacName = algoType.rdfHmacName.toLowerCase();
            if (str.compareTo(name) != 0 && str.compareTo(hmacName) != 0) continue;
            return Pair.pair(algoType, true);
        }
        if (str.compareTo("md5-v0.6") == 0 || str.compareTo("hmac-md5-v0.6") == 0) {
            return Pair.pair(MD5, false);
        }
        if (convert && str.compareTo("hmac-sha256") == 0) {
            return Pair.pair(SHA256, true);
        }
        if (str.compareTo("hmac-sha256") == 0) {
            throw new IncompatibleException("Original hmac-sha256-v1.5.1 implementation has been detected, this is not compatible with PasswordMakerJE due to a bug in the original javascript version. It is recommended that you update this account to use \"HMAC-SHA256\" in the PasswordMaker settings.");
        }
        if (str.compareTo("md5-v0.6") == 0) {
            throw new IncompatibleException("Original md5-v0.6 implementation has been detected, this is not compatible with PasswordMakerJE due to a bug in the original javascript version. It is recommended that you update this account to use \"MD5\" in the PasswordMaker settings.");
        }
        if (str.compareTo("hmac-md5-v0.6") == 0) {
            throw new IncompatibleException("Original hmac-md5-v0.6 implementation has been detected, this is not compatible with PasswordMakerJE due to a bug in the original javascript version. It is recommended that you update this account to use \"HMAC-MD5\" in the PasswordMaker settings.");
        }
        throw new IncompatibleException(String.format("Invalid algorithm type '%1s'", str));
    }

    public String getName() {
        return this.toString();
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }

    public String toRdfString() {
        return this.rdfName;
    }

    public String toHmacRdfString() {
        return this.rdfHmacName;
    }

    @Override
    public int compareTo(AlgorithmType o) {
        if (this.type < o.type) {
            return -1;
        }
        if (this.type > o.type) {
            return 1;
        }
        return 0;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public String getHmacName() {
        return this.hmacName;
    }
}

